/*
 * Decompiled with CFR 0.152.
 */
package JDeco;

import JDeco.CalculateDiveSeries;
import JDeco.CalculateDiveSeriesVPMB;
import JDeco.DiveData;
import JDeco.GasData;
import JDeco.GasMixing;
import JDeco.JDeco;
import JDeco.MathFP;
import JDeco.SettingsData;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class UserInterface
extends Thread
implements CommandListener {
    private static int AlertTimeSplashNonRegistered = 1000;
    private static int AlertTimeSplashRegistration = 1000;
    private String diveSerieTextFormTitle = "DIVE SERIES";
    private String diveSerieTextCommandAddDive = "Add Dive";
    private String diveSerieTextCommandDeleteSerie = "Delete Series";
    private String diveSerieTextCommandEditLastDive = "Edit Dive";
    private String diveSerieTextCommandDeleteLastDive = "Delete Dive";
    private String diveSerieTextCommandOptions = "Main Menu";
    private String diveSerieTextSurfaceInterval = "Surface Interval";
    private String diveSerieTextDive = "Dive";
    private String diveSerieTextNoDecoGases = "No Deco Gases";
    private String diveSerieTextNoDives = "No dives in series";
    private String diveSerieTextmaxPPO2 = "Max PPO2";
    private String diveSerieTextGasSwitches = "Gas Switches";
    private String startTextCommandExit = "Exit JDeco";
    private String startTextCommandDiveSerie = "Dive Series";
    private String startTextCommandMixes = "Mixes";
    private String startTextCommandSettings = "Program Settings";
    private String startTextCommandSettings2 = "Dive Settings";
    private String startTextCommandRegister = "Register";
    private String startTextCommandAbout = "Help";
    private String startText = "Dive decompression calculation based on B\u00fchlmann ZH-L16B/GF with Erik Baker's Gradient Factors and the VPM-B algorithm.\n";
    private String disclaimerText = "By using JDeco you agree that you have read, understood, and agreed to the disclaimer on www.jdeco.de and that you use JDeco completely on your own risk.";
    private String startTextCommandMixTool = "Mix Tools";
    private String settingsTextCommandOK = "Save";
    private String settingsTextCommandCancel = "Cancel";
    private String settingsTextFormTitle = "PROGRAM SETTINGS";
    private String settings2TextFormTitle = "DIVE SETTINGS";
    private String settingsTextAltitude = "Altitude";
    private String settingsTextGradientFactors = "Gradient Factors";
    private String settingsTextGFLow = "Low (%)";
    private String settingsTextGFHigh = "High (%)";
    private String settingsTextRMV = "Gas Usage";
    private String settingsTextInitialDescent = "Initial Descent";
    private String settingsTextRates = "Depth Change Rates";
    private String settingsTextLastStop = "Last Stop";
    private String settingsTextLastStopDepth = "Depth (m)";
    private String settingsTextLastStopRate = "Rate (m/min)";
    private String settingsTextStepSize = "Deco Step Size";
    private String settingsTextmaxDivePPO2 = "Max Dive PPO2";
    private String settingsTextmaxDecoPPO2 = "Max Deco PPO2";
    private String mixesTextCommandOK = "Save";
    private String mixesTextCommandCancel = "Cancel";
    private String mixesTextFormTitle = "GAS MIXES";
    private String mixesTextMix = "Mix";
    private String mixesTextO2 = "O2 (%)";
    private String mixesTextHe = "He (%)";
    private boolean running;
    private boolean calcReady = false;
    public boolean bailoutFlag = false;
    public int bailoutGasLoss;
    public boolean bailoutCCRFlag = false;
    private SettingsData sd;
    private GasData gd;
    private DiveData dd;
    private CalculateDiveSeries calcDS;
    private CalculateDiveSeriesVPMB calcDSVPMB;
    private GasMixing calcGasMixing;
    private Display display;
    private JDeco JD;
    private long[][][] Dive_Profile;
    private long[][][] Deco_Settings;
    private long[] Surface_Interval;
    private Alert alertScreen;
    private Form startForm;
    private Form diveSerieForm;
    private Form diveAddEditForm;
    private Form mixesForm;
    private Form settingsForm;
    private Form settingsForm2;
    private Form diveDataForm;
    private Form registrationForm;
    private Form infoCalculationForm;
    private Form toolsForm;
    private Form mixToolForm;
    private Form toppingToolForm;
    private Form bestmixToolForm;
    private Command exitCommand = new Command(this.startTextCommandExit, 8, 1);
    private Command diveSerieCommand = new Command(this.startTextCommandDiveSerie, 8, 1);
    private Command mixesCommand = new Command(this.startTextCommandMixes, 8, 1);
    private Command settingsCommand = new Command(this.startTextCommandSettings, 8, 1);
    private Command settings2Command = new Command(this.startTextCommandSettings2, 8, 1);
    private Command registerCommand = new Command(this.startTextCommandRegister, 8, 1);
    private Command aboutCommand = new Command(this.startTextCommandAbout, 8, 1);
    private Command toolsCommand = new Command(this.startTextCommandMixTool, 8, 1);
    private Command bestmixToolCommand = new Command("Best Mix", 8, 1);
    private Command toppingToolCommand = new Command("VdW Mix Topping", 8, 1);
    private Command mixToolCommand = new Command("VdW Gas Mixing", 8, 1);
    private Command exitToolCommand = new Command("Main Menu", 8, 1);
    private Command calcMixCommand = new Command("Calculate", 8, 1);
    private Command backMixCommand = new Command("Back", 8, 1);
    private Command calcToppingCommand = new Command("Calculate", 8, 1);
    private Command backToppingCommand = new Command("Back", 8, 1);
    private Command calcBestmixCommand = new Command("Calculate", 8, 1);
    private Command backBestmixCommand = new Command("Back", 8, 1);
    private Command calculateCommand;
    private Command calculateCommand2;
    private Command addDiveCommand = new Command(this.diveSerieTextCommandAddDive, 8, 1);
    private Command editLastDiveCommand = new Command(this.diveSerieTextCommandEditLastDive, 8, 1);
    private Command deleteLastDiveCommand = new Command(this.diveSerieTextCommandDeleteLastDive, 8, 1);
    private Command deleteDiveSerieCommand = new Command(this.diveSerieTextCommandDeleteSerie, 8, 1);
    private Command mainMenuCommand = new Command(this.diveSerieTextCommandOptions, 8, 1);
    private Command okMixCommand = new Command(this.mixesTextCommandOK, 4, 1);
    private Command cancelMixCommand = new Command(this.mixesTextCommandCancel, 2, 1);
    private Command okSettingsCommand = new Command(this.settingsTextCommandOK, 4, 1);
    private Command cancelSettingsCommand = new Command(this.settingsTextCommandCancel, 2, 1);
    private Command okSettings2Command = new Command(this.settingsTextCommandOK, 4, 1);
    private Command cancelSettings2Command = new Command(this.settingsTextCommandCancel, 2, 1);
    private Command okDiveDataCommand = new Command("OK", 4, 1);
    private Command calcPlusXmin;
    private Command calcMinusXmin;
    private Command calcPlusXmeter;
    private Command calcMinusXmeter;
    private Command calcCCRBailout = new Command("Bailout Plan", 8, 1);
    private Command[] calcBailout = new Command[JDeco.MAX_DECO_MIXES];
    private Command okDiveAddCommand = new Command("Save", 4, 1);
    private Command cancelDiveAddCommand = new Command("Cancel", 2, 1);
    private Command okDiveEditCommand = new Command("Save Changes", 4, 1);
    private Command cancelDiveEditCommand = new Command("Cancel", 2, 1);
    private Command okRegisterCommand = new Command("Register", 4, 1);
    private Command cancelRegisterCommand = new Command("Cancel", 2, 1);
    private TextField[] addEditDiveLevelsDepth;
    private TextField[] addEditDiveLevelsTime;
    private TextField[] addEditDiveLevelsPPO2;
    private ChoiceGroup[] addEditDiveLevelsGas;
    private TextField[] addEditDecoSwitchDepthGas;
    private TextField[] addStopTime;
    private TextField addEditSurfaceInterval;
    private TextField[] addEditDecoCCRDepth;
    private TextField[] addEditDecoCCRPPO2;
    private ChoiceGroup[] addEditDecoCCRGas;
    private boolean deepBailOutMixError = false;
    private boolean OCPPO2Error = false;
    private ChoiceGroup startViewChoice;
    private TextField editNumberLevels;
    private ChoiceGroup OCSCRCCRChoice;
    private ChoiceGroup stopOrRunTimeChoice;
    private TextField editAltitude_of_Dive;
    private TextField editGradient_Factor_Lo;
    private TextField editGradient_Factor_Hi;
    private TextField editRMV_During_Dive;
    private TextField editRMV_During_Deco;
    private TextField editRate_Initial_Descent;
    private TextField editRate_During_Dive;
    private TextField editRate_During_Deco;
    private TextField editRate_Last_Deco_Stop;
    private TextField editDeco_Stop_Step_Size;
    private TextField editLast_Deco_Stop_Depth;
    private TextField editMax_PO2_Dive;
    private TextField editMax_PO2_Deco;
    private ChoiceGroup algorithmChoice;
    private ChoiceGroup editCriticalVolume;
    private ChoiceGroup editConservativity;
    private TextField editCustomChangeTime;
    private TextField editCustomChangeDepth;
    private TextField mixO2TopText;
    private TextField mixHeTopText;
    private TextField mixO2EndText;
    private TextField mixHeEndText;
    private TextField mixPEndText;
    private TextField mixO2StartText;
    private TextField mixHeStartText;
    private TextField mixPStartText;
    private TextField mixTText;
    private TextField mixVText;
    private ChoiceGroup mixFillO2First;
    public long mixO2Top = -1L;
    public long mixHeTop = -1L;
    public long mixO2End = -1L;
    public long mixHeEnd = -1L;
    public long mixPEnd = -1L;
    public long mixO2Start = -1L;
    public long mixHeStart = -1L;
    public long mixPStart = -1L;
    public long mixT = -1L;
    public long mixV = -1L;
    public boolean mixO2First = false;
    private boolean doMix;
    public long[] PMixData = new long[]{0L, 0L, 0L};
    public long[] PTopData = new long[]{0L, 0L};
    private String resultTextMix;
    private TextField bestmixDepth;
    private TextField bestmixPPO2;
    private TextField bestmixmaxEND;
    private ChoiceGroup bestmixO2narcotic;
    private TextField[] mixOxygen;
    private TextField[] mixHelium;
    private TextField[] CylinderVolume;
    private ChoiceGroup[] editDecoMixFlag;
    private TextField registrationKeyEntered;
    public long[] Segment_Depth_Last_Dive;
    public long[] Segment_Time_Last_Dive;
    public long[] Segment_Mix_Last_Dive;
    public long[] Segment_PPO2_Last_Dive;
    public long[] Segment_DECOFlag_Last_Dive;
    public long[] Run_Time_Last_Dive;
    public long[] Needed_Gas_Last_Dive;
    public long[] Running_Gas_Volume;
    public long Complete_Runtime;
    public long RunTimeInitialDescent;
    public String computationError = null;
    public boolean directAscentMessage = false;
    public long diveCNS;
    public long diveOTU;
    public long diveseriesOTU;
    private RecordStore settingsStore;
    private RecordStore gasdataStore;
    private RecordStore divedataStore;

    public UserInterface(Display display, JDeco jDeco) {
        System.gc();
        this.display = display;
        this.JD = jDeco;
        this.initialize();
    }

    public void run() {
        this.running = true;
        this.dd.Dive_Profile[0][0][0] = 9999L;
        if (JDeco.registered) {
            this.loadSettingsData();
            this.loadGasData();
            this.loadDiveData();
            if (this.sd.startView == 0) {
                this.startForm = this.buildStartForm();
                this.display.setCurrent((Displayable)this.startForm);
            } else if (this.sd.startView == 1) {
                this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
                this.display.setCurrent((Displayable)this.diveSerieForm);
            } else if (this.sd.startView == 2) {
                this.toolsForm = this.buildToolsForm();
                this.display.setCurrent((Displayable)this.toolsForm);
            }
        } else {
            this.startForm = this.buildStartForm();
            this.alertScreen = this.buildAlert("JDeco" + " " + "4.0 - Metric", "www.jdeco.de\n\nUnregistered Version", AlertType.INFO, AlertTimeSplashNonRegistered);
            this.display.setCurrent(this.alertScreen, (Displayable)this.startForm);
            this.alertScreen = null;
        }
        while (this.running) {
            try {
                UserInterface.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.calcDSVPMB != null) {
                if (this.calcDSVPMB.calculationReady) {
                    this.calcDSVPMB.stopIt();
                    this.calcDSVPMB = null;
                    this.calcReady = true;
                }
            } else if (this.calcDS != null && this.calcDS.calculationReady) {
                this.calcDS.stopIt();
                this.calcDS = null;
                this.calcReady = true;
            }
            if (this.calcReady) {
                this.calcReady = false;
                this.infoCalculationForm = null;
                if (this.computationError == null) {
                    this.diveDataForm = this.sd.JDeco_Type == 0 ? this.buildDiveDataForm(this.Segment_Depth_Last_Dive, this.Segment_Time_Last_Dive, this.Run_Time_Last_Dive, this.Needed_Gas_Last_Dive, this.Segment_Mix_Last_Dive, this.Segment_DECOFlag_Last_Dive) : this.buildDiveDataFormCCR(this.Segment_Depth_Last_Dive, this.Segment_Time_Last_Dive, this.Run_Time_Last_Dive, this.Needed_Gas_Last_Dive, this.Segment_Mix_Last_Dive, this.Segment_PPO2_Last_Dive, this.Segment_DECOFlag_Last_Dive);
                    this.display.setCurrent((Displayable)this.diveDataForm);
                } else {
                    this.alertScreen = this.directAscentMessage ? this.buildAlert("Result", this.computationError, AlertType.ERROR, -2) : this.buildAlert("ERROR", this.computationError, AlertType.ERROR, -2);
                    this.directAscentMessage = false;
                    this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
                    this.display.setCurrent(this.alertScreen, (Displayable)this.diveSerieForm);
                    this.computationError = null;
                }
            }
            if (this.calcGasMixing == null || !this.calcGasMixing.calculationReady) continue;
            if (this.calcGasMixing.doMix) {
                this.doMix = true;
                this.PMixData[0] = this.calcGasMixing.PMixData[0];
                this.PMixData[1] = this.calcGasMixing.PMixData[1];
                this.PMixData[2] = this.calcGasMixing.PMixData[2];
            } else {
                this.doMix = false;
                this.PTopData[0] = this.calcGasMixing.PTopData[0];
                this.PTopData[1] = this.calcGasMixing.PTopData[1];
            }
            this.calcGasMixing.stopIt();
            this.calcGasMixing = null;
            this.infoCalculationForm = null;
            if (this.computationError == null) {
                if (this.doMix) {
                    this.resultTextMix = "";
                    if (this.mixO2First) {
                        if (this.PMixData[1] > 0L) {
                            this.resultTextMix = this.resultTextMix + "Fill O2 to:" + " " + Long.toString(this.PMixData[1]) + "bar\n";
                        }
                        if (this.PMixData[0] > 0L) {
                            this.resultTextMix = this.resultTextMix + "Fill He to:" + " " + Long.toString(this.PMixData[0]) + "bar\n";
                        }
                        this.resultTextMix = this.resultTextMix + "Fill Air to:" + " " + Long.toString(this.PMixData[2]) + "bar\n";
                    } else {
                        if (this.PMixData[0] > 0L) {
                            this.resultTextMix = this.resultTextMix + "Fill He to:" + " " + Long.toString(this.PMixData[0]) + "bar\n";
                        }
                        if (this.PMixData[1] > 0L) {
                            this.resultTextMix = this.resultTextMix + "Fill O2 to:" + " " + Long.toString(this.PMixData[1]) + "bar\n";
                        }
                        this.resultTextMix = this.resultTextMix + "Fill Air to:" + " " + Long.toString(this.PMixData[2]) + "bar\n";
                    }
                    this.alertScreen = this.buildAlert("Gas Mixing", this.resultTextMix, AlertType.ERROR, -2);
                    this.mixToolForm = this.buildMixToolForm();
                    this.display.setCurrent(this.alertScreen, (Displayable)this.mixToolForm);
                    continue;
                }
                this.resultTextMix = "O2: " + Long.toString(this.PTopData[1]) + "%\n";
                this.resultTextMix = this.resultTextMix + "He: " + Long.toString(this.PTopData[0]) + "%\n";
                this.alertScreen = this.buildAlert("Mix Topping", this.resultTextMix, AlertType.ERROR, -2);
                this.toppingToolForm = this.buildToppingToolForm();
                this.display.setCurrent(this.alertScreen, (Displayable)this.toppingToolForm);
                continue;
            }
            this.alertScreen = this.buildAlert("ERROR", this.computationError, AlertType.ERROR, -2);
            if (this.doMix) {
                this.mixToolForm = this.buildMixToolForm();
                this.display.setCurrent(this.alertScreen, (Displayable)this.mixToolForm);
            } else {
                this.toppingToolForm = this.buildToppingToolForm();
                this.display.setCurrent(this.alertScreen, (Displayable)this.toppingToolForm);
            }
            this.computationError = null;
        }
    }

    public void stopIt() {
        this.running = false;
    }

    public void initialize() {
        this.sd = new SettingsData();
        this.gd = new GasData(this.JD);
        this.dd = new DiveData(this.JD);
        this.dd.Dive_Profile[0][0][0] = 9999L;
        this.addEditDiveLevelsDepth = new TextField[JDeco.MAX_LEVELS];
        this.addEditDiveLevelsTime = new TextField[JDeco.MAX_LEVELS];
        this.addEditDiveLevelsPPO2 = new TextField[JDeco.MAX_LEVELS];
        this.addEditDiveLevelsGas = new ChoiceGroup[JDeco.MAX_LEVELS];
        this.addEditDecoCCRDepth = new TextField[JDeco.MAX_CCR_DECO_SETTINGS];
        this.addEditDecoCCRPPO2 = new TextField[JDeco.MAX_CCR_DECO_SETTINGS];
        this.addEditDecoCCRGas = new ChoiceGroup[JDeco.MAX_CCR_DECO_SETTINGS];
        this.addEditDecoSwitchDepthGas = new TextField[JDeco.MAX_MIXES];
        this.addStopTime = new TextField[JDeco.MAX_DECO_MIXES];
        this.mixOxygen = new TextField[JDeco.MAX_MIXES];
        this.mixHelium = new TextField[JDeco.MAX_MIXES];
        this.CylinderVolume = new TextField[JDeco.MAX_MIXES];
        this.editDecoMixFlag = new ChoiceGroup[JDeco.MAX_MIXES];
        this.Segment_Depth_Last_Dive = new long[JDeco.MAX_SEGMENTS + 1];
        this.Segment_Time_Last_Dive = new long[JDeco.MAX_SEGMENTS + 1];
        this.Segment_Mix_Last_Dive = new long[JDeco.MAX_SEGMENTS + 1];
        this.Segment_DECOFlag_Last_Dive = new long[JDeco.MAX_SEGMENTS + 1];
        this.Segment_PPO2_Last_Dive = new long[JDeco.MAX_SEGMENTS + 1];
        this.Run_Time_Last_Dive = new long[JDeco.MAX_SEGMENTS + 1];
        this.Needed_Gas_Last_Dive = new long[JDeco.MAX_MIXES + 1];
        this.Running_Gas_Volume = new long[JDeco.MAX_MIXES + 1];
        if (this.gd.Fraction_Oxygen[0] == 9999L) {
            if (JDeco.registered) {
                this.gd.Fraction_Oxygen[0] = 21L;
                this.gd.Fraction_Helium[0] = 0L;
                this.gd.Fraction_Nitrogen[0] = 79L;
                this.gd.Mix_Name[0] = "Air";
                this.gd.Cylinder_Volume[0] = 24L;
                this.gd.DecoMix_Flag[0] = 0;
                this.gd.Fraction_Oxygen[1] = 100L;
                this.gd.Fraction_Helium[1] = 0L;
                this.gd.Fraction_Nitrogen[1] = 0L;
                this.gd.Mix_Name[1] = "O2";
                this.gd.Cylinder_Volume[1] = 7L;
                this.gd.DecoMix_Flag[1] = 1;
                this.gd.Fraction_Oxygen[2] = 50L;
                this.gd.Fraction_Helium[2] = 0L;
                this.gd.Fraction_Nitrogen[2] = 50L;
                this.gd.Mix_Name[2] = "EAN50";
                this.gd.Cylinder_Volume[2] = 7L;
                this.gd.DecoMix_Flag[2] = 1;
                this.gd.Fraction_Oxygen[3] = 9999L;
            } else {
                this.gd.Fraction_Oxygen[0] = 21L;
                this.gd.Fraction_Helium[0] = 0L;
                this.gd.Fraction_Nitrogen[0] = 79L;
                this.gd.Mix_Name[0] = "Air";
                this.gd.Cylinder_Volume[0] = 24L;
                this.gd.DecoMix_Flag[0] = 0;
                this.gd.Fraction_Oxygen[1] = 9999L;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void commandAction(Command var1_1, Displayable var2_2) {
        block231: {
            block239: {
                block238: {
                    block237: {
                        block236: {
                            block235: {
                                block234: {
                                    block233: {
                                        block232: {
                                            block228: {
                                                block230: {
                                                    block229: {
                                                        block226: {
                                                            this.startForm = null;
                                                            this.diveSerieForm = null;
                                                            this.diveAddEditForm = null;
                                                            this.mixesForm = null;
                                                            this.settingsForm = null;
                                                            this.settingsForm2 = null;
                                                            this.diveDataForm = null;
                                                            this.registrationForm = null;
                                                            this.infoCalculationForm = null;
                                                            this.toolsForm = null;
                                                            this.mixToolForm = null;
                                                            this.toppingToolForm = null;
                                                            this.bestmixToolForm = null;
                                                            this.calcDS = null;
                                                            this.calcDSVPMB = null;
                                                            this.calcGasMixing = null;
                                                            this.alertScreen = null;
                                                            System.gc();
                                                            this.bailoutCCRFlag = false;
                                                            this.bailoutFlag = false;
                                                            if (var1_1 == this.exitCommand) {
                                                                this.JD.endMIDlet();
                                                            }
                                                            if (var1_1 == this.diveSerieCommand) {
                                                                this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
                                                                this.display.setCurrent((Displayable)this.diveSerieForm);
                                                            }
                                                            if (var1_1 == this.mixesCommand) {
                                                                this.mixesForm = this.buildMixesForm();
                                                                this.display.setCurrent((Displayable)this.mixesForm);
                                                            }
                                                            if (var1_1 == this.settingsCommand) {
                                                                this.settingsForm = this.buildSettingsForm();
                                                                this.display.setCurrent((Displayable)this.settingsForm);
                                                            }
                                                            if (var1_1 == this.settings2Command) {
                                                                this.settingsForm2 = this.buildSettingsForm2();
                                                                this.display.setCurrent((Displayable)this.settingsForm2);
                                                            }
                                                            if (var1_1 == this.toolsCommand) {
                                                                this.toolsForm = this.buildToolsForm();
                                                                this.display.setCurrent((Displayable)this.toolsForm);
                                                            }
                                                            if (var1_1 == this.aboutCommand) {
                                                                this.alertScreen = this.buildAlert("JDeco" + " " + "4.0 - Metric", "Please read the manual on www.jdeco.de/manual.html\n", AlertType.INFO, -2);
                                                                this.startForm = this.buildStartForm();
                                                                this.display.setCurrent(this.alertScreen, (Displayable)this.startForm);
                                                                this.alertScreen = null;
                                                            }
                                                            if (var1_1 == this.registerCommand) {
                                                                this.registrationForm = this.buildRegistrationForm();
                                                                this.display.setCurrent((Displayable)this.registrationForm);
                                                            }
                                                            if (var1_1 == this.toppingToolCommand) {
                                                                this.toppingToolForm = this.buildToppingToolForm();
                                                                this.display.setCurrent((Displayable)this.toppingToolForm);
                                                            }
                                                            if (var1_1 == this.mixToolCommand) {
                                                                this.mixToolForm = this.buildMixToolForm();
                                                                this.display.setCurrent((Displayable)this.mixToolForm);
                                                            }
                                                            if (var1_1 == this.bestmixToolCommand) {
                                                                this.bestmixToolForm = this.buildBestmixToolForm();
                                                                this.display.setCurrent((Displayable)this.bestmixToolForm);
                                                            }
                                                            if (var1_1 == this.exitToolCommand) {
                                                                this.startForm = this.buildStartForm();
                                                                this.display.setCurrent((Displayable)this.startForm);
                                                            }
                                                            if (var1_1 == this.backMixCommand || var1_1 == this.backToppingCommand || var1_1 == this.backBestmixCommand) {
                                                                this.toolsForm = this.buildToolsForm();
                                                                this.display.setCurrent((Displayable)this.toolsForm);
                                                            }
                                                            if (var1_1 == this.calcMixCommand) {
                                                                var3_3 = false;
                                                                if (this.mixO2EndText.size() != 0) {
                                                                    this.mixO2End = Long.parseLong(this.mixO2EndText.getString());
                                                                    if (this.mixO2End < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixHeEndText.size() != 0) {
                                                                    this.mixHeEnd = Long.parseLong(this.mixHeEndText.getString());
                                                                    if (this.mixHeEnd < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixPEndText.size() != 0) {
                                                                    this.mixPEnd = Long.parseLong(this.mixPEndText.getString());
                                                                    if (this.mixPEnd <= 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixO2StartText.size() != 0) {
                                                                    this.mixO2Start = Long.parseLong(this.mixO2StartText.getString());
                                                                    if (this.mixO2Start < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixHeStartText.size() != 0) {
                                                                    this.mixHeStart = Long.parseLong(this.mixHeStartText.getString());
                                                                    if (this.mixHeStart < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixPStartText.size() != 0) {
                                                                    this.mixPStart = Long.parseLong(this.mixPStartText.getString());
                                                                    if (this.mixPStart < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                this.mixO2First = this.mixFillO2First.isSelected(0) != false;
                                                                if (this.mixTText.size() != 0) {
                                                                    this.mixT = Long.parseLong(this.mixTText.getString());
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixVText.size() != 0) {
                                                                    this.mixV = Long.parseLong(this.mixVText.getString());
                                                                    if (this.mixV <= 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixPStart >= this.mixPEnd) {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixO2Start + this.mixHeStart > 100L) {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixO2End + this.mixHeEnd > 100L) {
                                                                    var3_3 = true;
                                                                }
                                                                if (var3_3) {
                                                                    this.mixToolForm = this.buildMixToolForm();
                                                                    this.alertScreen = this.buildAlert("ERROR", "Please check the values!", AlertType.ERROR, -2);
                                                                    this.display.setCurrent(this.alertScreen, (Displayable)this.mixToolForm);
                                                                } else {
                                                                    this.computationError = null;
                                                                    this.calcGasMixing = new GasMixing(this.JD, this, "mix");
                                                                    this.calcGasMixing.start();
                                                                    this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                    this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                                }
                                                            }
                                                            if (var1_1 == this.calcToppingCommand) {
                                                                var3_3 = false;
                                                                if (this.mixO2TopText.size() != 0) {
                                                                    this.mixO2Top = Long.parseLong(this.mixO2TopText.getString());
                                                                    if (this.mixO2Top < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixHeTopText.size() != 0) {
                                                                    this.mixHeTop = Long.parseLong(this.mixHeTopText.getString());
                                                                    if (this.mixHeTop < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixPEndText.size() != 0) {
                                                                    this.mixPEnd = Long.parseLong(this.mixPEndText.getString());
                                                                    if (this.mixPEnd <= 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixO2StartText.size() != 0) {
                                                                    this.mixO2Start = Long.parseLong(this.mixO2StartText.getString());
                                                                    if (this.mixO2Start < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixHeStartText.size() != 0) {
                                                                    this.mixHeStart = Long.parseLong(this.mixHeStartText.getString());
                                                                    if (this.mixHeStart < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixPStartText.size() != 0) {
                                                                    this.mixPStart = Long.parseLong(this.mixPStartText.getString());
                                                                    if (this.mixPStart < 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixTText.size() != 0) {
                                                                    this.mixT = Long.parseLong(this.mixTText.getString());
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixVText.size() != 0) {
                                                                    this.mixV = Long.parseLong(this.mixVText.getString());
                                                                    if (this.mixV <= 0L) {
                                                                        var3_3 = true;
                                                                    }
                                                                } else {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixPStart >= this.mixPEnd) {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixO2Start + this.mixHeStart > 100L) {
                                                                    var3_3 = true;
                                                                }
                                                                if (this.mixO2Top + this.mixHeTop > 100L) {
                                                                    var3_3 = true;
                                                                }
                                                                if (var3_3) {
                                                                    this.toppingToolForm = this.buildToppingToolForm();
                                                                    this.alertScreen = this.buildAlert("ERROR", "Please check the values!", AlertType.ERROR, -2);
                                                                    this.display.setCurrent(this.alertScreen, (Displayable)this.toppingToolForm);
                                                                } else {
                                                                    this.computationError = null;
                                                                    this.calcGasMixing = new GasMixing(this.JD, this, "top");
                                                                    this.calcGasMixing.start();
                                                                    this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                    this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                                }
                                                            }
                                                            if (var1_1 == this.calcBestmixCommand) {
                                                                if (this.bestmixDepth.size() != 0 && this.bestmixPPO2.size() != 0 && this.bestmixmaxEND.size() != 0) {
                                                                    var4_11 = MathFP.toFP(this.bestmixDepth.getString());
                                                                    var6_17 = MathFP.div(MathFP.toFP(this.bestmixPPO2.getString()), MathFP.toFP(10));
                                                                    var8_19 = MathFP.toFP(this.bestmixmaxEND.getString());
                                                                    var10_22 = false;
                                                                    if (this.bestmixO2narcotic.getString(this.bestmixO2narcotic.getSelectedIndex()).equals("Yes")) {
                                                                        var10_22 = true;
                                                                    }
                                                                    var11_24 = this.getBarometricPressure(this.sd.Altitude_of_Dive);
                                                                    var15_27 = var10_22 != false ? MathFP.floor(MathFP.div(MathFP.mul(var8_19 + var11_24, MathFP.toFP(100)), var4_11 + var11_24) - var13_25) : MathFP.floor(MathFP.div(MathFP.mul(var8_19 + var11_24, MathFP.toFP(79)), var4_11 + var11_24));
                                                                    if (var15_27 + (var13_25 = MathFP.floor(MathFP.div(MathFP.mul(MathFP.mul(var6_17, MathFP.toFP(100)), MathFP.toFP(10)), var4_11 + var11_24))) < MathFP.toFP(100)) {
                                                                        var17_29 = MathFP.toFP(100) - var15_27 - var13_25;
                                                                    } else {
                                                                        var15_27 = MathFP.toFP(100) - var13_25;
                                                                        var17_29 = 0L;
                                                                    }
                                                                    var19_31 = var10_22 != false ? MathFP.mul(MathFP.div(var15_27 + var13_25, MathFP.toFP(100)), var4_11 + var11_24) - var11_24 : MathFP.mul(MathFP.div(var15_27, MathFP.toFP(79)), var4_11 + var11_24) - var11_24;
                                                                    if (var19_31 < 0L) {
                                                                        var19_31 = 0L;
                                                                    }
                                                                    var3_4 = "Best mix for given data at current dive altitude is\nO2%: " + Long.toString(MathFP.toLong(MathFP.round(var13_25, 0))) + "\n" + "He%: " + Long.toString(MathFP.toLong(MathFP.round(var17_29, 0))) + "\n" + "END(m): " + Long.toString(MathFP.toLong(MathFP.round(var19_31, 0)));
                                                                } else {
                                                                    var3_4 = "Please fill in all the fields!";
                                                                }
                                                                this.alertScreen = this.buildAlert("Best Mix", var3_4, AlertType.INFO, -2);
                                                                this.bestmixToolForm = this.buildBestmixToolForm();
                                                                this.display.setCurrent(this.alertScreen, (Displayable)this.bestmixToolForm);
                                                                this.alertScreen = null;
                                                            }
                                                            if (var1_1 == this.mainMenuCommand) {
                                                                this.startForm = this.buildStartForm();
                                                                this.display.setCurrent((Displayable)this.startForm);
                                                            }
                                                            if (var1_1 == this.deleteDiveSerieCommand) {
                                                                this.dd.Dive_Profile[0][0][0] = 9999L;
                                                                this.saveDiveData();
                                                                this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
                                                                this.display.setCurrent((Displayable)this.diveSerieForm);
                                                            }
                                                            if (var1_1 == this.addDiveCommand) {
                                                                this.diveAddEditForm = this.sd.JDeco_Type == 0 ? this.buildDiveAddEditForm("add") : this.buildDiveAddEditFormCCR("add");
                                                                this.display.setCurrent((Displayable)this.diveAddEditForm);
                                                            }
                                                            if (var1_1 == this.editLastDiveCommand) {
                                                                this.diveAddEditForm = this.sd.JDeco_Type == 0 ? this.buildDiveAddEditForm("edit") : this.buildDiveAddEditFormCCR("edit");
                                                                this.display.setCurrent((Displayable)this.diveAddEditForm);
                                                            }
                                                            if (var1_1 == this.deleteLastDiveCommand) {
                                                                var3_5 = 0;
                                                                while (this.dd.Dive_Profile[var3_5][0][0] != 9999L) {
                                                                    ++var3_5;
                                                                }
                                                                if (var3_5 > 0) {
                                                                    this.dd.Dive_Profile[var3_5 - 1][0][0] = 9999L;
                                                                }
                                                                this.saveDiveData();
                                                                this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
                                                                this.display.setCurrent((Displayable)this.diveSerieForm);
                                                            }
                                                            if (var1_1 == this.calculateCommand) {
                                                                this.computationError = null;
                                                                if (this.sd.VPMBalgorithm) {
                                                                    this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDSVPMB.start();
                                                                } else {
                                                                    this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDS.start();
                                                                }
                                                                this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                            }
                                                            if (var1_1 == this.calculateCommand2) {
                                                                this.sd.VPMBalgorithm = this.sd.VPMBalgorithm == false;
                                                                this.computationError = null;
                                                                if (this.sd.VPMBalgorithm) {
                                                                    this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDSVPMB.start();
                                                                } else {
                                                                    this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDS.start();
                                                                }
                                                                this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                            }
                                                            if (var1_1 == this.okDiveDataCommand) {
                                                                this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
                                                                this.display.setCurrent((Displayable)this.diveSerieForm);
                                                            }
                                                            if (var1_1 == this.calcPlusXmin) {
                                                                var3_6 = 0;
                                                                while (this.dd.Dive_Profile[var3_6][0][0] != 9999L) {
                                                                    ++var3_6;
                                                                }
                                                                var4_12 = 0;
                                                                while (this.dd.Dive_Profile[var3_6 - 1][var4_12][0] != 999L) {
                                                                    ++var4_12;
                                                                }
                                                                this.dd.Dive_Profile[var3_6 - 1][var4_12 - 1][1] = this.dd.Dive_Profile[var3_6 - 1][var4_12 - 1][1] + this.sd.Change_Time;
                                                                this.computationError = null;
                                                                if (this.sd.VPMBalgorithm) {
                                                                    this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDSVPMB.start();
                                                                } else {
                                                                    this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDS.start();
                                                                }
                                                                this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                            }
                                                            if (var1_1 == this.calcMinusXmin) {
                                                                var3_7 = 0;
                                                                while (this.dd.Dive_Profile[var3_7][0][0] != 9999L) {
                                                                    ++var3_7;
                                                                }
                                                                var4_13 = 0;
                                                                while (this.dd.Dive_Profile[var3_7 - 1][var4_13][0] != 999L) {
                                                                    ++var4_13;
                                                                }
                                                                if (this.dd.Dive_Profile[var3_7 - 1][var4_13 - 1][1] > 5L) {
                                                                    this.dd.Dive_Profile[var3_7 - 1][var4_13 - 1][1] = this.dd.Dive_Profile[var3_7 - 1][var4_13 - 1][1] - this.sd.Change_Time;
                                                                    this.computationError = null;
                                                                    if (this.sd.VPMBalgorithm) {
                                                                        this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                        this.calcDSVPMB.start();
                                                                    } else {
                                                                        this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                        this.calcDS.start();
                                                                    }
                                                                    this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                    this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                                }
                                                            }
                                                            if (var1_1 == this.calcPlusXmeter) {
                                                                var3_8 = 0;
                                                                while (this.dd.Dive_Profile[var3_8][0][0] != 9999L) {
                                                                    ++var3_8;
                                                                }
                                                                var4_14 = 0;
                                                                while (this.dd.Dive_Profile[var3_8 - 1][var4_14][0] != 999L) {
                                                                    ++var4_14;
                                                                }
                                                                this.dd.Dive_Profile[var3_8 - 1][var4_14 - 1][0] = this.dd.Dive_Profile[var3_8 - 1][var4_14 - 1][0] + this.sd.Change_Depth;
                                                                this.computationError = null;
                                                                if (this.sd.VPMBalgorithm) {
                                                                    this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDSVPMB.start();
                                                                } else {
                                                                    this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDS.start();
                                                                }
                                                                this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                            }
                                                            if (var1_1 == this.calcMinusXmeter) {
                                                                var3_9 = 0;
                                                                while (this.dd.Dive_Profile[var3_9][0][0] != 9999L) {
                                                                    ++var3_9;
                                                                }
                                                                var4_15 = 0;
                                                                while (this.dd.Dive_Profile[var3_9 - 1][var4_15][0] != 999L) {
                                                                    ++var4_15;
                                                                }
                                                                if (this.dd.Dive_Profile[var3_9 - 1][var4_15 - 1][0] > 10L) {
                                                                    this.dd.Dive_Profile[var3_9 - 1][var4_15 - 1][0] = this.dd.Dive_Profile[var3_9 - 1][var4_15 - 1][0] - this.sd.Change_Depth;
                                                                    this.computationError = null;
                                                                    if (this.sd.VPMBalgorithm) {
                                                                        this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                        this.calcDSVPMB.start();
                                                                    } else {
                                                                        this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                        this.calcDS.start();
                                                                    }
                                                                    this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                    this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                                }
                                                            }
                                                            var3_10 = 0;
                                                            while (this.dd.Dive_Profile[var3_10][0][0] != 9999L) {
                                                                ++var3_10;
                                                            }
                                                            if (var3_10 > 0) {
                                                                var4_16 = 0;
                                                                while (this.dd.Deco_Settings[var3_10 - 1][var4_16][0] != 999L) {
                                                                    ++var4_16;
                                                                }
                                                                var5_32 = 0;
                                                                while (true) {
                                                                    if (var5_32 >= JDeco.MAX_DECO_MIXES) break;
                                                                    if (var1_1 == this.calcBailout[var5_32]) {
                                                                        this.computationError = null;
                                                                        if (this.sd.VPMBalgorithm) {
                                                                            this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                            this.bailoutFlag = true;
                                                                            this.bailoutGasLoss = (int)this.dd.Deco_Settings[var3_10 - 1][var5_32][1];
                                                                            this.calcDSVPMB.start();
                                                                        } else {
                                                                            this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                            this.bailoutFlag = true;
                                                                            this.bailoutGasLoss = (int)this.dd.Deco_Settings[var3_10 - 1][var5_32][1];
                                                                            this.calcDS.start();
                                                                        }
                                                                        this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                        this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                                        break;
                                                                    }
                                                                    ++var5_32;
                                                                }
                                                            }
                                                            if (var1_1 == this.calcCCRBailout) {
                                                                this.bailoutCCRFlag = true;
                                                                this.computationError = null;
                                                                if (this.sd.VPMBalgorithm) {
                                                                    this.calcDSVPMB = new CalculateDiveSeriesVPMB(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDSVPMB.start();
                                                                } else {
                                                                    this.calcDS = new CalculateDiveSeries(this.JD, this.sd, this.gd, this.dd, this);
                                                                    this.calcDS.start();
                                                                }
                                                                this.infoCalculationForm = this.buildInfoCalculationForm();
                                                                this.display.setCurrent((Displayable)this.infoCalculationForm);
                                                            }
                                                            if (var1_1 == this.cancelMixCommand) {
                                                                this.startForm = this.buildStartForm();
                                                                this.display.setCurrent((Displayable)this.startForm);
                                                            }
                                                            if (var1_1 != this.okMixCommand) break block226;
                                                            var14_33 = 0;
                                                            var15_28 = false;
                                                            var16_34 = false;
                                                            var17_30 = 0;
                                                            while (this.gd.Fraction_Oxygen[var17_30] != 9999L) {
                                                                ++var17_30;
                                                            }
                                                            var18_35 = 0;
                                                            while (true) {
                                                                block227: {
                                                                    if (var18_35 >= JDeco.MAX_MIXES) break;
                                                                    if (this.mixOxygen[var18_35].size() == 0) break block227;
                                                                    var4_11 = Long.parseLong(this.mixOxygen[var18_35].getString());
                                                                    var6_17 = this.mixHelium[var18_35].size() == 0 ? 0L : Long.parseLong(this.mixHelium[var18_35].getString());
                                                                    var10_23 = this.CylinderVolume[var18_35].size() == 0 ? 24L : Long.parseLong(this.CylinderVolume[var18_35].getString());
                                                                    if (this.editDecoMixFlag[var18_35].getString(this.editDecoMixFlag[var18_35].getSelectedIndex()).equals("Deco Mix") || this.editDecoMixFlag[var18_35].getString(this.editDecoMixFlag[var18_35].getSelectedIndex()).equals("Bailout Mix")) {
                                                                        var12_36 = 1;
                                                                    } else if (this.editDecoMixFlag[var18_35].getString(this.editDecoMixFlag[var18_35].getSelectedIndex()).equals("Bottom Mix") || this.editDecoMixFlag[var18_35].getString(this.editDecoMixFlag[var18_35].getSelectedIndex()).equals("Diluent Mix")) {
                                                                        var12_36 = 0;
                                                                        var15_28 = true;
                                                                    } else {
                                                                        var12_36 = 2;
                                                                        var15_28 = true;
                                                                    }
                                                                    if (JDeco.registered) ** GOTO lbl-1000
                                                                    if (var4_11 > JDeco.MAX_O2) ** GOTO lbl-1000
                                                                    if (var6_17 > JDeco.MAX_HE) lbl-1000:
                                                                    // 2 sources

                                                                    {
                                                                        var16_34 = true;
                                                                    } else lbl-1000:
                                                                    // 2 sources

                                                                    {
                                                                        var8_19 = 100L - var4_11 - var6_17;
                                                                        if (var6_17 >= 0L && var10_23 > 0L && var4_11 <= 100L && var4_11 >= 5L && var4_11 + var6_17 <= 100L) {
                                                                            if (var18_35 < var17_30 && (var4_11 != this.gd.Fraction_Oxygen[var14_33] || var6_17 != this.gd.Fraction_Helium[var14_33])) {
                                                                                this.dd.Dive_Profile[0][0][0] = 9999L;
                                                                            }
                                                                            this.gd.Fraction_Oxygen[var14_33] = var4_11;
                                                                            this.gd.Fraction_Helium[var14_33] = var6_17;
                                                                            this.gd.Fraction_Nitrogen[var14_33] = var8_19;
                                                                            this.gd.Cylinder_Volume[var14_33] = var10_23;
                                                                            this.gd.DecoMix_Flag[var14_33] = var12_36;
                                                                            var13_26 = var4_11 == 100L ? "O2" : (var4_11 == 21L && var6_17 == 0L ? "Air" : (var6_17 == 0L ? "EAN" + Long.toString(var4_11) : Long.toString(var4_11) + "/" + Long.toString(var6_17)));
                                                                            this.gd.Mix_Name[var14_33] = var13_26;
                                                                            ++var14_33;
                                                                        }
                                                                    }
                                                                }
                                                                ++var18_35;
                                                            }
                                                            this.gd.Fraction_Oxygen[var14_33] = 9999L;
                                                            if (var16_34) {
                                                                this.mixesForm = this.buildMixesForm();
                                                                this.alertScreen = this.buildAlert("ERROR", "Unregistered Version: max. " + Long.toString(JDeco.MAX_O2) + "% O2 " + "and" + " " + Long.toString(JDeco.MAX_HE) + "% He!", AlertType.ERROR, -2);
                                                                this.display.setCurrent(this.alertScreen, (Displayable)this.mixesForm);
                                                            } else if (var15_28) {
                                                                this.saveGasData();
                                                                if (this.dd.Dive_Profile[0][0][0] == 9999L) {
                                                                    this.saveDiveData();
                                                                }
                                                                this.startForm = this.buildStartForm();
                                                                this.display.setCurrent((Displayable)this.startForm);
                                                            } else {
                                                                this.mixesForm = this.buildMixesForm();
                                                                this.alertScreen = this.buildAlert("ERROR", "Please define at least one bottom or diluent mix!", AlertType.ERROR, -2);
                                                                this.display.setCurrent(this.alertScreen, (Displayable)this.mixesForm);
                                                            }
                                                        }
                                                        if (var1_1 == this.cancelSettingsCommand || var1_1 == this.cancelSettings2Command) {
                                                            this.startForm = this.buildStartForm();
                                                            this.display.setCurrent((Displayable)this.startForm);
                                                        }
                                                        if (var1_1 != this.okSettingsCommand) break block228;
                                                        var6_18 = 0;
                                                        var7_37 = false;
                                                        var8_20 = false;
                                                        this.sd.startView = this.startViewChoice.getSelectedIndex();
                                                        if (this.editNumberLevels.size() == 0) break block229;
                                                        var4_11 = Integer.parseInt(this.editNumberLevels.getString());
                                                        if (var4_11 < 1L) ** GOTO lbl-1000
                                                        if (var4_11 <= (long)JDeco.MAX_LEVELS) {
                                                            this.sd.Number_Levels = (int)var4_11;
                                                        } else lbl-1000:
                                                        // 2 sources

                                                        {
                                                            var7_37 = true;
                                                        }
                                                        break block230;
                                                    }
                                                    var7_37 = true;
                                                }
                                                if (this.OCSCRCCRChoice.getString(this.OCSCRCCRChoice.getSelectedIndex()).equals("OC")) {
                                                    var6_18 = 0;
                                                } else if (this.OCSCRCCRChoice.getString(this.OCSCRCCRChoice.getSelectedIndex()).equals("CCR")) {
                                                    var6_18 = 1;
                                                }
                                                if (var6_18 != this.sd.JDeco_Type) {
                                                    this.sd.JDeco_Type = var6_18;
                                                    var8_20 = true;
                                                }
                                                this.sd.VPMBalgorithm = this.algorithmChoice.getString(this.algorithmChoice.getSelectedIndex()).equals("VPM-B") != false;
                                                this.sd.Stop_Times_Flag = this.stopOrRunTimeChoice.getString(this.stopOrRunTimeChoice.getSelectedIndex()).equals("Stop Times") != false ? 1 : (this.stopOrRunTimeChoice.getString(this.stopOrRunTimeChoice.getSelectedIndex()).equals("Run Times") != false ? 0 : 2);
                                                if (this.editCustomChangeTime.size() != 0) {
                                                    var4_11 = Long.parseLong(this.editCustomChangeTime.getString());
                                                    if (var4_11 > 0L) {
                                                        this.sd.Change_Time = var4_11;
                                                    } else {
                                                        var7_37 = true;
                                                    }
                                                } else {
                                                    var7_37 = true;
                                                }
                                                if (this.editCustomChangeDepth.size() != 0) {
                                                    var4_11 = Long.parseLong(this.editCustomChangeDepth.getString());
                                                    if (var4_11 > 0L) {
                                                        this.sd.Change_Depth = var4_11;
                                                    } else {
                                                        var7_37 = true;
                                                    }
                                                } else {
                                                    var7_37 = true;
                                                }
                                                if (var7_37) {
                                                    this.settingsForm = this.buildSettingsForm();
                                                    this.alertScreen = this.buildAlert("ERROR", "Check settings again, some values were not reasonable!", AlertType.ERROR, -2);
                                                    this.display.setCurrent(this.alertScreen, (Displayable)this.settingsForm);
                                                } else {
                                                    if (var8_20) {
                                                        this.dd.Dive_Profile[0][0][0] = 9999L;
                                                    }
                                                    this.saveSettingsData();
                                                    this.saveDiveData();
                                                    this.startForm = this.buildStartForm();
                                                    this.display.setCurrent((Displayable)this.startForm);
                                                }
                                            }
                                            if (var1_1 != this.okSettings2Command) break block231;
                                            var8_21 = false;
                                            var9_38 = false;
                                            if (this.editAltitude_of_Dive.size() == 0) break block232;
                                            var4_11 = Long.parseLong(this.editAltitude_of_Dive.getString());
                                            if (var4_11 < 0L) ** GOTO lbl-1000
                                            if (var4_11 <= JDeco.MAX_ALTITUDE) {
                                                if (var4_11 != this.sd.Altitude_of_Dive) {
                                                    var9_38 = true;
                                                }
                                                this.sd.Altitude_of_Dive = var4_11;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                var8_21 = true;
                                            }
                                            break block233;
                                        }
                                        var8_21 = true;
                                    }
                                    if (this.editGradient_Factor_Lo.size() == 0 || this.editGradient_Factor_Hi.size() == 0) break block234;
                                    var4_11 = Long.parseLong(this.editGradient_Factor_Lo.getString());
                                    var6_17 = Long.parseLong(this.editGradient_Factor_Hi.getString());
                                    if (var4_11 < JDeco.MIN_GRADIENTFACTOR || var4_11 >= var6_17) ** GOTO lbl-1000
                                    if (var6_17 <= JDeco.MAX_GRADIENTFACTOR) {
                                        this.sd.Gradient_Factor_Lo = var4_11;
                                        this.sd.Gradient_Factor_Hi = var6_17;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var8_21 = true;
                                    }
                                    break block235;
                                }
                                var8_21 = true;
                            }
                            if (this.editRMV_During_Dive.size() != 0) {
                                var4_11 = Long.parseLong(this.editRMV_During_Dive.getString());
                                if (var4_11 > 0L) {
                                    this.sd.RMV_During_Dive = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editRMV_During_Deco.size() != 0) {
                                var4_11 = Long.parseLong(this.editRMV_During_Deco.getString());
                                if (var4_11 > 0L) {
                                    this.sd.RMV_During_Deco = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editRate_Initial_Descent.size() != 0) {
                                var4_11 = Long.parseLong(this.editRate_Initial_Descent.getString());
                                if (var4_11 > 0L) {
                                    this.sd.Rate_Initial_Descent = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editRate_During_Dive.size() != 0) {
                                var4_11 = Long.parseLong(this.editRate_During_Dive.getString());
                                if (var4_11 > 0L) {
                                    this.sd.Rate_During_Dive = var4_11;
                                    this.sd.Rate_Descent = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editRate_During_Deco.size() != 0) {
                                var4_11 = Long.parseLong(this.editRate_During_Deco.getString());
                                if (var4_11 > 0L) {
                                    this.sd.Rate_During_Deco = var4_11;
                                    this.sd.Rate_Ascent = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editRate_Last_Deco_Stop.size() != 0) {
                                var4_11 = Long.parseLong(this.editRate_Last_Deco_Stop.getString());
                                if (var4_11 > 0L) {
                                    this.sd.Rate_Last_Deco_Stop = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editDeco_Stop_Step_Size.size() != 0) {
                                var4_11 = Long.parseLong(this.editDeco_Stop_Step_Size.getString());
                                if (var4_11 > 0L) {
                                    this.sd.Deco_Stop_Step_Size = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editLast_Deco_Stop_Depth.size() != 0) {
                                var4_11 = Long.parseLong(this.editLast_Deco_Stop_Depth.getString());
                                if (var4_11 > 0L) {
                                    this.sd.Last_Deco_Stop_Depth = var4_11;
                                } else {
                                    var8_21 = true;
                                }
                            } else {
                                var8_21 = true;
                            }
                            if (this.editMax_PO2_Dive.size() == 0) break block236;
                            var4_11 = MathFP.div(MathFP.toFP(this.editMax_PO2_Dive.getString()), MathFP.toFP(10));
                            if (var4_11 <= MathFP.toFP(0)) ** GOTO lbl-1000
                            if (var4_11 <= MathFP.toFP(JDeco.MAX_PO2)) {
                                this.sd.Max_PO2_Dive = var4_11 + MathFP.toFP("0.01");
                            } else lbl-1000:
                            // 2 sources

                            {
                                var8_21 = true;
                            }
                            break block237;
                        }
                        var8_21 = true;
                    }
                    if (this.editMax_PO2_Deco.size() == 0) break block238;
                    var4_11 = MathFP.div(MathFP.toFP(this.editMax_PO2_Deco.getString()), MathFP.toFP(10));
                    if (var4_11 <= MathFP.toFP(0)) ** GOTO lbl-1000
                    if (var4_11 <= MathFP.toFP(JDeco.MAX_PO2)) {
                        this.sd.Max_PO2_Deco = var4_11 + MathFP.toFP("0.01");
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_21 = true;
                    }
                    break block239;
                }
                var8_21 = true;
            }
            this.sd.Critical_Volume_Algorithm = this.editCriticalVolume.getString(this.editCriticalVolume.getSelectedIndex()).equals("On") != false;
            this.sd.Conservativity_Percent = this.sd.Conservativity_Levels[this.editConservativity.getSelectedIndex()];
            if (var8_21) {
                this.settingsForm2 = this.buildSettingsForm2();
                this.alertScreen = this.buildAlert("ERROR", "Check settings again, some values were not reasonable!", AlertType.ERROR, -2);
                this.display.setCurrent(this.alertScreen, (Displayable)this.settingsForm2);
            } else {
                if (var9_38) {
                    this.dd.Dive_Profile[0][0][0] = 9999L;
                }
                this.saveSettingsData();
                this.saveDiveData();
                this.startForm = this.buildStartForm();
                this.display.setCurrent((Displayable)this.startForm);
            }
        }
        if (var1_1 == this.cancelDiveAddCommand) {
            this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
            if (this.OCPPO2Error) {
                this.alertScreen = this.buildAlert("ERROR", "MAX PPO2 violation.", AlertType.ERROR, -2);
                this.display.setCurrent(this.alertScreen, (Displayable)this.diveSerieForm);
            } else {
                this.display.setCurrent((Displayable)this.diveSerieForm);
            }
        }
        if (var1_1 == this.okDiveAddCommand) {
            this.deepBailOutMixError = false;
            if (this.sd.JDeco_Type == 0) {
                this.addUpdateDive("add");
            } else {
                this.addUpdateDiveCCR("add");
            }
            this.saveDiveData();
            this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
            if (this.deepBailOutMixError) {
                this.alertScreen = this.buildAlert("ERROR", "Bailout mixes violate max deco PPO2 during initial ascent.", AlertType.ERROR, -2);
                this.display.setCurrent(this.alertScreen, (Displayable)this.diveSerieForm);
            } else if (this.OCPPO2Error) {
                this.alertScreen = this.buildAlert("ERROR", "MAX PPO2 violation.", AlertType.ERROR, -2);
                this.display.setCurrent(this.alertScreen, (Displayable)this.diveSerieForm);
            } else {
                this.display.setCurrent((Displayable)this.diveSerieForm);
            }
        }
        if (var1_1 == this.cancelDiveEditCommand) {
            this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
            if (this.OCPPO2Error) {
                this.alertScreen = this.buildAlert("ERROR", "MAX PPO2 violation.", AlertType.ERROR, -2);
                this.display.setCurrent(this.alertScreen, (Displayable)this.diveSerieForm);
            } else {
                this.display.setCurrent((Displayable)this.diveSerieForm);
            }
        }
        if (var1_1 == this.okDiveEditCommand) {
            this.deepBailOutMixError = false;
            if (this.sd.JDeco_Type == 0) {
                this.addUpdateDive("update");
            } else {
                this.addUpdateDiveCCR("update");
            }
            this.saveDiveData();
            this.diveSerieForm = this.sd.JDeco_Type == 0 ? this.buildDiveSerieForm() : this.buildDiveSerieFormCCR();
            if (this.deepBailOutMixError) {
                this.alertScreen = this.buildAlert("ERROR", "Bailout mixes violate max deco PPO2 during initial ascent.", AlertType.ERROR, -2);
                this.display.setCurrent(this.alertScreen, (Displayable)this.diveSerieForm);
            } else if (this.OCPPO2Error) {
                this.alertScreen = this.buildAlert("ERROR", "MAX PPO2 violation.", AlertType.ERROR, -2);
                this.display.setCurrent(this.alertScreen, (Displayable)this.diveSerieForm);
            } else {
                this.display.setCurrent((Displayable)this.diveSerieForm);
            }
        }
        if (var1_1 == this.cancelRegisterCommand) {
            this.startForm = this.buildStartForm();
            this.display.setCurrent((Displayable)this.startForm);
        }
        if (var1_1 == this.okRegisterCommand) {
            if (this.registrationKeyEntered.size() != 0) {
                var4_11 = Long.parseLong(this.registrationKeyEntered.getString());
                if (var4_11 == JDeco.registrationKey) {
                    this.JD.registerProgram();
                    JDeco.registered = true;
                    this.JD.setRegisteredValues();
                    this.initialize();
                }
            }
            this.startForm = this.buildStartForm();
            this.alertScreen = JDeco.registered == true ? this.buildAlert("JDeco Registration", "Thanks for registering JDeco!", AlertType.INFO, UserInterface.AlertTimeSplashRegistration) : this.buildAlert("JDeco Registration", "Wrong registration key!", AlertType.INFO, UserInterface.AlertTimeSplashRegistration);
            this.display.setCurrent(this.alertScreen, (Displayable)this.startForm);
        }
    }

    private void loadSettingsData() {
        this.settingsStore = null;
        this.gasdataStore = null;
        this.divedataStore = null;
        boolean bl = true;
        try {
            this.settingsStore = RecordStore.openRecordStore((String)"Set32a", (boolean)false);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            try {
                String string = new String(this.settingsStore.getRecord(1));
                this.sd.startView = Integer.parseInt(string);
                string = new String(this.settingsStore.getRecord(2));
                this.sd.Number_Levels = Integer.parseInt(string);
                string = new String(this.settingsStore.getRecord(3));
                this.sd.JDeco_Type = Integer.parseInt(string);
                string = new String(this.settingsStore.getRecord(4));
                this.sd.Stop_Times_Flag = Integer.parseInt(string);
                string = new String(this.settingsStore.getRecord(5));
                this.sd.Altitude_of_Dive = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(6));
                this.sd.RMV_During_Dive = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(7));
                this.sd.RMV_During_Deco = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(8));
                this.sd.Rate_Initial_Descent = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(9));
                this.sd.Rate_Descent = this.sd.Rate_During_Dive = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(10));
                this.sd.Rate_Ascent = this.sd.Rate_During_Deco = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(11));
                this.sd.Rate_Last_Deco_Stop = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(12));
                this.sd.Deco_Stop_Step_Size = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(13));
                this.sd.Last_Deco_Stop_Depth = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(14));
                this.sd.Max_PO2_Dive = MathFP.toFP(string);
                string = new String(this.settingsStore.getRecord(15));
                this.sd.Max_PO2_Deco = MathFP.toFP(string);
                string = new String(this.settingsStore.getRecord(16));
                this.sd.Gradient_Factor_Lo = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(17));
                this.sd.Gradient_Factor_Hi = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(18));
                this.sd.VPMBalgorithm = string.equals("1");
                string = new String(this.settingsStore.getRecord(19));
                this.sd.Critical_Volume_Algorithm = string.equals("1");
                string = new String(this.settingsStore.getRecord(20));
                this.sd.Conservativity_Percent = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(21));
                this.sd.Change_Time = Long.parseLong(string);
                string = new String(this.settingsStore.getRecord(22));
                this.sd.Change_Depth = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.settingsStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveSettingsData() {
        this.settingsStore = null;
        this.gasdataStore = null;
        this.divedataStore = null;
        try {
            RecordStore.deleteRecordStore((String)"Set32a");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.settingsStore = RecordStore.openRecordStore((String)"Set32a", (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = Integer.toString(this.sd.startView);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Integer.toString(this.sd.Number_Levels);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Integer.toString(this.sd.JDeco_Type);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Integer.toString(this.sd.Stop_Times_Flag);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Altitude_of_Dive);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.RMV_During_Dive);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.RMV_During_Deco);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Rate_Initial_Descent);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Rate_During_Dive);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Rate_During_Deco);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Rate_Last_Deco_Stop);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Deco_Stop_Step_Size);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Last_Deco_Stop_Depth);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = MathFP.toString(this.sd.Max_PO2_Dive).substring(0, 4);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = MathFP.toString(this.sd.Max_PO2_Deco).substring(0, 4);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Gradient_Factor_Lo);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Gradient_Factor_Hi);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = this.sd.VPMBalgorithm ? "1" : "0";
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = this.sd.Critical_Volume_Algorithm ? "1" : "0";
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Conservativity_Percent);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Change_Time);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
            string = Long.toString(this.sd.Change_Depth);
            this.settingsStore.addRecord(string.getBytes(), 0, string.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.settingsStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadGasData() {
        this.settingsStore = null;
        this.gasdataStore = null;
        this.divedataStore = null;
        boolean bl = true;
        try {
            this.gasdataStore = RecordStore.openRecordStore((String)"Gas32a", (boolean)false);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            try {
                int n = 1;
                int n2 = 0;
                while (n <= this.gasdataStore.getNumRecords()) {
                    String string = new String(this.gasdataStore.getRecord(n));
                    this.gd.Fraction_Oxygen[n2] = Long.parseLong(string);
                    string = new String(this.gasdataStore.getRecord(++n));
                    this.gd.Fraction_Helium[n2] = Long.parseLong(string);
                    string = new String(this.gasdataStore.getRecord(++n));
                    this.gd.Fraction_Nitrogen[n2] = Long.parseLong(string);
                    string = new String(this.gasdataStore.getRecord(++n));
                    this.gd.Cylinder_Volume[n2] = Long.parseLong(string);
                    string = new String(this.gasdataStore.getRecord(++n));
                    this.gd.DecoMix_Flag[n2] = Integer.parseInt(string);
                    this.gd.Mix_Name[n2] = string = new String(this.gasdataStore.getRecord(++n));
                    ++n;
                    ++n2;
                }
                this.gd.Fraction_Oxygen[n2] = 9999L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.gasdataStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveGasData() {
        this.settingsStore = null;
        this.gasdataStore = null;
        this.divedataStore = null;
        try {
            RecordStore.deleteRecordStore((String)"Gas32a");
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            this.gasdataStore = RecordStore.openRecordStore((String)"Gas32a", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            int n = 0;
            while (this.gd.Fraction_Oxygen[n] != 9999L) {
                String string = Long.toString(this.gd.Fraction_Oxygen[n]);
                this.gasdataStore.addRecord(string.getBytes(), 0, string.length());
                string = Long.toString(this.gd.Fraction_Helium[n]);
                this.gasdataStore.addRecord(string.getBytes(), 0, string.length());
                string = Long.toString(this.gd.Fraction_Nitrogen[n]);
                this.gasdataStore.addRecord(string.getBytes(), 0, string.length());
                string = Long.toString(this.gd.Cylinder_Volume[n]);
                this.gasdataStore.addRecord(string.getBytes(), 0, string.length());
                string = Integer.toString(this.gd.DecoMix_Flag[n]);
                this.gasdataStore.addRecord(string.getBytes(), 0, string.length());
                string = this.gd.Mix_Name[n];
                this.gasdataStore.addRecord(string.getBytes(), 0, string.length());
                ++n;
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            this.gasdataStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void loadDiveData() {
        this.settingsStore = null;
        this.gasdataStore = null;
        this.divedataStore = null;
        boolean bl = true;
        try {
            this.divedataStore = RecordStore.openRecordStore((String)"Dive32a", (boolean)false);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            try {
                int n;
                int n2;
                int n3;
                int n4 = 1;
                String string = new String(this.divedataStore.getRecord(n4));
                int n5 = Integer.parseInt(string);
                ++n4;
                for (n3 = 0; n3 < n5; ++n3) {
                    string = new String(this.divedataStore.getRecord(n4));
                    int n6 = Integer.parseInt(string);
                    ++n4;
                    for (n2 = 0; n2 < n6; ++n2) {
                        string = new String(this.divedataStore.getRecord(n4));
                        this.dd.Dive_Profile[n3][n2][0] = Long.parseLong(string);
                        string = new String(this.divedataStore.getRecord(++n4));
                        this.dd.Dive_Profile[n3][n2][1] = Long.parseLong(string);
                        string = new String(this.divedataStore.getRecord(++n4));
                        this.dd.Dive_Profile[n3][n2][2] = Long.parseLong(string);
                        string = new String(this.divedataStore.getRecord(++n4));
                        this.dd.Dive_Profile[n3][n2][3] = Long.parseLong(string);
                        ++n4;
                    }
                    this.dd.Dive_Profile[n3][n6][0] = 999L;
                }
                this.dd.Dive_Profile[n5][0][0] = 9999L;
                for (n3 = 0; n3 < n5; ++n3) {
                    string = new String(this.divedataStore.getRecord(n4));
                    n = Integer.parseInt(string);
                    ++n4;
                    for (n2 = 0; n2 < n; ++n2) {
                        string = new String(this.divedataStore.getRecord(n4));
                        this.dd.Deco_Settings[n3][n2][0] = Long.parseLong(string);
                        string = new String(this.divedataStore.getRecord(++n4));
                        this.dd.Deco_Settings[n3][n2][1] = Long.parseLong(string);
                        string = new String(this.divedataStore.getRecord(++n4));
                        this.dd.Deco_Settings[n3][n2][2] = Long.parseLong(string);
                        ++n4;
                    }
                    this.dd.Deco_Settings[n3][n][0] = 999L;
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    string = new String(this.divedataStore.getRecord(n4));
                    n = Integer.parseInt(string);
                    ++n4;
                    for (n2 = 0; n2 < n; ++n2) {
                        string = new String(this.divedataStore.getRecord(n4));
                        this.dd.CCR_Deco_Settings[n3][n2][0] = Long.parseLong(string);
                        string = new String(this.divedataStore.getRecord(++n4));
                        this.dd.CCR_Deco_Settings[n3][n2][1] = Long.parseLong(string);
                        string = new String(this.divedataStore.getRecord(++n4));
                        this.dd.CCR_Deco_Settings[n3][n2][2] = Long.parseLong(string);
                        ++n4;
                    }
                    this.dd.CCR_Deco_Settings[n3][n][0] = 999L;
                }
                for (n3 = 0; n3 < n5 - 1; ++n3) {
                    string = new String(this.divedataStore.getRecord(n4));
                    this.dd.Surface_Interval[n3] = Long.parseLong(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.divedataStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveDiveData() {
        this.settingsStore = null;
        this.gasdataStore = null;
        this.divedataStore = null;
        try {
            RecordStore.deleteRecordStore((String)"Dive32a");
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            this.divedataStore = RecordStore.openRecordStore((String)"Dive32a", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            while (this.dd.Dive_Profile[n4][0][0] != 9999L) {
                ++n4;
            }
            String string = Integer.toString(n4);
            this.divedataStore.addRecord(string.getBytes(), 0, string.length());
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = 0;
                while (this.dd.Dive_Profile[n3][n5][0] != 999L) {
                    ++n5;
                }
                string = Integer.toString(n5);
                this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                for (n2 = 0; n2 < n5; ++n2) {
                    string = Long.toString(this.dd.Dive_Profile[n3][n2][0]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                    string = Long.toString(this.dd.Dive_Profile[n3][n2][1]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                    string = Long.toString(this.dd.Dive_Profile[n3][n2][2]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                    string = Long.toString(this.dd.Dive_Profile[n3][n2][3]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n = 0;
                while (this.dd.Deco_Settings[n3][n][0] != 999L) {
                    ++n;
                }
                string = Integer.toString(n);
                this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                for (n2 = 0; n2 < n; ++n2) {
                    string = Long.toString(this.dd.Deco_Settings[n3][n2][0]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                    string = Long.toString(this.dd.Deco_Settings[n3][n2][1]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                    string = Long.toString(this.dd.Deco_Settings[n3][n2][2]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n = 0;
                while (this.dd.CCR_Deco_Settings[n3][n][0] != 999L) {
                    ++n;
                }
                string = Integer.toString(n);
                this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                for (n2 = 0; n2 < n; ++n2) {
                    string = Long.toString(this.dd.CCR_Deco_Settings[n3][n2][0]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                    string = Long.toString(this.dd.CCR_Deco_Settings[n3][n2][1]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                    string = Long.toString(this.dd.CCR_Deco_Settings[n3][n2][2]);
                    this.divedataStore.addRecord(string.getBytes(), 0, string.length());
                }
            }
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                string = Long.toString(this.dd.Surface_Interval[n3]);
                this.divedataStore.addRecord(string.getBytes(), 0, string.length());
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            this.divedataStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private Alert buildAlert(String string, String string2, AlertType alertType, int n) {
        Alert alert = new Alert(string, string2, null, alertType);
        alert.setTimeout(n);
        return alert;
    }

    public Form buildToolsForm() {
        this.GCeditFields();
        Form form = new Form("Gas Mixing Tools");
        StringItem stringItem = new StringItem("", "Van der Waals gas mixing and topping tools. Best mix calculation.");
        form.append((Item)stringItem);
        form.addCommand(this.exitToolCommand);
        form.addCommand(this.bestmixToolCommand);
        form.addCommand(this.mixToolCommand);
        form.addCommand(this.toppingToolCommand);
        form.addCommand(this.exitCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildMixToolForm() {
        Form form = new Form("VdW Gas Mixing");
        form.append((Item)new StringItem("Old Mix", null));
        this.mixO2StartText = this.mixO2Start < 0L ? new TextField("O2(%)", "21", 2, 2) : new TextField("O2(%)", Long.toString(this.mixO2Start), 2, 2);
        this.mixHeStartText = this.mixHeStart < 0L ? new TextField("He(%)", "0", 2, 2) : new TextField("He(%)", Long.toString(this.mixHeStart), 2, 2);
        this.mixPStartText = this.mixPStart < 0L ? new TextField("Pressure(bar)", "0", 3, 2) : new TextField("Pressure(bar)", Long.toString(this.mixPStart), 3, 2);
        form.append((Item)this.mixO2StartText);
        form.append((Item)this.mixHeStartText);
        form.append((Item)this.mixPStartText);
        form.append((Item)new StringItem(" ", null));
        form.append((Item)new StringItem("Desired Mix", null));
        this.mixO2EndText = this.mixO2End < 0L ? new TextField("O2(%)", "21", 2, 2) : new TextField("O2(%)", Long.toString(this.mixO2End), 2, 2);
        this.mixHeEndText = this.mixHeEnd < 0L ? new TextField("He(%)", "0", 2, 2) : new TextField("He(%)", Long.toString(this.mixHeEnd), 2, 2);
        this.mixPEndText = this.mixPEnd < 0L ? new TextField("Pressure(bar)", "0", 3, 2) : new TextField("Pressure(bar)", Long.toString(this.mixPEnd), 3, 2);
        form.append((Item)this.mixO2EndText);
        form.append((Item)this.mixHeEndText);
        form.append((Item)this.mixPEndText);
        form.append((Item)new StringItem(" ", null));
        form.append((Item)new StringItem("Other Data", null));
        this.mixFillO2First = new ChoiceGroup("Fill Order", 2);
        this.mixFillO2First.append("O2 First", null);
        if (this.mixO2First) {
            this.mixFillO2First.setSelectedIndex(0, true);
        } else {
            this.mixFillO2First.setSelectedIndex(0, false);
        }
        form.append((Item)this.mixFillO2First);
        this.mixTText = this.mixT < 0L ? new TextField("Temp(\u00b0C)", "20", 2, 2) : new TextField("Temp(\u00b0C)", Long.toString(this.mixT), 2, 2);
        this.mixVText = this.mixV < 0L ? new TextField("Volume(Liter)", "24", 2, 2) : new TextField("Volume(Liter)", Long.toString(this.mixV), 2, 2);
        form.append((Item)this.mixTText);
        form.append((Item)this.mixVText);
        form.addCommand(this.calcMixCommand);
        form.addCommand(this.backMixCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildToppingToolForm() {
        Form form = new Form("VdW Mix Topping");
        form.append((Item)new StringItem("Old Mix", null));
        this.mixO2StartText = this.mixO2Start < 0L ? new TextField("O2(%)", "21", 2, 2) : new TextField("O2(%)", Long.toString(this.mixO2Start), 2, 2);
        this.mixHeStartText = this.mixHeStart < 0L ? new TextField("He(%)", "0", 2, 2) : new TextField("He(%)", Long.toString(this.mixHeStart), 2, 2);
        this.mixPStartText = this.mixPStart < 0L ? new TextField("Pressure(bar)", "0", 3, 2) : new TextField("Pressure(bar)", Long.toString(this.mixPStart), 3, 2);
        form.append((Item)this.mixO2StartText);
        form.append((Item)this.mixHeStartText);
        form.append((Item)this.mixPStartText);
        form.append((Item)new StringItem(" ", null));
        form.append((Item)new StringItem("Topping Mix", null));
        this.mixO2TopText = this.mixO2Top < 0L ? new TextField("O2(%)", "21", 2, 2) : new TextField("O2(%)", Long.toString(this.mixO2Top), 2, 2);
        this.mixHeTopText = this.mixHeTop < 0L ? new TextField("He(%)", "0", 2, 2) : new TextField("He(%)", Long.toString(this.mixHeTop), 2, 2);
        form.append((Item)this.mixO2TopText);
        form.append((Item)this.mixHeTopText);
        form.append((Item)new StringItem(" ", null));
        form.append((Item)new StringItem("Top to Pressure", null));
        this.mixPEndText = this.mixPEnd < 0L ? new TextField("Pressure(bar)", "0", 3, 2) : new TextField("Pressure(bar)", Long.toString(this.mixPEnd), 3, 2);
        form.append((Item)this.mixPEndText);
        form.append((Item)new StringItem(" ", null));
        form.append((Item)new StringItem("Other Data", null));
        this.mixTText = this.mixT < 0L ? new TextField("Temp(\u00b0C)", "20", 2, 2) : new TextField("Temp(\u00b0C)", Long.toString(this.mixT), 2, 2);
        this.mixVText = this.mixV < 0L ? new TextField("Volume(Liter)", "24", 2, 2) : new TextField("Volume(Liter)", Long.toString(this.mixV), 2, 2);
        form.append((Item)this.mixTText);
        form.append((Item)this.mixVText);
        form.addCommand(this.calcToppingCommand);
        form.addCommand(this.backToppingCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildBestmixToolForm() {
        Form form = new Form("Best Mix");
        StringItem stringItem = new StringItem("", "Enter the needed data to compute the best mix");
        form.append((Item)stringItem);
        this.bestmixDepth = new TextField("Depth(m)", null, 3, 2);
        this.bestmixPPO2 = new TextField("PPO2(10*bar)", null, 3, 2);
        this.bestmixmaxEND = new TextField("max END(m)", null, 2, 2);
        this.bestmixO2narcotic = new ChoiceGroup("O2 narcotic", 1);
        this.bestmixO2narcotic.append("Yes", null);
        this.bestmixO2narcotic.append("No", null);
        form.append((Item)this.bestmixDepth);
        form.append((Item)this.bestmixPPO2);
        form.append((Item)this.bestmixmaxEND);
        form.append((Item)this.bestmixO2narcotic);
        form.addCommand(this.calcBestmixCommand);
        form.addCommand(this.backBestmixCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildStartForm() {
        ImageItem imageItem;
        this.GCeditFields();
        Form form = new Form("JDeco" + " " + "4.0 - Metric");
        StringItem stringItem = new StringItem("", this.startText);
        form.append((Item)stringItem);
        try {
            imageItem = new ImageItem(null, Image.createImage((String)"/JDecoImage.png"), 3, null);
            form.append((Item)imageItem);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        imageItem = new StringItem("\n", this.disclaimerText);
        form.append((Item)imageItem);
        if (!JDeco.registered) {
            form.addCommand(this.registerCommand);
        }
        form.addCommand(this.diveSerieCommand);
        form.addCommand(this.mixesCommand);
        form.addCommand(this.toolsCommand);
        form.addCommand(this.settingsCommand);
        form.addCommand(this.settings2Command);
        form.addCommand(this.aboutCommand);
        form.addCommand(this.exitCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildInfoCalculationForm() {
        StringItem stringItem;
        Form form = new Form("JDeco" + " " + "4.0 - Metric");
        StringItem stringItem2 = new StringItem("", "Calculating ...\n");
        form.append((Item)stringItem2);
        try {
            stringItem = new ImageItem(null, Image.createImage((String)"/JDecoImage.png"), 3, null);
            form.append((Item)stringItem);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stringItem = new StringItem("\n", "... Please wait!");
        form.append((Item)stringItem);
        return form;
    }

    public Form buildRegistrationForm() {
        Form form = new Form("REGISTER JDeco");
        StringItem stringItem = new StringItem(null, "Registration Number\n");
        form.append((Item)stringItem);
        StringItem stringItem2 = new StringItem(null, Long.toString(JDeco.registrationNumber + 500L) + "\n");
        form.append((Item)stringItem2);
        StringItem stringItem3 = new StringItem(null, "Please visit www.jdeco.de to obtain your registration key, which you enter below and press 'Register'.\n");
        form.append((Item)stringItem3);
        this.registrationKeyEntered = new TextField(null, null, 5, 2);
        form.append((Item)this.registrationKeyEntered);
        StringItem stringItem4 = new StringItem(null, "After registration the settings, mixes, and dive series data are persistently stored in the phone, and the software starts directly with the dive series form.\n");
        form.append((Item)stringItem4);
        form.addCommand(this.okRegisterCommand);
        form.addCommand(this.cancelRegisterCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildDiveSerieForm() {
        this.GCeditFields();
        int n = 0;
        int n2 = 0;
        while (this.dd.Dive_Profile[n][0][0] != 9999L) {
            ++n;
        }
        Form form = new Form(this.diveSerieTextFormTitle + " (OC)");
        if (n == 0) {
            StringItem stringItem = new StringItem(this.diveSerieTextNoDives + "\n", "");
            form.append((Item)stringItem);
        } else {
            long l = this.getBarometricPressure(this.sd.Altitude_of_Dive);
            StringItem[] stringItemArray = new StringItem[JDeco.MAX_DIVES];
            StringItem[] stringItemArray2 = new StringItem[JDeco.MAX_DIVES - 1];
            for (int i = n - 1; i >= 0; --i) {
                long l2;
                long l3;
                long l4;
                long l5 = MathFP.toFP(0);
                String string = "";
                int n3 = 0;
                while (this.dd.Dive_Profile[i][n3][0] != 999L) {
                    l4 = MathFP.toFP(this.dd.Dive_Profile[i][n3][0]);
                    l3 = MathFP.toFP(this.gd.Fraction_Oxygen[(int)this.dd.Dive_Profile[i][n3][2]]);
                    l2 = MathFP.round(MathFP.div(MathFP.mul(l3, MathFP.div(MathFP.add(l4, l), MathFP.toFP(10))), MathFP.toFP(100)), 2);
                    if (l2 > l5) {
                        l5 = l2;
                    }
                    string = string + Long.toString(this.dd.Dive_Profile[i][n3][0]) + "m  " + Long.toString(this.dd.Dive_Profile[i][n3][1]) + "min  " + this.gd.Mix_Name[(int)this.dd.Dive_Profile[i][n3][2]] + "\n";
                    ++n3;
                }
                String string2 = MathFP.toString(l5);
                string2 = string2.substring(0, 4);
                string = string + this.diveSerieTextmaxPPO2 + " " + string2 + "\n";
                this.OCPPO2Error = false;
                if (l5 > this.sd.Max_PO2_Dive + MathFP.toFP("0.01")) {
                    this.OCPPO2Error = true;
                    string = string + "BOTTOM PPO2 TO HIGH!\n";
                }
                n2 = 0;
                while (this.dd.Deco_Settings[i][n2][0] != 999L) {
                    ++n2;
                }
                if (n2 == 0) {
                    string = string + this.diveSerieTextNoDecoGases;
                } else {
                    string = string + this.diveSerieTextGasSwitches + "\n";
                    l5 = 0L;
                    for (int j = 0; j < n2; ++j) {
                        l4 = this.dd.Deco_Settings[i][j][0];
                        l3 = MathFP.toFP(this.gd.Fraction_Oxygen[(int)this.dd.Deco_Settings[i][j][1]]);
                        string = string + Long.toString(l4) + "m  " + this.gd.Mix_Name[(int)this.dd.Deco_Settings[i][j][1]] + "\n";
                        l2 = MathFP.round(MathFP.div(MathFP.floor(MathFP.mul(l3, MathFP.div(MathFP.add(MathFP.toFP(l4), l), MathFP.toFP(10)))), MathFP.toFP(100)), 2);
                        if (l2 <= l5) continue;
                        l5 = l2;
                    }
                    string2 = MathFP.toString(l5);
                    string2 = string2.substring(0, 4);
                    string = string + this.settingsTextmaxDecoPPO2 + " " + string2 + "\n";
                    if (l5 > this.sd.Max_PO2_Deco + MathFP.toFP("0.02")) {
                        string = string + "DECO PPO2 TO HIGH!";
                        this.OCPPO2Error = true;
                    }
                }
                stringItemArray[i] = new StringItem(this.diveSerieTextDive + " " + Integer.toString(i + 1) + "\n", string);
                form.append((Item)stringItemArray[i]);
                if (i <= 0) continue;
                long l6 = MathFP.div(MathFP.toFP(this.dd.Surface_Interval[i - 1]), MathFP.toFP(60));
                l6 = MathFP.round(l6, 1);
                stringItemArray2[i] = new StringItem(this.diveSerieTextSurfaceInterval + "\n", MathFP.toString(l6).substring(0, 3) + "hr\n");
                form.append((Item)stringItemArray2[i]);
            }
        }
        if (this.sd.VPMBalgorithm) {
            this.calculateCommand = new Command("Calc VPM-B", 8, 1);
            this.calculateCommand2 = new Command("Calc ZHL16B", 8, 1);
        } else {
            this.calculateCommand = new Command("Calc ZHL16B", 8, 1);
            this.calculateCommand2 = new Command("Calc VPM-B", 8, 1);
        }
        if (n == 0) {
            form.addCommand(this.addDiveCommand);
            form.addCommand(this.mainMenuCommand);
        } else if (n == JDeco.MAX_DIVES) {
            form.addCommand(this.calculateCommand);
            form.addCommand(this.editLastDiveCommand);
            form.addCommand(this.deleteLastDiveCommand);
            form.addCommand(this.deleteDiveSerieCommand);
            form.addCommand(this.calculateCommand2);
            form.addCommand(this.mainMenuCommand);
            form.addCommand(this.exitCommand);
        } else {
            form.addCommand(this.calculateCommand);
            form.addCommand(this.editLastDiveCommand);
            form.addCommand(this.addDiveCommand);
            form.addCommand(this.deleteLastDiveCommand);
            form.addCommand(this.deleteDiveSerieCommand);
            form.addCommand(this.calculateCommand2);
            form.addCommand(this.mainMenuCommand);
            form.addCommand(this.exitCommand);
        }
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildDiveSerieFormCCR() {
        this.OCPPO2Error = false;
        this.GCeditFields();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        while (this.dd.Dive_Profile[n][0][0] != 9999L) {
            ++n;
        }
        Form form = new Form(this.diveSerieTextFormTitle + " (CCR)");
        if (n == 0) {
            StringItem stringItem = new StringItem(this.diveSerieTextNoDives + "\n", "");
            form.append((Item)stringItem);
        } else {
            StringItem[] stringItemArray = new StringItem[JDeco.MAX_DIVES];
            StringItem[] stringItemArray2 = new StringItem[JDeco.MAX_DIVES - 1];
            long l3 = this.getBarometricPressure(this.sd.Altitude_of_Dive);
            for (int i = n - 1; i >= 0; --i) {
                long l4;
                String string = "";
                int n3 = 0;
                long l5 = 0L;
                while (this.dd.Dive_Profile[i][n3][0] != 999L) {
                    string = string + Long.toString(this.dd.Dive_Profile[i][n3][0]) + "m " + Long.toString(this.dd.Dive_Profile[i][n3][1]) + "min " + this.gd.Mix_Name[(int)this.dd.Dive_Profile[i][n3][2]] + " " + MathFP.toString(MathFP.round(this.dd.Dive_Profile[i][n3][3], 1)).substring(0, 3) + "\n";
                    l = this.dd.Dive_Profile[i][n3][3];
                    l2 = this.dd.Dive_Profile[i][n3][2];
                    if (l > l5) {
                        l5 = l;
                    }
                    ++n3;
                }
                if (l5 > this.sd.Max_PO2_Dive + MathFP.toFP("0.02")) {
                    string = string + "DIVE PPO2 TO HIGH!" + "\n";
                }
                string = string + "DECO SETTINGS" + "\n";
                int n4 = 0;
                while (this.dd.CCR_Deco_Settings[i][n4][0] != 999L) {
                    ++n4;
                }
                if (n4 == 0) {
                    string = string + "Deco PPO2" + ": " + MathFP.toString(MathFP.round(l, 1)).substring(0, 3) + "\n";
                    l5 = l;
                } else {
                    l5 = 0L;
                    for (int j = 0; j < n4; ++j) {
                        l4 = this.dd.CCR_Deco_Settings[i][j][0];
                        long l6 = this.dd.CCR_Deco_Settings[i][j][1];
                        long l7 = this.dd.CCR_Deco_Settings[i][j][2];
                        if (l6 == -1L) {
                            l6 = l2;
                        }
                        string = string + Long.toString(l4) + "m " + this.gd.Mix_Name[(int)l6] + " " + MathFP.toString(MathFP.round(l7, 1)).substring(0, 3) + "\n";
                        l2 = l6;
                        l = l7;
                        if (l <= l5) continue;
                        l5 = l;
                    }
                }
                if (l5 > this.sd.Max_PO2_Deco + MathFP.toFP("0.02")) {
                    string = string + "DECO PPO2 TO HIGH!" + "!\n";
                }
                n2 = 0;
                while (this.dd.Deco_Settings[i][n2][0] != 999L) {
                    ++n2;
                }
                if (n2 == 0) {
                    string = string + "No Bailout Mixes";
                } else {
                    l5 = 0L;
                    string = string + "Bailout Mixes" + "\n";
                    for (int j = 0; j < n2; ++j) {
                        l4 = this.dd.Deco_Settings[i][j][0];
                        long l8 = MathFP.toFP(this.gd.Fraction_Oxygen[(int)this.dd.Deco_Settings[i][j][1]]);
                        string = string + Long.toString(l4) + "m  " + this.gd.Mix_Name[(int)this.dd.Deco_Settings[i][j][1]] + "\n";
                        long l9 = MathFP.round(MathFP.div(MathFP.floor(MathFP.mul(l8, MathFP.div(MathFP.add(MathFP.toFP(l4), l3), MathFP.toFP(10)))), MathFP.toFP(100)), 2);
                        if (l9 <= l5) continue;
                        l5 = l9;
                    }
                    String string2 = MathFP.toString(l5);
                    string2 = string2.substring(0, 4);
                    string = string + "Max Bailout PPO2" + " " + string2 + "\n";
                    if (l5 > this.sd.Max_PO2_Deco + MathFP.toFP("0.01")) {
                        string = string + "Bailout PPO2 TO HIGH!";
                    }
                }
                stringItemArray[i] = new StringItem(this.diveSerieTextDive + " " + Integer.toString(i + 1) + "\n", string);
                form.append((Item)stringItemArray[i]);
                if (i <= 0) continue;
                long l10 = MathFP.div(MathFP.toFP(this.dd.Surface_Interval[i - 1]), MathFP.toFP(60));
                l10 = MathFP.round(l10, 1);
                stringItemArray2[i] = new StringItem(this.diveSerieTextSurfaceInterval + "\n", MathFP.toString(l10).substring(0, 3) + "hr\n");
                form.append((Item)stringItemArray2[i]);
            }
        }
        if (this.sd.VPMBalgorithm) {
            this.calculateCommand = new Command("Calc VPM-B", 8, 1);
            this.calculateCommand2 = new Command("Calc ZHL16B", 8, 1);
        } else {
            this.calculateCommand = new Command("Calc ZHL16B", 8, 1);
            this.calculateCommand2 = new Command("Calc VPM-B", 8, 1);
        }
        if (n == 0) {
            form.addCommand(this.addDiveCommand);
            form.addCommand(this.mainMenuCommand);
        } else if (n == JDeco.MAX_DIVES) {
            form.addCommand(this.calculateCommand);
            form.addCommand(this.editLastDiveCommand);
            form.addCommand(this.deleteLastDiveCommand);
            form.addCommand(this.deleteDiveSerieCommand);
            form.addCommand(this.calculateCommand2);
            form.addCommand(this.mainMenuCommand);
            form.addCommand(this.exitCommand);
        } else {
            form.addCommand(this.calculateCommand);
            form.addCommand(this.editLastDiveCommand);
            form.addCommand(this.addDiveCommand);
            form.addCommand(this.deleteLastDiveCommand);
            form.addCommand(this.deleteDiveSerieCommand);
            form.addCommand(this.calculateCommand2);
            form.addCommand(this.mainMenuCommand);
            form.addCommand(this.exitCommand);
        }
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildMixesForm() {
        Form form = new Form(this.mixesTextFormTitle);
        int n = 0;
        while (this.gd.Fraction_Oxygen[n] != 9999L) {
            ++n;
        }
        int n2 = 0;
        while (true) {
            int n3;
            String string;
            String string2;
            String string3;
            if (n2 >= JDeco.MAX_MIXES) break;
            if (n2 < n) {
                string3 = Long.toString(this.gd.Fraction_Oxygen[n2]);
                string2 = Long.toString(this.gd.Fraction_Helium[n2]);
                string = Long.toString(this.gd.Cylinder_Volume[n2]);
                n3 = this.gd.DecoMix_Flag[n2];
            } else {
                string3 = null;
                string2 = null;
                string = null;
                n3 = 0;
            }
            form.append((Item)new StringItem(this.mixesTextMix + " " + Integer.toString(n2 + 1), null));
            this.CylinderVolume[n2] = new TextField("Vol (ltr)", string, 2, 2);
            form.append((Item)this.CylinderVolume[n2]);
            this.mixOxygen[n2] = new TextField(this.mixesTextO2 + " ", string3, 3, 2);
            form.append((Item)this.mixOxygen[n2]);
            this.mixHelium[n2] = new TextField(this.mixesTextHe + " ", string2, 2, 2);
            form.append((Item)this.mixHelium[n2]);
            this.editDecoMixFlag[n2] = new ChoiceGroup("Type of Mix", 1);
            if (this.sd.JDeco_Type == 0) {
                this.editDecoMixFlag[n2].append("Bottom Mix", null);
                this.editDecoMixFlag[n2].append("Both (Travel Mix)", null);
                this.editDecoMixFlag[n2].append("Deco Mix", null);
            } else {
                this.editDecoMixFlag[n2].append("Diluent Mix", null);
                this.editDecoMixFlag[n2].append("Both", null);
                this.editDecoMixFlag[n2].append("Bailout Mix", null);
            }
            if (n3 == 1) {
                this.editDecoMixFlag[n2].setSelectedIndex(2, true);
            } else if (n3 == 0) {
                this.editDecoMixFlag[n2].setSelectedIndex(0, true);
            } else if (n3 == 2) {
                this.editDecoMixFlag[n2].setSelectedIndex(1, true);
            }
            form.append((Item)this.editDecoMixFlag[n2]);
            form.append((Item)new StringItem(" ", null));
            ++n2;
        }
        form.addCommand(this.okMixCommand);
        form.addCommand(this.cancelMixCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildSettingsForm() {
        Form form = new Form(this.settingsTextFormTitle);
        this.startViewChoice = new ChoiceGroup("Start Screen", 1);
        this.startViewChoice.append("Main Menu", null);
        this.startViewChoice.append("Dive Series", null);
        this.startViewChoice.append("Mix Tools", null);
        if (this.sd.startView == 0) {
            this.startViewChoice.setSelectedIndex(0, true);
        } else if (this.sd.startView == 1) {
            this.startViewChoice.setSelectedIndex(1, true);
        } else if (this.sd.startView == 2) {
            this.startViewChoice.setSelectedIndex(2, true);
        }
        form.append((Item)this.startViewChoice);
        StringItem stringItem = new StringItem("Number Levels\n", "");
        form.append((Item)stringItem);
        this.editNumberLevels = new TextField("(1-" + Integer.toString(JDeco.MAX_LEVELS) + ")", Integer.toString(this.sd.Number_Levels), 1, 2);
        form.append((Item)this.editNumberLevels);
        this.OCSCRCCRChoice = new ChoiceGroup("System", 1);
        this.OCSCRCCRChoice.append("OC", null);
        this.OCSCRCCRChoice.append("CCR", null);
        if (this.sd.JDeco_Type == 0) {
            this.OCSCRCCRChoice.setSelectedIndex(0, true);
        } else if (this.sd.JDeco_Type == 1) {
            this.OCSCRCCRChoice.setSelectedIndex(1, true);
        }
        form.append((Item)this.OCSCRCCRChoice);
        this.algorithmChoice = new ChoiceGroup("Algorithm", 1);
        this.algorithmChoice.append("ZH-L16B/GF", null);
        this.algorithmChoice.append("VPM-B", null);
        if (this.sd.VPMBalgorithm) {
            this.algorithmChoice.setSelectedIndex(1, true);
        } else {
            this.algorithmChoice.setSelectedIndex(0, true);
        }
        form.append((Item)this.algorithmChoice);
        this.stopOrRunTimeChoice = new ChoiceGroup("Deco Table", 1);
        this.stopOrRunTimeChoice.append("Stop Times", null);
        this.stopOrRunTimeChoice.append("Run Times", null);
        this.stopOrRunTimeChoice.append("Both", null);
        if (this.sd.Stop_Times_Flag == 1) {
            this.stopOrRunTimeChoice.setSelectedIndex(0, true);
        } else if (this.sd.Stop_Times_Flag == 0) {
            this.stopOrRunTimeChoice.setSelectedIndex(1, true);
        } else {
            this.stopOrRunTimeChoice.setSelectedIndex(2, true);
        }
        form.append((Item)this.stopOrRunTimeChoice);
        StringItem stringItem2 = new StringItem("Alternative Plan\n", "");
        form.append((Item)stringItem2);
        this.editCustomChangeTime = new TextField("(\u00b1 min)", Long.toString(this.sd.Change_Time), 1, 2);
        this.editCustomChangeDepth = new TextField("(\u00b1 m)", Long.toString(this.sd.Change_Depth), 1, 2);
        form.append((Item)this.editCustomChangeTime);
        form.append((Item)this.editCustomChangeDepth);
        form.append((Item)new StringItem(" ", null));
        form.addCommand(this.okSettingsCommand);
        form.addCommand(this.cancelSettingsCommand);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildSettingsForm2() {
        Form form = new Form(this.settings2TextFormTitle);
        StringItem stringItem = new StringItem(this.settingsTextAltitude + "\n", "");
        form.append((Item)stringItem);
        this.editAltitude_of_Dive = new TextField("(meter)", Long.toString(this.sd.Altitude_of_Dive), 4, 2);
        form.append((Item)this.editAltitude_of_Dive);
        StringItem stringItem2 = new StringItem(this.settingsTextRates + "\n", "");
        form.append((Item)stringItem2);
        this.editRate_During_Dive = new TextField("Dive (m/min) ", Long.toString(this.sd.Rate_During_Dive), 2, 2);
        this.editRate_During_Deco = new TextField("Deco (m/min) ", Long.toString(this.sd.Rate_During_Deco), 2, 2);
        form.append((Item)this.editRate_During_Dive);
        form.append((Item)this.editRate_During_Deco);
        StringItem stringItem3 = new StringItem(this.settingsTextStepSize + "\n", "");
        form.append((Item)stringItem3);
        this.editDeco_Stop_Step_Size = new TextField("(m)", Long.toString(this.sd.Deco_Stop_Step_Size), 1, 2);
        form.append((Item)this.editDeco_Stop_Step_Size);
        StringItem stringItem4 = new StringItem(this.settingsTextLastStop + "\n", "");
        form.append((Item)stringItem4);
        this.editLast_Deco_Stop_Depth = new TextField(this.settingsTextLastStopDepth + " ", Long.toString(this.sd.Last_Deco_Stop_Depth), 1, 2);
        this.editRate_Last_Deco_Stop = new TextField(this.settingsTextLastStopRate + " ", Long.toString(this.sd.Rate_Last_Deco_Stop), 2, 2);
        form.append((Item)this.editLast_Deco_Stop_Depth);
        form.append((Item)this.editRate_Last_Deco_Stop);
        StringItem stringItem5 = new StringItem(this.settingsTextRMV + "\n", "");
        form.append((Item)stringItem5);
        this.editRMV_During_Dive = new TextField("Dive (ltr/min) ", Long.toString(this.sd.RMV_During_Dive), 2, 2);
        this.editRMV_During_Deco = new TextField("Deco (ltr/min) ", Long.toString(this.sd.RMV_During_Deco), 2, 2);
        form.append((Item)this.editRMV_During_Dive);
        form.append((Item)this.editRMV_During_Deco);
        StringItem stringItem6 = new StringItem(this.settingsTextmaxDivePPO2 + "\n", "");
        form.append((Item)stringItem6);
        String string = Long.toString(MathFP.toLong(MathFP.round(MathFP.mul(this.sd.Max_PO2_Dive, MathFP.toFP(10)), 0)));
        this.editMax_PO2_Dive = new TextField("(10*bar)", string, 3, 2);
        form.append((Item)this.editMax_PO2_Dive);
        StringItem stringItem7 = new StringItem(this.settingsTextmaxDecoPPO2 + "\n", "");
        form.append((Item)stringItem7);
        string = Long.toString(MathFP.toLong(MathFP.round(MathFP.mul(this.sd.Max_PO2_Deco, MathFP.toFP(10)), 0)));
        this.editMax_PO2_Deco = new TextField("(10*bar)", string, 3, 2);
        form.append((Item)this.editMax_PO2_Deco);
        form.append((Item)new StringItem(" ", null));
        StringItem stringItem8 = new StringItem("B\u00fchlmann Settings\n", "");
        form.append((Item)stringItem8);
        StringItem stringItem9 = new StringItem(this.settingsTextInitialDescent + "\n", "");
        form.append((Item)stringItem9);
        this.editRate_Initial_Descent = new TextField("(m/min)", Long.toString(this.sd.Rate_Initial_Descent), 3, 2);
        form.append((Item)this.editRate_Initial_Descent);
        StringItem stringItem10 = new StringItem(this.settingsTextGradientFactors + "\n", "");
        form.append((Item)stringItem10);
        this.editGradient_Factor_Lo = new TextField(this.settingsTextGFLow + " ", Long.toString(this.sd.Gradient_Factor_Lo), 2, 2);
        this.editGradient_Factor_Hi = new TextField(this.settingsTextGFHigh + " ", Long.toString(this.sd.Gradient_Factor_Hi), 4, 2);
        form.append((Item)this.editGradient_Factor_Lo);
        form.append((Item)this.editGradient_Factor_Hi);
        form.append((Item)new StringItem(" ", null));
        StringItem stringItem11 = new StringItem("VPM-B Settings\n", "");
        form.append((Item)stringItem11);
        this.editCriticalVolume = new ChoiceGroup("Crit Vol Algorithm", 1);
        this.editCriticalVolume.append("On", null);
        this.editCriticalVolume.append("Off", null);
        if (this.sd.Critical_Volume_Algorithm) {
            this.editCriticalVolume.setSelectedIndex(0, true);
        } else {
            this.editCriticalVolume.setSelectedIndex(1, true);
        }
        form.append((Item)this.editCriticalVolume);
        this.editConservativity = new ChoiceGroup("Conservativity", 1);
        this.editConservativity.append(this.sd.Conservativity_Names[0], null);
        this.editConservativity.append(this.sd.Conservativity_Names[1], null);
        this.editConservativity.append(this.sd.Conservativity_Names[2], null);
        this.editConservativity.append(this.sd.Conservativity_Names[3], null);
        this.editConservativity.append(this.sd.Conservativity_Names[4], null);
        this.editConservativity.append(this.sd.Conservativity_Names[5], null);
        if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[0]) {
            this.editConservativity.setSelectedIndex(0, true);
        } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[1]) {
            this.editConservativity.setSelectedIndex(1, true);
        } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[2]) {
            this.editConservativity.setSelectedIndex(2, true);
        } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[3]) {
            this.editConservativity.setSelectedIndex(3, true);
        } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[4]) {
            this.editConservativity.setSelectedIndex(4, true);
        } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[5]) {
            this.editConservativity.setSelectedIndex(5, true);
        }
        form.append((Item)this.editConservativity);
        form.addCommand(this.okSettings2Command);
        form.addCommand(this.cancelSettings2Command);
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildDiveDataForm(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6) {
        this.GCeditFields();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n = 0;
        if (this.sd.VPMBalgorithm) {
            if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[0]) {
                n = 0;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[1]) {
                n = 1;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[2]) {
                n = 2;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[3]) {
                n = 3;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[4]) {
                n = 4;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[5]) {
                n = 5;
            }
            string5 = "VPM-B (" + this.sd.Conservativity_Names[n] + ")";
        } else {
            string5 = "ZH-L16B (" + Long.toString(this.sd.Gradient_Factor_Lo) + "/" + Long.toString(this.sd.Gradient_Factor_Hi) + ")";
        }
        long l = MathFP.toLong(MathFP.round(this.RunTimeInitialDescent, 0));
        if (l == 0L) {
            l = 1L;
        }
        string = string + "0 -> " + Long.toString(lArray[0]) + "m " + Long.toString(l) + "min\n";
        int n2 = 0;
        while (lArray[n2] != 9999L) {
            string = this.sd.Stop_Times_Flag == 1 ? string + Long.toString(lArray[n2]) + "m  " + Long.toString(lArray2[n2]) + "min  " + this.gd.Mix_Name[(int)lArray5[n2]] + "\n" : (this.sd.Stop_Times_Flag == 0 ? string + Long.toString(lArray[n2]) + "m  " + Long.toString(lArray3[n2]) + "min  " + this.gd.Mix_Name[(int)lArray5[n2]] + "\n" : string + Long.toString(lArray[n2]) + "m  " + Long.toString(lArray2[n2]) + " (" + Long.toString(lArray3[n2]) + ") " + this.gd.Mix_Name[(int)lArray5[n2]] + "\n");
            ++n2;
        }
        string4 = Long.toString(lArray[++n2]) + "m\n";
        n2 = 0;
        while (lArray4[n2] != 9999L) {
            if (lArray4[n2] > 1L) {
                string3 = this.gd.Cylinder_Volume[n2] > 1L ? string3 + this.gd.Mix_Name[n2] + " " + Long.toString(lArray4[n2]) + "bar " + Long.toString(this.gd.Cylinder_Volume[n2]) + "ltr\n" : string3 + this.gd.Mix_Name[n2] + " " + Long.toString(lArray4[n2]) + "ltr\n";
            }
            ++n2;
        }
        string6 = Long.toString(this.Complete_Runtime) + "min";
        Form form = new Form("DATA LAST DIVE");
        StringItem stringItem = new StringItem("Dive Profile\n", string);
        form.append((Item)stringItem);
        StringItem stringItem2 = new StringItem("Final Deco Start\n", string4);
        form.append((Item)stringItem2);
        StringItem stringItem3 = new StringItem("Deco Settings\n", string5 + "\n" + string2);
        form.append((Item)stringItem3);
        StringItem stringItem4 = new StringItem("Gas Usage\n", string3);
        form.append((Item)stringItem4);
        StringItem stringItem5 = new StringItem("Total Runtime\n", string6);
        form.append((Item)stringItem5);
        StringItem stringItem6 = new StringItem("O2 Toxicity\n", "CNS%: " + Long.toString(MathFP.toLong(this.diveCNS)) + "\n" + "OTU: " + Long.toString(MathFP.toLong(this.diveseriesOTU)));
        form.append((Item)stringItem6);
        this.calcPlusXmin = new Command("+" + Long.toString(this.sd.Change_Time) + " min", 8, 1);
        this.calcMinusXmin = new Command("-" + Long.toString(this.sd.Change_Time) + " min", 8, 1);
        this.calcPlusXmeter = new Command("+" + Long.toString(this.sd.Change_Depth) + " meter", 8, 1);
        this.calcMinusXmeter = new Command("-" + Long.toString(this.sd.Change_Depth) + " meter", 8, 1);
        form.addCommand(this.okDiveDataCommand);
        form.addCommand(this.calcPlusXmin);
        form.addCommand(this.calcMinusXmin);
        form.addCommand(this.calcPlusXmeter);
        form.addCommand(this.calcMinusXmeter);
        int n3 = 0;
        while (this.dd.Dive_Profile[n3][0][0] != 9999L) {
            ++n3;
        }
        int n4 = 0;
        while (this.dd.Deco_Settings[n3 - 1][n4][0] != 999L) {
            ++n4;
        }
        for (int i = 0; i < n4; ++i) {
            this.calcBailout[i] = new Command("Loss of " + this.gd.Mix_Name[(int)this.dd.Deco_Settings[n3 - 1][i][1]], 8, 1);
            if (!this.bailoutFlag) {
                form.addCommand(this.calcBailout[i]);
                continue;
            }
            if (this.bailoutGasLoss == (int)this.dd.Deco_Settings[n3 - 1][i][1]) continue;
            form.addCommand(this.calcBailout[i]);
        }
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildDiveDataFormCCR(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6, long[] lArray7) {
        StringItem stringItem;
        this.GCeditFields();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (this.dd.Dive_Profile[n2][0][0] != 9999L) {
            ++n2;
        }
        if (this.sd.VPMBalgorithm) {
            if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[0]) {
                n = 0;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[1]) {
                n = 1;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[2]) {
                n = 2;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[3]) {
                n = 3;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[4]) {
                n = 4;
            } else if (this.sd.Conservativity_Percent == (long)this.sd.Conservativity_Levels[5]) {
                n = 5;
            }
            string5 = "VPM-B (" + this.sd.Conservativity_Names[n] + ")";
        } else {
            string5 = "ZH-L16B (" + Long.toString(this.sd.Gradient_Factor_Lo) + "/" + Long.toString(this.sd.Gradient_Factor_Hi) + ")";
        }
        long l = MathFP.toLong(MathFP.round(this.RunTimeInitialDescent, 0));
        if (l == 0L) {
            l = 1L;
        }
        string = string + "0 -> " + Long.toString(lArray[0]) + "m " + Long.toString(l) + "min " + MathFP.toString(MathFP.round(this.dd.Dive_Profile[n2 - 1][0][3], 1)).substring(0, 3) + "\n";
        int n3 = 0;
        while (lArray[n3] != 9999L) {
            string = this.sd.Stop_Times_Flag == 1 ? string + Long.toString(lArray[n3]) + "m " + Long.toString(lArray2[n3]) + "min " + this.gd.Mix_Name[(int)lArray5[n3]] : (this.sd.Stop_Times_Flag == 0 ? string + Long.toString(lArray[n3]) + "m " + Long.toString(lArray3[n3]) + "min " + this.gd.Mix_Name[(int)lArray5[n3]] : string + Long.toString(lArray[n3]) + "m " + Long.toString(lArray2[n3]) + "(" + Long.toString(lArray3[n3]) + ")" + this.gd.Mix_Name[(int)lArray5[n3]]);
            string = !this.bailoutCCRFlag || lArray7[n3] == 0L ? string + " " + MathFP.toString(MathFP.round(lArray6[n3], 1)).substring(0, 3) + "\n" : string + " OC\n";
            ++n3;
        }
        string4 = Long.toString(lArray[++n3]) + "m\n";
        n3 = 0;
        while (lArray4[n3] != 9999L) {
            if (lArray4[n3] > 1L) {
                bl = true;
                string3 = this.gd.Cylinder_Volume[n3] > 1L ? string3 + this.gd.Mix_Name[n3] + " " + Long.toString(lArray4[n3]) + "bar " + Long.toString(this.gd.Cylinder_Volume[n3]) + "ltr\n" : string3 + this.gd.Mix_Name[n3] + " " + Long.toString(lArray4[n3]) + "ltr\n";
            }
            ++n3;
        }
        string6 = Long.toString(this.Complete_Runtime) + "min";
        Form form = new Form("DATA LAST DIVE");
        StringItem stringItem2 = new StringItem("Dive Profile\n", string);
        form.append((Item)stringItem2);
        StringItem stringItem3 = new StringItem("Final Deco Start\n", string4);
        form.append((Item)stringItem3);
        if (!this.bailoutCCRFlag) {
            form.append((Item)new StringItem("Deco Settings\n", string5 + "\n" + string2));
        } else {
            form.append((Item)new StringItem("Bailout Profile\n", string5 + "\n" + string2));
        }
        if (bl) {
            stringItem = new StringItem("Gas Usage\n", string3);
            form.append((Item)stringItem);
        }
        stringItem = new StringItem("Total Runtime\n", string6);
        form.append((Item)stringItem);
        StringItem stringItem4 = new StringItem("O2 Toxicity\n", "CNS%: " + Long.toString(MathFP.toLong(this.diveCNS)) + "\n" + "OTU: " + Long.toString(MathFP.toLong(this.diveseriesOTU)));
        form.append((Item)stringItem4);
        this.calcPlusXmin = new Command("+" + Long.toString(this.sd.Change_Time) + " min", 8, 1);
        this.calcMinusXmin = new Command("-" + Long.toString(this.sd.Change_Time) + " min", 8, 1);
        this.calcPlusXmeter = new Command("+" + Long.toString(this.sd.Change_Depth) + " meter", 8, 1);
        this.calcMinusXmeter = new Command("-" + Long.toString(this.sd.Change_Depth) + " meter", 8, 1);
        form.addCommand(this.okDiveDataCommand);
        if (!this.bailoutCCRFlag) {
            int n4 = 0;
            while (this.dd.Deco_Settings[n2 - 1][n4][0] != 999L) {
                ++n4;
            }
            if (n4 != 0) {
                form.addCommand(this.calcCCRBailout);
            }
            form.addCommand(this.calcPlusXmin);
            form.addCommand(this.calcMinusXmin);
            form.addCommand(this.calcPlusXmeter);
            form.addCommand(this.calcMinusXmeter);
        }
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildDiveAddEditForm(String string) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (this.dd.Dive_Profile[n3][0][0] != 9999L) {
            ++n3;
        }
        while (this.gd.Fraction_Oxygen[n4] != 9999L) {
            ++n4;
        }
        String string2 = string.equals("add") ? "ADD NEW DIVE" : "EDIT LAST DIVE";
        Form form = new Form(string2);
        if (n3 > 0 && string.equals("add") || n3 > 1 && string.equals("edit")) {
            if (string.equals("add")) {
                string2 = null;
            } else {
                long l = MathFP.div(MathFP.toFP(this.dd.Surface_Interval[n3 - 2]), MathFP.toFP(60));
                l = MathFP.round(l, 1);
                string2 = MathFP.toString(l).substring(0, 3);
            }
            form.append((Item)new StringItem("Surface Interval\n", ""));
            this.addEditSurfaceInterval = new TextField("(hr)", string2, 3, 2);
            form.append((Item)this.addEditSurfaceInterval);
        }
        int n5 = 0;
        if (string.equals("edit")) {
            while (this.dd.Dive_Profile[n3 - 1][n5][0] != 999L) {
                ++n5;
            }
        }
        StringItem stringItem = new StringItem("Dive Levels\n", "");
        form.append((Item)stringItem);
        for (n2 = 0; n2 < this.sd.Number_Levels; ++n2) {
            string2 = string.equals("add") || n2 >= n5 ? null : Long.toString(this.dd.Dive_Profile[n3 - 1][n2][0]);
            this.addEditDiveLevelsDepth[n2] = new TextField("Depth (m)", string2, 3, 2);
            string2 = string.equals("add") || n2 >= n5 ? null : Long.toString(this.dd.Dive_Profile[n3 - 1][n2][1]);
            this.addEditDiveLevelsTime[n2] = new TextField("Time (min)", string2, 2, 2);
            this.addEditDiveLevelsGas[n2] = new ChoiceGroup(null, 4);
            for (n = 0; n < n4; ++n) {
                if (this.gd.DecoMix_Flag[n] != 0 && this.gd.DecoMix_Flag[n] != 2) continue;
                this.addEditDiveLevelsGas[n2].append(this.gd.Mix_Name[n], null);
            }
            if (string.equals("add") || n2 >= n5) {
                this.addEditDiveLevelsGas[n2].setSelectedIndex(0, true);
            } else {
                String string3 = this.gd.Mix_Name[(int)this.dd.Dive_Profile[n3 - 1][n2][2]];
                for (n = 0; n < this.addEditDiveLevelsGas[n2].size(); ++n) {
                    if (!string3.equals(this.addEditDiveLevelsGas[n2].getString(n))) continue;
                    this.addEditDiveLevelsGas[n2].setSelectedIndex(n, true);
                    break;
                }
            }
            form.append((Item)this.addEditDiveLevelsDepth[n2]);
            form.append((Item)this.addEditDiveLevelsTime[n2]);
            form.append((Item)this.addEditDiveLevelsGas[n2]);
        }
        int n6 = 0;
        if (string.equals("edit")) {
            while (this.dd.Deco_Settings[n3 - 1][n6][0] != 999L) {
                ++n6;
            }
        }
        if (JDeco.MAX_DECO_MIXES > 0) {
            int n7;
            n2 = 0;
            n = 0;
            for (int i = 0; i < n4; ++i) {
                if (this.gd.DecoMix_Flag[i] != 1 && this.gd.DecoMix_Flag[i] != 2) continue;
                if (string.equals("add")) {
                    this.addEditDecoSwitchDepthGas[n] = new TextField(this.gd.Mix_Name[i] + " (m)", null, 3, 2);
                } else {
                    String string4 = null;
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (this.dd.Deco_Settings[n3 - 1][n7][1] != (long)i) continue;
                        string4 = Long.toString(this.dd.Deco_Settings[n3 - 1][n7][0]);
                        break;
                    }
                    this.addEditDecoSwitchDepthGas[n] = new TextField(this.gd.Mix_Name[i] + " (m)", string4, 3, 2);
                }
                if (n2 == 0) {
                    form.append((Item)new StringItem("Deco Mix Depths", null));
                    n2 = 1;
                }
                form.append((Item)this.addEditDecoSwitchDepthGas[n]);
                ++n;
            }
            if (n > 0) {
                StringItem stringItem2 = new StringItem("Extra Stop Times", null);
                form.append((Item)stringItem2);
                n7 = 0;
                for (int i = 0; i < n; ++i) {
                    string2 = "";
                    if (!string.equals("add") && this.addEditDecoSwitchDepthGas[i].size() > 0) {
                        string2 = Long.toString(this.dd.Deco_Settings[n3 - 1][n7][2]);
                        ++n7;
                    }
                    this.addStopTime[i] = new TextField(this.addEditDecoSwitchDepthGas[i].getLabel().substring(0, this.addEditDecoSwitchDepthGas[i].getLabel().length() - 4) + " (min)", string2, 2, 2);
                    form.append((Item)this.addStopTime[i]);
                }
            } else {
                StringItem stringItem3 = new StringItem("Deco Mix:", "Last Bottom Gas");
                form.append((Item)stringItem3);
            }
        } else {
            StringItem stringItem4 = new StringItem("Deco Mix:", "Last Bottom Gas");
            form.append((Item)stringItem4);
        }
        if (string.equals("add")) {
            form.addCommand(this.okDiveAddCommand);
            form.addCommand(this.cancelDiveAddCommand);
        } else if (string.equals("edit")) {
            form.addCommand(this.okDiveEditCommand);
            form.addCommand(this.cancelDiveEditCommand);
        }
        form.setCommandListener((CommandListener)this);
        return form;
    }

    public Form buildDiveAddEditFormCCR(String string) {
        String string2;
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (this.dd.Dive_Profile[n3][0][0] != 9999L) {
            ++n3;
        }
        while (this.gd.Fraction_Oxygen[n4] != 9999L) {
            ++n4;
        }
        String string3 = string.equals("add") ? "ADD NEW DIVE" : "EDIT LAST DIVE";
        Form form = new Form(string3);
        if (n3 > 0 && string.equals("add") || n3 > 1 && string.equals("edit")) {
            if (string.equals("add")) {
                string3 = null;
            } else {
                long l = MathFP.div(MathFP.toFP(this.dd.Surface_Interval[n3 - 2]), MathFP.toFP(60));
                l = MathFP.round(l, 1);
                string3 = MathFP.toString(l).substring(0, 3);
            }
            form.append((Item)new StringItem("Surface Interval\n", ""));
            this.addEditSurfaceInterval = new TextField("(hr)", string3, 3, 2);
            form.append((Item)this.addEditSurfaceInterval);
        }
        int n5 = 0;
        if (string.equals("edit")) {
            while (this.dd.Dive_Profile[n3 - 1][n5][0] != 999L) {
                ++n5;
            }
        }
        StringItem stringItem = new StringItem("Dive Levels\n", "");
        form.append((Item)stringItem);
        for (n2 = 0; n2 < this.sd.Number_Levels; ++n2) {
            string3 = string.equals("add") || n2 >= n5 ? null : Long.toString(this.dd.Dive_Profile[n3 - 1][n2][0]);
            this.addEditDiveLevelsDepth[n2] = new TextField("Depth (m)", string3, 3, 2);
            string3 = string.equals("add") || n2 >= n5 ? null : Long.toString(this.dd.Dive_Profile[n3 - 1][n2][1]);
            this.addEditDiveLevelsTime[n2] = new TextField("Time (min)", string3, 2, 2);
            string3 = string.equals("add") || n2 >= n5 ? null : Long.toString(MathFP.toLong(MathFP.round(MathFP.mul(this.dd.Dive_Profile[n3 - 1][n2][3], MathFP.toFP(10)), 0)));
            this.addEditDiveLevelsPPO2[n2] = new TextField("PPO2 (10*bar)", string3, 3, 2);
            this.addEditDiveLevelsGas[n2] = new ChoiceGroup("Diluent", 4);
            for (n = 0; n < n4; ++n) {
                if (this.gd.DecoMix_Flag[n] != 0 && this.gd.DecoMix_Flag[n] != 2) continue;
                this.addEditDiveLevelsGas[n2].append(this.gd.Mix_Name[n], null);
            }
            if (string.equals("add") || n2 >= n5) {
                this.addEditDiveLevelsGas[n2].setSelectedIndex(0, true);
            } else {
                string2 = this.gd.Mix_Name[(int)this.dd.Dive_Profile[n3 - 1][n2][2]];
                for (n = 0; n < this.addEditDiveLevelsGas[n2].size(); ++n) {
                    if (!string2.equals(this.addEditDiveLevelsGas[n2].getString(n))) continue;
                    this.addEditDiveLevelsGas[n2].setSelectedIndex(n, true);
                    break;
                }
            }
            form.append((Item)this.addEditDiveLevelsDepth[n2]);
            form.append((Item)this.addEditDiveLevelsTime[n2]);
            form.append((Item)this.addEditDiveLevelsPPO2[n2]);
            form.append((Item)this.addEditDiveLevelsGas[n2]);
        }
        form.append((Item)new StringItem("\nDeco Settings", null));
        int n6 = 0;
        if (string.equals("edit")) {
            while (this.dd.CCR_Deco_Settings[n3 - 1][n6][0] != 999L) {
                ++n6;
            }
        }
        n2 = 0;
        while (true) {
            if (n2 >= JDeco.MAX_CCR_DECO_SETTINGS) break;
            string3 = string.equals("add") || n2 >= n6 ? null : Long.toString(this.dd.CCR_Deco_Settings[n3 - 1][n2][0]);
            this.addEditDecoCCRDepth[n2] = new TextField("Depth (m)", string3, 3, 2);
            string3 = string.equals("add") || n2 >= n6 ? null : Long.toString(MathFP.toLong(MathFP.round(MathFP.mul(this.dd.CCR_Deco_Settings[n3 - 1][n2][2], MathFP.toFP(10)), 0)));
            this.addEditDecoCCRPPO2[n2] = new TextField("PPO2 (10*bar)", string3, 3, 2);
            this.addEditDecoCCRGas[n2] = new ChoiceGroup("Diluent", 4);
            for (n = 0; n < n4; ++n) {
                if (this.gd.DecoMix_Flag[n] != 0 && this.gd.DecoMix_Flag[n] != 2) continue;
                this.addEditDecoCCRGas[n2].append(this.gd.Mix_Name[n], null);
            }
            if (string.equals("add") || n2 >= n6) {
                this.addEditDecoCCRGas[n2].setSelectedIndex(0, true);
            } else {
                string2 = this.gd.Mix_Name[(int)this.dd.CCR_Deco_Settings[n3 - 1][n2][1]];
                for (n = 0; n < this.addEditDecoCCRGas[n2].size(); ++n) {
                    if (!string2.equals(this.addEditDecoCCRGas[n2].getString(n))) continue;
                    this.addEditDecoCCRGas[n2].setSelectedIndex(n, true);
                    break;
                }
            }
            form.append((Item)this.addEditDecoCCRDepth[n2]);
            form.append((Item)this.addEditDecoCCRPPO2[n2]);
            form.append((Item)this.addEditDecoCCRGas[n2]);
            ++n2;
        }
        form.append((Item)new StringItem(" ", null));
        int n7 = 0;
        if (string.equals("edit")) {
            while (this.dd.Deco_Settings[n3 - 1][n7][0] != 999L) {
                ++n7;
            }
        }
        if (JDeco.MAX_DECO_MIXES > 0) {
            n2 = 0;
            n = 0;
            for (int i = 0; i < n4; ++i) {
                if (this.gd.DecoMix_Flag[i] != 1 && this.gd.DecoMix_Flag[i] != 2) continue;
                if (string.equals("add")) {
                    this.addEditDecoSwitchDepthGas[n] = new TextField(this.gd.Mix_Name[i] + " (m)", null, 3, 2);
                } else {
                    String string4 = null;
                    for (int j = 0; j < n7; ++j) {
                        if (this.dd.Deco_Settings[n3 - 1][j][1] != (long)i) continue;
                        string4 = Long.toString(this.dd.Deco_Settings[n3 - 1][j][0]);
                        break;
                    }
                    this.addEditDecoSwitchDepthGas[n] = new TextField(this.gd.Mix_Name[i] + " (m)", string4, 3, 2);
                }
                if (n2 == 0) {
                    form.append((Item)new StringItem("Bailout Mix Depths", null));
                    n2 = 1;
                }
                form.append((Item)this.addEditDecoSwitchDepthGas[n]);
                ++n;
            }
        } else {
            form.append((Item)new StringItem("\nBailout Mixes", "No bailout mixes present"));
        }
        if (string.equals("add")) {
            form.addCommand(this.okDiveAddCommand);
            form.addCommand(this.cancelDiveAddCommand);
        } else if (string.equals("edit")) {
            form.addCommand(this.okDiveEditCommand);
            form.addCommand(this.cancelDiveEditCommand);
        }
        form.setCommandListener((CommandListener)this);
        return form;
    }

    private void addUpdateDive(String string) {
        int n;
        String string2;
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (this.dd.Dive_Profile[n3][0][0] != 9999L) {
            ++n3;
        }
        n4 = string.equals("add") ? n3 : n3 - 1;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < this.sd.Number_Levels; ++n2) {
            String string3 = this.addEditDiveLevelsDepth[n2].getString();
            String string4 = this.addEditDiveLevelsTime[n2].getString();
            string2 = this.addEditDiveLevelsGas[n2].getString(this.addEditDiveLevelsGas[n2].getSelectedIndex());
            n = 0;
            while (true) {
                if (n >= JDeco.MAX_MIXES) break;
                if (string2.equals(this.gd.Mix_Name[n])) {
                    n5 = n;
                    break;
                }
                ++n;
            }
            if (this.addEditDiveLevelsDepth[n2].size() == 0 || this.addEditDiveLevelsTime[n2].size() == 0) continue;
            long l = Long.parseLong(string3);
            long l2 = Long.parseLong(string4);
            if (l <= 0L) continue;
            if (l > JDeco.MAX_DIVE_DEPTH || l2 <= 0L) continue;
            this.dd.Dive_Profile[n4][n6][0] = l;
            this.dd.Dive_Profile[n4][n6][1] = l2;
            this.dd.Dive_Profile[n4][n6][2] = n5;
            ++n6;
        }
        this.dd.Dive_Profile[n4][n6][0] = 999L;
        if (n4 > 0) {
            if (this.addEditSurfaceInterval.size() != 0) {
                long l = MathFP.toFP(this.addEditSurfaceInterval.getString());
                if (l > MathFP.toFP(100)) {
                    l = MathFP.toFP(100);
                }
                l = MathFP.mul(l, MathFP.toFP(60));
                l = MathFP.toLong(l);
                this.dd.Surface_Interval[n4 - 1] = this.addEditSurfaceInterval.size() == 0 ? 0L : l;
            } else {
                n6 = 0;
            }
        }
        if (n6 == 0) {
            this.dd.Dive_Profile[n4][0][0] = 9999L;
        } else {
            this.dd.Dive_Profile[n4 + 1][0][0] = 9999L;
        }
        n2 = 0;
        n = 0;
        while (this.gd.Fraction_Oxygen[n2] != 9999L) {
            if (this.gd.DecoMix_Flag[n2] == 1 || this.gd.DecoMix_Flag[n2] == 2) {
                ++n;
            }
            ++n2;
        }
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.addEditDecoSwitchDepthGas[i].size() > 0) {
                long l = Long.parseLong(this.addEditDecoSwitchDepthGas[i].getString());
                string2 = this.addEditDecoSwitchDepthGas[i].getLabel().substring(0, this.addEditDecoSwitchDepthGas[i].getLabel().length() - 4);
                int n8 = 0;
                while (true) {
                    if (n8 >= JDeco.MAX_MIXES) break;
                    if (string2.equals(this.gd.Mix_Name[n8])) {
                        n5 = n8;
                        break;
                    }
                    ++n8;
                }
                this.dd.Deco_Settings[n4][n7][0] = l;
                this.dd.Deco_Settings[n4][n7][1] = n5;
                this.dd.Deco_Settings[n4][n7][2] = this.addStopTime[i].getString().length() == 0 ? 0L : Long.parseLong(this.addStopTime[i].getString());
                ++n7;
            }
            if (n7 == JDeco.MAX_DECO_MIXES) break;
        }
        this.dd.Deco_Settings[n4][n7][0] = 999L;
        this.dd.CCR_Deco_Settings[n4][0][0] = 999L;
    }

    private void addUpdateDiveCCR(String string) {
        int n;
        int n2;
        long l;
        long l2;
        int n3;
        String string2;
        String string3;
        String string4;
        int n4;
        int n5 = 0;
        int n6 = 0;
        while (this.dd.Dive_Profile[n5][0][0] != 9999L) {
            ++n5;
        }
        n6 = string.equals("add") ? n5 : n5 - 1;
        int n7 = 0;
        long l3 = 0L;
        int n8 = 0;
        for (n4 = 0; n4 < this.sd.Number_Levels; ++n4) {
            string4 = this.addEditDiveLevelsDepth[n4].getString();
            String string5 = this.addEditDiveLevelsTime[n4].getString();
            string3 = this.addEditDiveLevelsPPO2[n4].getString();
            string2 = this.addEditDiveLevelsGas[n4].getString(this.addEditDiveLevelsGas[n4].getSelectedIndex());
            n3 = 0;
            while (true) {
                if (n3 >= JDeco.MAX_MIXES) break;
                if (string2.equals(this.gd.Mix_Name[n3])) {
                    n7 = n3;
                    break;
                }
                ++n3;
            }
            if (this.addEditDiveLevelsDepth[n4].size() == 0 || this.addEditDiveLevelsTime[n4].size() == 0 || this.addEditDiveLevelsPPO2[n4].size() == 0) continue;
            l2 = Long.parseLong(string4);
            long l4 = Long.parseLong(string5);
            l = MathFP.div(MathFP.toFP(string3), MathFP.toFP(10));
            if (l2 <= 0L) continue;
            if (l2 > JDeco.MAX_DIVE_DEPTH || l4 <= 0L || l <= 0L) continue;
            if (l > MathFP.toFP(JDeco.MAX_PO2)) continue;
            this.dd.Dive_Profile[n6][n8][0] = l2;
            this.dd.Dive_Profile[n6][n8][1] = l4;
            this.dd.Dive_Profile[n6][n8][2] = n7;
            this.dd.Dive_Profile[n6][n8][3] = l;
            l3 = l2;
            ++n8;
        }
        this.dd.Dive_Profile[n6][n8][0] = 999L;
        if (n6 > 0) {
            if (this.addEditSurfaceInterval.size() != 0) {
                long l5 = MathFP.toFP(this.addEditSurfaceInterval.getString());
                if (l5 > MathFP.toFP(100)) {
                    l5 = MathFP.toFP(100);
                }
                l5 = MathFP.mul(l5, MathFP.toFP(60));
                l5 = MathFP.toLong(l5);
                this.dd.Surface_Interval[n6 - 1] = this.addEditSurfaceInterval.size() == 0 ? 0L : l5;
            } else {
                n8 = 0;
            }
        }
        if (n8 == 0) {
            this.dd.Dive_Profile[n6][0][0] = 9999L;
        } else {
            this.dd.Dive_Profile[n6 + 1][0][0] = 9999L;
        }
        n4 = 0;
        n3 = 0;
        int n9 = 0;
        int n10 = 0;
        while (this.gd.Fraction_Oxygen[n9] != 9999L) {
            if (this.gd.DecoMix_Flag[n9] == 1 || this.gd.DecoMix_Flag[n9] == 2) {
                ++n10;
            }
            ++n9;
        }
        int n11 = 0;
        for (n2 = 0; n2 < n10; ++n2) {
            if (this.addEditDecoSwitchDepthGas[n2].size() > 0) {
                n3 = 1;
                long l6 = Long.parseLong(this.addEditDecoSwitchDepthGas[n2].getString());
                string2 = this.addEditDecoSwitchDepthGas[n2].getLabel().substring(0, this.addEditDecoSwitchDepthGas[n2].getLabel().length() - 4);
                n = 0;
                while (true) {
                    if (n >= JDeco.MAX_MIXES) break;
                    if (string2.equals(this.gd.Mix_Name[n])) {
                        n7 = n;
                        break;
                    }
                    ++n;
                }
                if (l6 >= l3) {
                    n4 = 1;
                }
                this.dd.Deco_Settings[n6][n11][0] = l6;
                this.dd.Deco_Settings[n6][n11][1] = n7;
                this.dd.Deco_Settings[n6][n11][2] = 0L;
                ++n11;
            }
            if (n11 == JDeco.MAX_DECO_MIXES) break;
        }
        this.dd.Deco_Settings[n6][n11][0] = 999L;
        if (n4 == 0) {
            this.dd.Deco_Settings[n6][0][0] = 999L;
            if (n3 != 0) {
                this.deepBailOutMixError = true;
            }
        }
        int n12 = 0;
        n2 = 0;
        while (true) {
            if (n2 >= JDeco.MAX_CCR_DECO_SETTINGS) break;
            string4 = this.addEditDecoCCRDepth[n2].getString();
            string3 = this.addEditDecoCCRPPO2[n2].getString();
            string2 = this.addEditDecoCCRGas[n2].getString(this.addEditDecoCCRGas[n2].getSelectedIndex());
            if (this.addEditDecoCCRDepth[n2].size() != 0 && this.addEditDecoCCRPPO2[n2].size() != 0) {
                l2 = Long.parseLong(string4);
                l = MathFP.div(MathFP.toFP(string3), MathFP.toFP(10));
                n = 0;
                while (true) {
                    if (n >= JDeco.MAX_MIXES) break;
                    if (string2.equals(this.gd.Mix_Name[n])) {
                        n7 = n;
                        break;
                    }
                    ++n;
                }
                if (l > 0L) {
                    if (l <= MathFP.toFP(JDeco.MAX_PO2)) {
                        this.dd.CCR_Deco_Settings[n6][n12][0] = l2;
                        this.dd.CCR_Deco_Settings[n6][n12][1] = n7;
                        this.dd.CCR_Deco_Settings[n6][n12][2] = l;
                        ++n12;
                    }
                }
            }
            ++n2;
        }
        this.dd.CCR_Deco_Settings[n6][n12][0] = 999L;
    }

    private void GCeditFields() {
        int n = 1;
        while (true) {
            if (n >= JDeco.MAX_LEVELS) break;
            this.addEditDiveLevelsDepth[n] = null;
            this.addEditDiveLevelsTime[n] = null;
            this.addEditDiveLevelsPPO2[n] = null;
            this.addEditDiveLevelsGas[n] = null;
            ++n;
        }
        n = 1;
        while (true) {
            if (n >= JDeco.MAX_CCR_DECO_SETTINGS) break;
            this.addEditDecoCCRDepth[n] = null;
            this.addEditDecoCCRPPO2[n] = null;
            this.addEditDecoCCRGas[n] = null;
            ++n;
        }
        n = 1;
        while (true) {
            if (n >= JDeco.MAX_DECO_MIXES) break;
            this.addStopTime[n] = null;
            ++n;
        }
        n = 1;
        while (true) {
            if (n >= JDeco.MAX_MIXES) break;
            this.mixOxygen[n] = null;
            this.mixHelium[n] = null;
            this.CylinderVolume[n] = null;
            this.editDecoMixFlag[n] = null;
            this.addEditDecoSwitchDepthGas[n] = null;
            ++n;
        }
        this.addEditSurfaceInterval = null;
        this.startViewChoice = null;
        this.editNumberLevels = null;
        this.OCSCRCCRChoice = null;
        this.stopOrRunTimeChoice = null;
        this.editAltitude_of_Dive = null;
        this.editGradient_Factor_Lo = null;
        this.editGradient_Factor_Hi = null;
        this.editRMV_During_Dive = null;
        this.editRMV_During_Deco = null;
        this.editRate_Initial_Descent = null;
        this.editRate_During_Dive = null;
        this.editRate_During_Deco = null;
        this.editRate_Last_Deco_Stop = null;
        this.editDeco_Stop_Step_Size = null;
        this.editLast_Deco_Stop_Depth = null;
        this.editMax_PO2_Dive = null;
        this.editMax_PO2_Deco = null;
        this.mixO2TopText = null;
        this.mixHeTopText = null;
        this.mixO2EndText = null;
        this.mixHeEndText = null;
        this.mixPEndText = null;
        this.mixO2StartText = null;
        this.mixHeStartText = null;
        this.mixPStartText = null;
        this.mixTText = null;
        this.mixVText = null;
        this.mixFillO2First = null;
        this.registrationKeyEntered = null;
        this.bestmixmaxEND = null;
        this.bestmixDepth = null;
        this.bestmixPPO2 = null;
        this.bestmixO2narcotic = null;
        this.algorithmChoice = null;
        this.editCriticalVolume = null;
        this.editConservativity = null;
        this.algorithmChoice = null;
        this.editCustomChangeTime = null;
        this.editCustomChangeDepth = null;
    }

    private long getBarometricPressure(long l) {
        long l2 = this.sd.calcBarometricPressure(this.sd.Altitude_of_Dive);
        if (this.sd.VPMBalgorithm) {
            l2 = MathFP.mul(MathFP.div(l2, MathFP.toFP("10.1325")), MathFP.toFP(10));
        }
        return l2;
    }

    public static void disp(long l) {
        System.out.println(Long.toString(l));
    }

    public static void dispFP(long l) {
        System.out.println(MathFP.toString(l));
    }

    public static void disp(int n) {
        System.out.println(Integer.toString(n));
    }

    public static void disp(String string) {
        System.out.println(string);
    }
}

