/*
 * Decompiled with CFR 0.152.
 */
package JDeco;

public class MathFP {
    public static boolean decimalKommaFlag = false;
    public static final long ONE = 0x1000000L;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final long MIN_VALUE = -9223372036854775807L;
    private static int PRECISION = 24;
    private static int digits = 8;
    private static long dmul = 100000000L;
    private static long fmask = 0xFFFFFFL;
    private static long minexponent = -335544320L;
    private static long[] e = new long[]{0x1000000L, 45605201L, 123967790L, 336979391L, 916004956L};

    public void MathFP() {
    }

    public static long toFP(long l) {
        return l << PRECISION;
    }

    public static long toFP(int n) {
        return (long)n << PRECISION;
    }

    public static long toFP(String string) {
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        String string2 = "-1";
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            n2 = string.indexOf(44);
        }
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1, string.length());
            while (string2.length() < digits) {
                string2 = string2 + "0";
            }
            if (string2.length() > digits) {
                string2 = string2.substring(0, digits);
            }
        } else {
            n2 = string.length();
        }
        long l = 0L;
        if (n != n2) {
            l = Long.parseLong(string.substring(n, n2));
        }
        long l2 = Long.parseLong(string2) + 1L;
        long l3 = (l << PRECISION) + (l2 << PRECISION) / dmul;
        if (n == 1) {
            l3 = -l3;
        }
        return l3;
    }

    public static String toString(long l) {
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        long l2 = l >> PRECISION;
        long l3 = dmul * (l & fmask) >> PRECISION;
        String string = Long.toString(l3);
        while (string.length() < digits) {
            string = "0" + string;
        }
        if (!decimalKommaFlag) {
            return (bl ? "-" : "") + Long.toString(l2) + "." + string;
        }
        return (bl ? "-" : "") + Long.toString(l2) + "," + string;
    }

    public static long toLong(long l) {
        if (l > 0L) {
            l = MathFP.add(l, MathFP.toFP("0.00001"));
        }
        if (l < 0L) {
            l = MathFP.sub(l, MathFP.toFP("0.00001"));
        }
        long l2 = l >> PRECISION;
        if (l < 0L && MathFP.toFP(l2) < l) {
            ++l2;
        }
        if (l > 0L && MathFP.toFP(l2) > l) {
            --l2;
        }
        return l2;
    }

    public static long add(long l, long l2) {
        return l + l2;
    }

    public static long sub(long l, long l2) {
        return l - l2;
    }

    public static long mul(long l, long l2) {
        boolean bl = false;
        int n = PRECISION;
        long l3 = fmask;
        if ((l & l3) == 0L) {
            return (l >> n) * l2;
        }
        if ((l2 & l3) == 0L) {
            return l * (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (MathFP.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            l3 >>= 1;
            --n;
        }
        long l4 = (l >> n) * (l2 >> n) << n;
        long l5 = (l & l3) * (l2 & l3) >> n;
        if ((l4 = l4 + (l5 += (l & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) * (l2 & l3) >> n) + ((l & l3) * (l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) >> n) << PRECISION - n) < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return bl ? -l4 : l4;
    }

    public static long div(long l, long l2) {
        boolean bl = false;
        int n = PRECISION;
        if (l2 == 0x1000000L) {
            return l;
        }
        if ((l2 & fmask) == 0L) {
            return l / (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (MathFP.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            --n;
        }
        long l3 = (l << n) / l2 << PRECISION - n;
        return bl ? -l3 : l3;
    }

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static long min(long l, long l2) {
        return l2 >= l ? l : l2;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static long ceil(long l) {
        if (l > 0L) {
            return MathFP.toFP(MathFP.toLong(l) + 1L);
        }
        if (l < 0L) {
            return MathFP.toFP(MathFP.toLong(l));
        }
        return 0L;
    }

    public static long floor(long l) {
        if (l > 0L) {
            return MathFP.toFP(MathFP.toLong(l));
        }
        if (l < 0L) {
            return MathFP.toFP(MathFP.toLong(l) - 1L);
        }
        return 0L;
    }

    public static long round(long l, int n) {
        long l2 = MathFP.toFP(1);
        for (int i = 0; i < n; ++i) {
            l2 = MathFP.mul(l2, MathFP.toFP(10));
        }
        if (l > 0L) {
            l = MathFP.floor(MathFP.add(MathFP.mul(l, l2), MathFP.toFP("0.5")));
            l = MathFP.add(l, MathFP.toFP("0.00001"));
            l = MathFP.div(l, l2);
        } else if (l < 0L) {
            l = MathFP.ceil(MathFP.sub(MathFP.mul(l, l2), MathFP.toFP("0.5")));
            l = MathFP.div(l, l2);
            l = MathFP.sub(l, MathFP.toFP("0.00001"));
        }
        return l;
    }

    public static long sqrt(long l) {
        if (l < 0L) {
            throw new ArithmeticException("Bad Input");
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = l + 0x1000000L >> 1;
        for (int i = 0; i < PRECISION; ++i) {
            l2 = l2 + MathFP.div(l, l2) >> 1;
        }
        if (l2 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return l2;
    }

    public static long crt(long l) {
        if (l == 0L) {
            return 0L;
        }
        long l2 = l + 0x1000000L >> 1;
        for (int i = 0; i < PRECISION; ++i) {
            l2 = l2 + MathFP.div(l, MathFP.mul(l2, l2)) >> 1;
        }
        if (l2 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return l2;
    }

    public static long pow3(long l) {
        return MathFP.mul(MathFP.mul(l, l), l);
    }

    public static long log(long l) {
        long l2;
        if (l <= 0L) {
            throw new ArithmeticException("Bad Input");
        }
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        while (l >= 0x2000000L) {
            l >>= 1;
            ++n;
        }
        long l5 = (long)n * 11629080L;
        long l6 = 0L;
        if (l < 0x1000000L) {
            return -MathFP.log(MathFP.div(0x1000000L, l));
        }
        l -= 0x1000000L;
        for (int i = 1; i < 20 && (l2 = l3 == 0L ? l : MathFP.mul(l3, l)) != 0L; ++i) {
            l6 += (i % 2 != 0 ? 1L : -1L) * l2 / (long)i;
            l3 = l2;
        }
        return l5 + l6;
    }

    public static long exp(long l) {
        if (l == 0L) {
            return 0x1000000L;
        }
        if (l < minexponent) {
            return 0L;
        }
        boolean bl = l < 0L;
        l = MathFP.abs(l);
        int n = (int)(l >> PRECISION);
        long l2 = 0x1000000L;
        for (int i = 0; i < n / 4; ++i) {
            l2 = MathFP.mul(l2, e[4]);
        }
        if (n % 4 > 0) {
            l2 = MathFP.mul(l2, e[n % 4]);
        }
        if ((l &= fmask) > 0L) {
            long l3 = 0x1000000L;
            long l4 = 0L;
            long l5 = 1L;
            for (int i = 0; i < 16; ++i) {
                l4 += l3 / l5;
                if ((l5 *= (long)(i + 1)) > (l3 = MathFP.mul(l3, l)) || l3 <= 0L || l5 <= 0L) break;
            }
            l2 = MathFP.mul(l2, l4);
        }
        if (bl) {
            l2 = MathFP.div(0x1000000L, l2);
        }
        return l2;
    }
}

