/*
 * Decompiled with CFR 0.152.
 */
package JDeco;

import JDeco.DiveData;
import JDeco.GasData;
import JDeco.JDeco;
import JDeco.MathFP;
import JDeco.SettingsData;
import JDeco.UserInterface;

public class CalculateDiveSeriesVPMB
extends Thread {
    private boolean running = true;
    public boolean calculationReady = false;
    private boolean doCCRbailoutFlag = false;
    private JDeco jd;
    private SettingsData sd;
    private GasData gd;
    private DiveData dd;
    private UserInterface ui;
    private long[] Nitrogen_Time_Constant = new long[]{MathFP.toFP("0.138629436"), MathFP.toFP("0.086643398"), MathFP.toFP("0.055451774"), MathFP.toFP("0.037467415"), MathFP.toFP("0.025672118"), MathFP.toFP("0.018097838"), MathFP.toFP("0.012765141"), MathFP.toFP("0.009001911"), MathFP.toFP("0.006359148"), MathFP.toFP("0.004747583"), MathFP.toFP("0.003706669"), MathFP.toFP("0.002900197"), MathFP.toFP("0.002272614"), MathFP.toFP("0.001777300"), MathFP.toFP("0.001391862"), MathFP.toFP("0.001091570")};
    private long[] Helium_Time_Constant = new long[]{MathFP.toFP("0.368695309"), MathFP.toFP("0.229518934"), MathFP.toFP("0.146853216"), MathFP.toFP("0.099162687"), MathFP.toFP("0.067889048"), MathFP.toFP("0.047869280"), MathFP.toFP("0.033762649"), MathFP.toFP("0.023811308"), MathFP.toFP("0.016823961"), MathFP.toFP("0.012559289"), MathFP.toFP("0.009805449"), MathFP.toFP("0.007672650"), MathFP.toFP("0.006012206"), MathFP.toFP("0.004701853"), MathFP.toFP("0.003682252"), MathFP.toFP("0.002887752")};
    private long[] PPO2axis = new long[]{MathFP.toFP("0.510"), MathFP.toFP("0.550"), MathFP.toFP("0.600"), MathFP.toFP("0.650"), MathFP.toFP("0.700"), MathFP.toFP("0.750"), MathFP.toFP("0.800"), MathFP.toFP("0.850"), MathFP.toFP("0.900"), MathFP.toFP("0.950"), MathFP.toFP("1.000"), MathFP.toFP("1.050"), MathFP.toFP("1.100"), MathFP.toFP("1.150"), MathFP.toFP("1.200"), MathFP.toFP("1.250"), MathFP.toFP("1.300"), MathFP.toFP("1.350"), MathFP.toFP("1.400"), MathFP.toFP("1.450"), MathFP.toFP("1.500"), MathFP.toFP("1.550"), MathFP.toFP("1.600"), MathFP.toFP("1.650"), MathFP.toFP("1.700"), MathFP.toFP("2.000")};
    private long[] CNSvalues = new long[]{MathFP.toFP("0.112"), MathFP.toFP("0.122"), MathFP.toFP("0.137"), MathFP.toFP("0.153"), MathFP.toFP("0.172"), MathFP.toFP("0.193"), MathFP.toFP("0.218"), MathFP.toFP("0.242"), MathFP.toFP("0.272"), MathFP.toFP("0.298"), MathFP.toFP("0.327"), MathFP.toFP("0.362"), MathFP.toFP("0.405"), MathFP.toFP("0.438"), MathFP.toFP("0.468"), MathFP.toFP("0.503"), MathFP.toFP("0.543"), MathFP.toFP("0.591"), MathFP.toFP("0.660"), MathFP.toFP("0.717"), MathFP.toFP("0.820"), MathFP.toFP("1.056"), MathFP.toFP("2.050"), MathFP.toFP("3.035"), MathFP.toFP("6.415"), MathFP.toFP("49.95")};
    private long[] OTUvalues = new long[]{MathFP.toFP("0.023"), MathFP.toFP("0.135"), MathFP.toFP("0.250"), MathFP.toFP("0.354"), MathFP.toFP("0.453"), MathFP.toFP("0.548"), MathFP.toFP("0.639"), MathFP.toFP("0.728"), MathFP.toFP("0.815"), MathFP.toFP("0.900"), MathFP.toFP("0.983"), MathFP.toFP("1.065"), MathFP.toFP("1.146"), MathFP.toFP("1.226"), MathFP.toFP("1.304"), MathFP.toFP("1.382"), MathFP.toFP("1.459"), MathFP.toFP("1.535"), MathFP.toFP("1.610"), MathFP.toFP("1.684"), MathFP.toFP("1.758"), MathFP.toFP("1.832"), MathFP.toFP("1.904"), MathFP.toFP("1.976"), MathFP.toFP("2.048"), MathFP.toFP("2.460")};
    public long Barometric_Pressure;
    private long Units_Factor = MathFP.toFP("32.80839895");
    private long Water_Vapor_Pressure = MathFP.toFP("1.86023622");
    private long[] Max_Crushing_Pressure_N2 = new long[16];
    private long[] Max_Crushing_Pressure_He = new long[16];
    private long[] Max_Actual_Gradient = new long[16];
    private long[] Surface_Phase_Volume_Time = new long[16];
    private long[] Amb_Pressure_Onset_of_Imperm = new long[16];
    private long[] Gas_Tension_Onset_of_Imperm = new long[16];
    private long[] Initial_Critical_Radius_N2 = new long[16];
    private long[] Initial_Critical_Radius_He = new long[16];
    private long[] Regenerated_Radius_He = new long[16];
    private long[] Regenerated_Radius_N2 = new long[16];
    private long[] Adjusted_Crushing_Pressure_He = new long[16];
    private long[] Adjusted_Crushing_Pressure_N2 = new long[16];
    private long[] Adjusted_Critical_Radius_N2 = new long[16];
    private long[] Adjusted_Critical_Radius_He = new long[16];
    private long[] Helium_Pressure = new long[16];
    private long[] Nitrogen_Pressure = new long[16];
    private long[] Fraction_Oxygen = new long[JDeco.MAX_MIXES];
    private long[] Fraction_Helium = new long[JDeco.MAX_MIXES];
    private long[] Fraction_Nitrogen = new long[JDeco.MAX_MIXES];
    private long[] Running_Gas_Volume = new long[JDeco.MAX_MIXES];
    private long[] Initial_Helium_Pressure = new long[16];
    private long[] Initial_Nitrogen_Pressure = new long[16];
    private long[] Allowable_Gradient_He = new long[16];
    private long[] Allowable_Gradient_N2 = new long[16];
    private long[] Initial_Allowable_Gradient_He = new long[16];
    private long[] Initial_Allowable_Gradient_N2 = new long[16];
    private long[] Deco_Gradient_He = new long[16];
    private long[] Deco_Gradient_N2 = new long[16];
    private long FACTOR_RADIUS = MathFP.toFP(10000);
    private long Constant_Pressure_Other_Gases;
    private long deepestStop;
    private long diveCNS;
    private long diveOTU;
    private long diveseriesOTU;
    private long Critical_Radius_N2;
    private long Critical_Radius_He;
    String text;
    long Depth_Start_of_Deco_Zone;
    int Number_Mixes;
    int Row_Dive_Data;
    int Dive_Number;
    int Mix_Number = 0;
    int Number_of_Dives;
    long Run_Time;
    long Depth_Last_Segment;
    long Depth_Segment = MathFP.toFP(0);
    long Time_Segment;
    long Time_Depth_Change;
    long Rate_Ascent;
    long Rate_Descent;
    long Rate;
    long[] He_Pressure_Start_of_Ascent = new long[16];
    long[] N2_Pressure_Start_of_Ascent = new long[16];
    long[] Last_Phase_Volume_Time = new long[16];
    long[] He_Pressure_Start_of_Deco_Zone = new long[16];
    long[] N2_Pressure_Start_of_Deco_Zone = new long[16];
    long[] Max_Actual_Gradient_Backup = new long[16];
    long[] Phase_Volume_Time = new long[16];
    long Critical_Volume_Comparison;
    long[] Running_Gas_Volume_Start_of_Deco_Zone = new long[JDeco.MAX_MIXES];
    long Run_Time_Start_of_Ascent;
    int Mix_Last_Segment;
    int index_result = 0;
    int index_result_backup;
    long Time_Depth_Constant;
    long Starting_Depth;
    long Step_Size;
    long Deepest_Possible_Stop_Depth;
    boolean Schedule_Converged;
    long Run_Time_Start_of_Deco_Zone;
    long Deco_Phase_Volume_Time;
    long Ascent_Ceiling_Depth;
    long Ending_Depth;
    long Surface_Interval_Time;
    boolean addExtraDecoSwitchTime = false;
    long Segment_Time;
    long Deco_Stop_Time;
    long test_max;
    long test;
    long Next_Stop;
    long Deco_Stop_Depth;
    long Deco_Ceiling_Depth;
    long Segment_Time_Start;
    long First_Stop_Depth;
    long diveCNS_Backup;
    long diveOTU_Backup;
    long diveseriesOTU_Backup;
    int errorFlag = 0;
    long PPO2Set_Segment = 0L;
    long PPO2Set_Segment_backup;
    int used_deco_gas_index = 0;
    long PPO2_Corrected = 0L;
    boolean lastAscentFlag = false;

    public CalculateDiveSeriesVPMB(JDeco jDeco, SettingsData settingsData, GasData gasData, DiveData diveData, UserInterface userInterface) {
        int n;
        this.jd = jDeco;
        this.sd = settingsData;
        this.gd = gasData;
        this.dd = diveData;
        this.ui = userInterface;
        this.Barometric_Pressure = this.sd.calcBarometricPressure(this.sd.Altitude_of_Dive);
        int n2 = 0;
        while (this.gd.Fraction_Oxygen[n2] != 9999L) {
            ++n2;
        }
        for (n = 0; n < n2; ++n) {
            this.Fraction_Oxygen[n] = MathFP.div(MathFP.toFP(this.gd.Fraction_Oxygen[n]), MathFP.toFP(100));
            this.Fraction_Helium[n] = MathFP.div(MathFP.toFP(this.gd.Fraction_Helium[n]), MathFP.toFP(100));
            this.Fraction_Nitrogen[n] = MathFP.div(MathFP.toFP(this.gd.Fraction_Nitrogen[n]), MathFP.toFP(100));
        }
        this.Critical_Radius_N2 = MathFP.mul(MathFP.mul(this.sd.Critical_Radius_N2_Microns, 0x1000000L + MathFP.div(MathFP.toFP(this.sd.Conservativity_Percent), MathFP.toFP(100))), MathFP.toFP("0.01"));
        this.Critical_Radius_He = MathFP.mul(MathFP.mul(this.sd.Critical_Radius_He_Microns, 0x1000000L + MathFP.div(MathFP.toFP(this.sd.Conservativity_Percent), MathFP.toFP(100))), MathFP.toFP("0.01"));
        for (n = 0; n < 16; ++n) {
            this.Max_Crushing_Pressure_N2[n] = 0L;
            this.Max_Crushing_Pressure_He[n] = 0L;
            this.Max_Actual_Gradient[n] = 0L;
            this.Surface_Phase_Volume_Time[n] = 0L;
            this.Amb_Pressure_Onset_of_Imperm[n] = 0L;
            this.Gas_Tension_Onset_of_Imperm[n] = 0L;
            this.Initial_Critical_Radius_N2[n] = this.Critical_Radius_N2;
            this.Initial_Critical_Radius_He[n] = this.Critical_Radius_He;
            this.Adjusted_Critical_Radius_N2[n] = this.Initial_Critical_Radius_N2[n];
            this.Adjusted_Critical_Radius_He[n] = this.Initial_Critical_Radius_He[n];
            this.Regenerated_Radius_He[n] = 0L;
            this.Regenerated_Radius_N2[n] = 0L;
            this.Adjusted_Crushing_Pressure_He[n] = 0L;
            this.Adjusted_Crushing_Pressure_N2[n] = 0L;
            this.Helium_Pressure[n] = 0L;
            this.Nitrogen_Pressure[n] = MathFP.mul(this.Barometric_Pressure - this.Water_Vapor_Pressure, MathFP.toFP("0.79"));
        }
        this.Constant_Pressure_Other_Gases = MathFP.mul(MathFP.div(this.sd.Pressure_Other_Gases_mmHg, MathFP.toFP(760)), this.Units_Factor);
        this.diveCNS = 0L;
        this.diveOTU = 0L;
        this.diveseriesOTU = 0L;
    }

    public void run() {
        this.running = true;
        this.doCalc();
        while (this.running) {
            try {
                CalculateDiveSeriesVPMB.sleep(1000L);
            }
            catch (Throwable throwable) {}
        }
    }

    public void stopIt() {
        this.Nitrogen_Time_Constant = null;
        this.Helium_Time_Constant = null;
        this.PPO2axis = null;
        this.CNSvalues = null;
        this.OTUvalues = null;
        this.Max_Crushing_Pressure_N2 = null;
        this.Max_Crushing_Pressure_He = null;
        this.Max_Actual_Gradient = null;
        this.Surface_Phase_Volume_Time = null;
        this.Amb_Pressure_Onset_of_Imperm = null;
        this.Gas_Tension_Onset_of_Imperm = null;
        this.Initial_Critical_Radius_N2 = null;
        this.Initial_Critical_Radius_He = null;
        this.Regenerated_Radius_He = null;
        this.Regenerated_Radius_N2 = null;
        this.Adjusted_Crushing_Pressure_He = null;
        this.Adjusted_Crushing_Pressure_N2 = null;
        this.Adjusted_Critical_Radius_N2 = null;
        this.Adjusted_Critical_Radius_He = null;
        this.Helium_Pressure = null;
        this.Nitrogen_Pressure = null;
        this.Fraction_Oxygen = null;
        this.Fraction_Helium = null;
        this.Fraction_Nitrogen = null;
        this.Running_Gas_Volume = null;
        this.Initial_Helium_Pressure = null;
        this.Initial_Nitrogen_Pressure = null;
        this.Max_Crushing_Pressure_He = null;
        this.Max_Crushing_Pressure_N2 = null;
        this.Allowable_Gradient_He = null;
        this.Allowable_Gradient_N2 = null;
        this.Initial_Allowable_Gradient_He = null;
        this.Initial_Allowable_Gradient_N2 = null;
        this.Deco_Gradient_He = null;
        this.Deco_Gradient_N2 = null;
        this.Surface_Phase_Volume_Time = null;
        this.jd = null;
        this.sd = null;
        this.gd = null;
        this.dd = null;
        this.ui = null;
        this.running = false;
    }

    private void doCalc() {
        this.calculationReady = false;
        this.Rate_Ascent = MathFP.toFP(this.sd.Rate_Ascent);
        this.Rate_Descent = MathFP.toFP(this.sd.Rate_Descent);
        this.Number_of_Dives = 0;
        while (this.dd.Dive_Profile[this.Number_of_Dives][0][0] != 9999L) {
            ++this.Number_of_Dives;
        }
        this.Number_Mixes = 0;
        while (this.gd.Fraction_Oxygen[this.Number_Mixes] != 9999L) {
            ++this.Number_Mixes;
        }
        this.doCCRbailoutFlag = false;
        this.Dive_Number = 0;
        while (this.Dive_Number < this.Number_of_Dives) {
            int n;
            this.Run_Time = 0L;
            this.diveOTU = 0L;
            for (n = 0; n < this.Number_Mixes; ++n) {
                this.Running_Gas_Volume[n] = 0L;
            }
            this.Depth_Last_Segment = 0L;
            this.Row_Dive_Data = 0;
            while (this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][0] != 999L) {
                this.Depth_Segment = MathFP.toFP(this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][0]);
                this.Time_Segment = MathFP.toFP(this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][1]);
                this.Mix_Number = (int)this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][2];
                this.PPO2Set_Segment = MathFP.mul(this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][3], this.Units_Factor);
                this.Time_Depth_Change = MathFP.toFP(0);
                if (this.Depth_Last_Segment > this.Depth_Segment) {
                    this.Depth_Start_of_Deco_Zone = this.CALC_START_OF_DECO_ZONE(this.Depth_Last_Segment, -this.Rate_Ascent, this.Mix_Number, this.PPO2Set_Segment);
                    if (this.Depth_Start_of_Deco_Zone > this.Depth_Segment) {
                        this.ui.computationError = "Dive level " + Integer.toString(this.Row_Dive_Data + 1) + " of dive " + Integer.toString(this.Dive_Number + 1) + " violates decompression ceiling!";
                        this.calculationReady = true;
                        return;
                    }
                }
                this.Rate = this.Rate_Descent;
                if (this.Depth_Segment < this.Depth_Last_Segment) {
                    this.Rate = -this.Rate_Ascent;
                }
                this.Time_Depth_Change = MathFP.abs(MathFP.div(this.Depth_Segment - this.Depth_Last_Segment, this.Rate));
                if (this.Row_Dive_Data == 0) {
                    this.ui.RunTimeInitialDescent = this.Time_Depth_Change;
                }
                this.GAS_LOADINGS_ASCENT_DESCENT(this.Depth_Last_Segment, this.Depth_Segment, this.Mix_Number, this.Rate, this.Time_Depth_Change, this.PPO2Set_Segment);
                this.DIVEDATA_GAS_VOLUME_OTU_CNS_OTU_CNS(this.Depth_Last_Segment, this.Depth_Segment, this.Time_Depth_Change, this.sd.RMV_During_Dive, this.Mix_Number, this.PPO2Set_Segment);
                if (this.Depth_Segment > this.Depth_Last_Segment) {
                    this.errorFlag = this.CALC_CRUSHING_PRESSURE(this.Depth_Last_Segment, this.Depth_Segment, this.Rate, this.Mix_Number);
                }
                if (this.errorFlag == 999) {
                    this.ui.computationError = "Problems calculating crushing pressure. Check the settings!";
                    this.calculationReady = true;
                    return;
                }
                this.Time_Depth_Constant = this.Time_Segment - this.Time_Depth_Change;
                if (this.Time_Depth_Constant <= 0L) {
                    this.ui.computationError = "Rate for depth change to small. Check the settings!";
                    this.calculationReady = true;
                    return;
                }
                this.PPO2_Corrected = this.sd.JDeco_Type == 1 ? this.CORRECT_PPO2(this.Depth_Segment, this.Mix_Number, this.PPO2Set_Segment) : this.PPO2Set_Segment;
                this.GAS_LOADINGS_CONSTANT_DEPTH(this.Depth_Segment, this.Mix_Number, this.Time_Depth_Constant, this.PPO2_Corrected);
                this.DIVEDATA_GAS_VOLUME_OTU_CNS_OTU_CNS(this.Depth_Segment, this.Depth_Segment, this.Time_Depth_Constant, this.sd.RMV_During_Dive, this.Mix_Number, this.PPO2_Corrected);
                this.Run_Time += this.Time_Segment;
                if (this.Dive_Number == this.Number_of_Dives - 1) {
                    this.ui.Segment_Depth_Last_Dive[this.index_result] = MathFP.toLong(this.Depth_Segment);
                    this.ui.Segment_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Time_Segment);
                    this.ui.Segment_Mix_Last_Dive[this.index_result] = this.Mix_Number;
                    this.ui.Segment_PPO2_Last_Dive[this.index_result] = MathFP.div(this.PPO2_Corrected, this.Units_Factor);
                    this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = 0L;
                    this.ui.Run_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Run_Time);
                    ++this.index_result;
                }
                this.Depth_Last_Segment = this.Depth_Segment;
                ++this.Row_Dive_Data;
            }
            this.lastAscentFlag = true;
            if (this.sd.JDeco_Type == 1 && this.ui.bailoutCCRFlag && this.Dive_Number == this.Number_of_Dives - 1) {
                this.doCCRbailoutFlag = true;
            }
            if (this.sd.JDeco_Type == 1) {
                if (!this.doCCRbailoutFlag) {
                    n = 0;
                    this.test_max = -MathFP.toFP(1000);
                    while (this.dd.CCR_Deco_Settings[this.Dive_Number][n][0] != 999L) {
                        this.test = MathFP.sub(this.Depth_Segment, MathFP.toFP(this.dd.CCR_Deco_Settings[this.Dive_Number][n][0]));
                        if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                            this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                            break;
                        }
                        if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                            this.test_max = this.test;
                            this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                        }
                        ++n;
                    }
                } else {
                    n = 0;
                    this.test_max = -MathFP.toFP(1000);
                    while (this.dd.Deco_Settings[this.Dive_Number][n][0] != 999L) {
                        this.test = MathFP.sub(this.Depth_Segment, MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][n][0]));
                        if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                            this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = 0L;
                            break;
                        }
                        if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                            this.test_max = this.test;
                            this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = 0L;
                        }
                        ++n;
                    }
                }
            }
            this.DO_DECOMPRESSION(this.Depth_Last_Segment, 0L);
            this.ui.Complete_Runtime = MathFP.toLong(MathFP.ceil(this.Run_Time));
            for (n = 0; n < this.Number_Mixes; ++n) {
                this.ui.Needed_Gas_Last_Dive[n] = MathFP.toLong(MathFP.ceil(this.Running_Gas_Volume[n]));
            }
            this.ui.Needed_Gas_Last_Dive[this.Number_Mixes] = 9999L;
            this.diveseriesOTU += this.diveOTU;
            if (this.Dive_Number < this.Number_of_Dives - 1) {
                this.Surface_Interval_Time = MathFP.toFP(this.dd.Surface_Interval[this.Dive_Number]);
                this.GAS_LOADINGS_CNS_SURFACE_INTERVAL(this.Surface_Interval_Time);
                this.VPM_REPETITIVE_ALGORITHM(this.Surface_Interval_Time);
                for (n = 0; n < 16; ++n) {
                    this.Max_Crushing_Pressure_He[n] = 0L;
                    this.Max_Crushing_Pressure_N2[n] = 0L;
                    this.Max_Actual_Gradient[n] = 0L;
                }
            }
            ++this.Dive_Number;
        }
        this.ui.Segment_Depth_Last_Dive[this.index_result] = 9999L;
        this.ui.Segment_Time_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_Mix_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_PPO2_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = 0L;
        this.ui.Run_Time_Last_Dive[this.index_result] = 0L;
        ++this.index_result;
        this.deepestStop = MathFP.toLong(this.Deepest_Possible_Stop_Depth);
        if (this.deepestStop < 0L) {
            this.deepestStop = 0L;
        }
        this.ui.Segment_Depth_Last_Dive[this.index_result] = this.deepestStop;
        this.ui.Segment_Time_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_Mix_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = 0L;
        this.ui.Run_Time_Last_Dive[this.index_result] = 0L;
        this.ui.diveCNS = MathFP.ceil(this.diveCNS);
        this.ui.diveOTU = MathFP.ceil(this.diveOTU);
        this.ui.diveseriesOTU = MathFP.ceil(this.diveseriesOTU);
        this.calculationReady = true;
    }

    private void DO_DECOMPRESSION(long l, long l2) {
        int n;
        this.NUCLEAR_REGENERATION(this.Run_Time);
        this.CALC_INITIAL_ALLOWABLE_GRADIENT();
        for (n = 0; n < 16; ++n) {
            this.He_Pressure_Start_of_Ascent[n] = this.Helium_Pressure[n];
            this.N2_Pressure_Start_of_Ascent[n] = this.Nitrogen_Pressure[n];
        }
        this.Run_Time_Start_of_Ascent = this.Run_Time;
        this.Starting_Depth = l;
        this.Mix_Last_Segment = this.Mix_Number;
        this.Rate = -this.Rate_Ascent;
        this.Step_Size = MathFP.toFP(this.sd.Deco_Stop_Step_Size);
        this.Depth_Start_of_Deco_Zone = this.CALC_START_OF_DECO_ZONE(this.Starting_Depth, this.Rate, this.Mix_Number, this.PPO2Set_Segment);
        if (this.Depth_Start_of_Deco_Zone == 99999L) {
            this.Depth_Start_of_Deco_Zone = l;
        }
        if (this.Depth_Start_of_Deco_Zone == 99998L) {
            this.ui.computationError = "Root search exceeded maximum iterations.";
            this.calculationReady = true;
            return;
        }
        this.Deepest_Possible_Stop_Depth = MathFP.mul(MathFP.floor(MathFP.div(this.Depth_Start_of_Deco_Zone, this.Step_Size)), this.Step_Size);
        this.Time_Depth_Change = MathFP.abs(MathFP.div(this.Depth_Start_of_Deco_Zone - this.Starting_Depth, this.Rate));
        this.GAS_LOADINGS_ASCENT_DESCENT(this.Starting_Depth, this.Depth_Start_of_Deco_Zone, this.Mix_Number, this.Rate, this.Time_Depth_Change, this.PPO2Set_Segment);
        this.DIVEDATA_GAS_VOLUME_OTU_CNS_OTU_CNS(this.Starting_Depth, this.Depth_Start_of_Deco_Zone, this.Time_Depth_Change, this.sd.RMV_During_Deco, this.Mix_Number, this.PPO2Set_Segment);
        this.Run_Time += this.Time_Depth_Change;
        this.Run_Time_Start_of_Deco_Zone = this.Run_Time;
        this.Deco_Phase_Volume_Time = 0L;
        this.Schedule_Converged = false;
        for (n = 0; n < 16; ++n) {
            this.Last_Phase_Volume_Time[n] = 0L;
            this.He_Pressure_Start_of_Deco_Zone[n] = this.Helium_Pressure[n];
            this.N2_Pressure_Start_of_Deco_Zone[n] = this.Nitrogen_Pressure[n];
            this.Max_Actual_Gradient[n] = 0L;
        }
        for (n = 0; n < this.Number_Mixes; ++n) {
            this.Running_Gas_Volume_Start_of_Deco_Zone[n] = this.Running_Gas_Volume[n];
        }
        for (n = 0; n < 16; ++n) {
            this.Max_Actual_Gradient_Backup[n] = this.Max_Actual_Gradient[n];
        }
        this.diveCNS_Backup = this.diveCNS;
        this.diveOTU_Backup = this.diveOTU;
        this.diveseriesOTU_Backup = this.diveseriesOTU;
        this.index_result_backup = this.index_result;
        this.PPO2Set_Segment_backup = this.PPO2Set_Segment;
        while (true) {
            this.Ascent_Ceiling_Depth = this.CALC_ASCENT_CEILING();
            this.Deco_Stop_Depth = this.Ascent_Ceiling_Depth <= 0L ? 0L : MathFP.mul(MathFP.ceil(MathFP.div(this.Ascent_Ceiling_Depth, this.Step_Size)), this.Step_Size);
            this.Deco_Stop_Depth = this.PROJECTED_ASCENT(this.Depth_Start_of_Deco_Zone, this.Rate, this.Deco_Stop_Depth, this.Step_Size, this.Mix_Number, this.PPO2Set_Segment);
            if (this.Deco_Stop_Depth > this.Depth_Start_of_Deco_Zone) {
                this.ui.computationError = "Step-size is too large to decompress. Check the settings!";
                this.calculationReady = true;
                return;
            }
            if (this.Deco_Stop_Depth <= 0L) {
                for (n = 0; n < 16; ++n) {
                    this.Helium_Pressure[n] = this.He_Pressure_Start_of_Ascent[n];
                    this.Nitrogen_Pressure[n] = this.N2_Pressure_Start_of_Ascent[n];
                }
                this.Run_Time = this.Run_Time_Start_of_Ascent;
                this.Starting_Depth = this.Depth_Last_Segment;
                this.Ending_Depth = 0L;
                this.Time_Depth_Change = MathFP.abs(MathFP.div(this.Ending_Depth - this.Starting_Depth, this.Rate));
                this.GAS_LOADINGS_ASCENT_DESCENT(this.Starting_Depth, this.Ending_Depth, this.Mix_Number, this.Rate, this.Time_Depth_Change, this.PPO2Set_Segment);
                this.DIVEDATA_GAS_VOLUME_OTU_CNS_OTU_CNS(this.Starting_Depth, this.Ending_Depth, this.Time_Depth_Change, this.sd.RMV_During_Deco, this.Mix_Number, this.PPO2Set_Segment);
                this.Run_Time += this.Time_Depth_Change;
                if (this.Dive_Number != this.Number_of_Dives - 1) break;
                this.ui.computationError = "Ascent directly to surface!";
                this.ui.directAscentMessage = true;
                this.calculationReady = true;
                return;
            }
            this.Starting_Depth = this.Depth_Start_of_Deco_Zone;
            this.First_Stop_Depth = this.Deco_Stop_Depth;
            if (this.Deco_Stop_Depth > MathFP.toFP(this.sd.Last_Deco_Stop_Depth)) {
                this.Rate = -this.Rate_Ascent;
            }
            for (n = 0; n < 16; ++n) {
                this.Max_Actual_Gradient[n] = this.Max_Actual_Gradient_Backup[n];
            }
            while (true) {
                this.Time_Depth_Change = MathFP.abs(MathFP.div(this.Deco_Stop_Depth - this.Starting_Depth, this.Rate));
                this.GAS_LOADINGS_ASCENT_DESCENT(this.Starting_Depth, this.Deco_Stop_Depth, this.Mix_Number, this.Rate, this.Time_Depth_Change, this.PPO2Set_Segment);
                this.DIVEDATA_GAS_VOLUME_OTU_CNS_OTU_CNS(this.Starting_Depth, this.Deco_Stop_Depth, this.Time_Depth_Change, this.sd.RMV_During_Deco, this.Mix_Number, this.PPO2Set_Segment);
                this.Run_Time += this.Time_Depth_Change;
                this.CALC_MAX_ACTUAL_GRADIENT(this.Deco_Stop_Depth);
                if (this.Deco_Stop_Depth <= l2) break;
                if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
                    n = 0;
                    this.test_max = -MathFP.toFP(1000);
                    int n2 = this.Mix_Number;
                    while (this.dd.Deco_Settings[this.Dive_Number][n][0] != 999L) {
                        this.test = MathFP.sub(this.Deco_Stop_Depth, MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][n][0]));
                        if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                            this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                            this.used_deco_gas_index = n;
                            break;
                        }
                        if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                            this.test_max = this.test;
                            this.used_deco_gas_index = n;
                            this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                        }
                        ++n;
                    }
                    if (this.sd.JDeco_Type == 0) {
                        if (this.ui.bailoutFlag && this.Dive_Number == this.Number_of_Dives - 1 && n2 != this.Mix_Number && this.Mix_Number == this.ui.bailoutGasLoss) {
                            this.Mix_Number = n2;
                        }
                        this.addExtraDecoSwitchTime = false;
                        if (n2 != this.Mix_Number) {
                            this.addExtraDecoSwitchTime = true;
                        }
                    } else {
                        this.PPO2Set_Segment = 0L;
                    }
                } else {
                    n = 0;
                    this.test_max = -MathFP.toFP(1000);
                    while (this.dd.CCR_Deco_Settings[this.Dive_Number][n][0] != 999L) {
                        this.test = MathFP.sub(this.Deco_Stop_Depth, MathFP.toFP(this.dd.CCR_Deco_Settings[this.Dive_Number][n][0]));
                        if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                            this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                            this.used_deco_gas_index = n;
                            break;
                        }
                        if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                            this.test_max = this.test;
                            this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                            this.used_deco_gas_index = n;
                            this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                        }
                        ++n;
                    }
                }
                if (this.Deco_Stop_Depth <= MathFP.toFP(this.sd.Last_Deco_Stop_Depth)) {
                    this.Step_Size = this.Deco_Stop_Depth;
                    this.Rate = -this.Deco_Stop_Depth;
                } else {
                    this.Step_Size = MathFP.toFP(this.sd.Deco_Stop_Step_Size);
                    this.Rate = -this.Rate_Ascent;
                }
                this.BOYLES_LAW_COMPENSATION(this.First_Stop_Depth, this.Deco_Stop_Depth, this.Step_Size);
                this.Segment_Time_Start = MathFP.sub(MathFP.mul(MathFP.ceil(MathFP.div(this.Run_Time, MathFP.toFP(this.sd.Minimum_Deco_Stop_Time))), MathFP.toFP(this.sd.Minimum_Deco_Stop_Time)), this.Run_Time);
                this.PPO2_Corrected = this.sd.JDeco_Type == 1 ? this.CORRECT_PPO2(this.Deco_Stop_Depth, this.Mix_Number, this.PPO2Set_Segment) : this.PPO2Set_Segment;
                this.Segment_Time = this.DECOMPRESSION_STOP(this.Deco_Stop_Depth, this.Step_Size, this.Segment_Time_Start, this.Mix_Number, this.PPO2_Corrected);
                if (this.Segment_Time == 99999L) {
                    this.ui.computationError = "Decompression Time to long!";
                    this.calculationReady = true;
                    return;
                }
                if (this.sd.JDeco_Type == 0 && this.addExtraDecoSwitchTime) {
                    this.GAS_LOADINGS_CONSTANT_DEPTH(this.Deco_Stop_Depth, this.Mix_Number, MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][this.used_deco_gas_index][2]), this.PPO2_Corrected);
                    this.Segment_Time += MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][this.used_deco_gas_index][2]);
                }
                this.DIVEDATA_GAS_VOLUME_OTU_CNS_OTU_CNS(this.Deco_Stop_Depth, this.Deco_Stop_Depth, this.Segment_Time, this.sd.RMV_During_Deco, this.Mix_Number, this.PPO2_Corrected);
                this.Run_Time += this.Segment_Time;
                this.Deco_Stop_Time = MathFP.mul(MathFP.ceil(MathFP.div(this.Segment_Time, MathFP.toFP(this.sd.Minimum_Deco_Stop_Time))), MathFP.toFP(this.sd.Minimum_Deco_Stop_Time));
                if (this.Dive_Number == this.Number_of_Dives - 1) {
                    this.ui.Segment_Depth_Last_Dive[this.index_result] = MathFP.toLong(this.Deco_Stop_Depth);
                    this.ui.Segment_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Deco_Stop_Time);
                    this.ui.Segment_Mix_Last_Dive[this.index_result] = this.Mix_Number;
                    this.ui.Segment_PPO2_Last_Dive[this.index_result] = MathFP.div(this.PPO2_Corrected, this.Units_Factor);
                    this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = this.lastAscentFlag ? 1L : 0L;
                    this.ui.Run_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Run_Time);
                    ++this.index_result;
                }
                this.Starting_Depth = this.Deco_Stop_Depth;
                this.Deco_Stop_Depth = this.Next_Stop = this.Deco_Stop_Depth - this.Step_Size;
            }
            this.Deco_Phase_Volume_Time = this.Run_Time - this.Run_Time_Start_of_Deco_Zone;
            this.CALC_SURFACE_PHASE_VOLUME_TIME();
            for (n = 0; n < 16; ++n) {
                this.Phase_Volume_Time[n] = this.Deco_Phase_Volume_Time + this.Surface_Phase_Volume_Time[n];
                this.Critical_Volume_Comparison = MathFP.abs(this.Phase_Volume_Time[n] - this.Last_Phase_Volume_Time[n]);
                if (this.Critical_Volume_Comparison > 0x1000000L) continue;
                this.Schedule_Converged = true;
            }
            if (this.Schedule_Converged || !this.sd.Critical_Volume_Algorithm) break;
            this.CRITICAL_VOLUME(this.Deco_Phase_Volume_Time);
            this.Deco_Phase_Volume_Time = 0L;
            this.Run_Time = this.Run_Time_Start_of_Deco_Zone;
            this.Mix_Number = this.Mix_Last_Segment;
            for (n = 0; n < 16; ++n) {
                this.Last_Phase_Volume_Time[n] = this.Phase_Volume_Time[n];
                this.Helium_Pressure[n] = this.He_Pressure_Start_of_Deco_Zone[n];
                this.Nitrogen_Pressure[n] = this.N2_Pressure_Start_of_Deco_Zone[n];
            }
            for (n = 0; n < this.Number_Mixes; ++n) {
                this.Running_Gas_Volume[n] = this.Running_Gas_Volume_Start_of_Deco_Zone[n];
            }
            this.index_result = this.index_result_backup;
            this.diveCNS = this.diveCNS_Backup;
            this.diveOTU = this.diveOTU_Backup;
            this.diveseriesOTU = this.diveseriesOTU_Backup;
            this.PPO2Set_Segment = this.PPO2Set_Segment_backup;
        }
    }

    private void GAS_LOADINGS_ASCENT_DESCENT(long l, long l2, int n, long l3, long l4, long l5) {
        long l6;
        long l7;
        long l8;
        long l9;
        long l10 = MathFP.add(l, this.Barometric_Pressure);
        long l11 = this.Fraction_Helium[n];
        long l12 = this.Fraction_Nitrogen[n];
        long l13 = l12 + l11;
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            l9 = MathFP.mul(MathFP.sub(l10, this.Water_Vapor_Pressure), l11);
            l8 = MathFP.mul(MathFP.sub(l10, this.Water_Vapor_Pressure), l12);
            l7 = MathFP.mul(l3, l11);
            l6 = MathFP.mul(l3, l12);
        } else {
            l9 = MathFP.mul(l10 - this.Water_Vapor_Pressure - l5, MathFP.div(l11, l13));
            l8 = MathFP.mul(l10 - this.Water_Vapor_Pressure - l5, MathFP.div(l12, l13));
            l7 = MathFP.mul(l3, MathFP.div(l11, l13));
            l6 = MathFP.mul(l3, MathFP.div(l12, l13));
        }
        for (int i = 0; i < 16; ++i) {
            this.Helium_Pressure[i] = this.SCHREINER_EQUATION(l9, l7, l4, this.Helium_Time_Constant[i], this.Helium_Pressure[i]);
            this.Nitrogen_Pressure[i] = this.SCHREINER_EQUATION(l8, l6, l4, this.Nitrogen_Time_Constant[i], this.Nitrogen_Pressure[i]);
        }
    }

    private long SCHREINER_EQUATION(long l, long l2, long l3, long l4, long l5) {
        return MathFP.mul(0x1000000L - MathFP.exp(-MathFP.mul(l4, l3)), l - MathFP.div(l2, l4) - l5) + MathFP.mul(l2, l3) + l5;
    }

    private void GAS_LOADINGS_CONSTANT_DEPTH(long l, int n, long l2, long l3) {
        long l4 = MathFP.add(l, this.Barometric_Pressure);
        long l5 = this.Fraction_Helium[n];
        long l6 = this.Fraction_Nitrogen[n];
        if (this.sd.JDeco_Type == 1 && !this.doCCRbailoutFlag) {
            long l7 = MathFP.div(l3, l4);
            long l8 = l5 + l6;
            l5 = MathFP.mul(0x1000000L - l7, MathFP.div(l5, l8));
            l6 = MathFP.mul(0x1000000L - l7, MathFP.div(l6, l8));
        }
        long l9 = MathFP.mul(MathFP.sub(l4, this.Water_Vapor_Pressure), l5);
        long l10 = MathFP.mul(MathFP.sub(l4, this.Water_Vapor_Pressure), l6);
        for (int i = 0; i < 16; ++i) {
            this.Helium_Pressure[i] = this.HALDANE_EQUATION(this.Helium_Pressure[i], l9, this.Helium_Time_Constant[i], l2);
            this.Nitrogen_Pressure[i] = this.HALDANE_EQUATION(this.Nitrogen_Pressure[i], l10, this.Nitrogen_Time_Constant[i], l2);
        }
    }

    private long HALDANE_EQUATION(long l, long l2, long l3, long l4) {
        long l5 = l2 - l;
        long l6 = 0x1000000L - MathFP.exp(-MathFP.mul(l3, l4));
        long l7 = l + MathFP.mul(l5, l6);
        return l7;
    }

    private void DIVEDATA_GAS_VOLUME_OTU_CNS_OTU_CNS(long l, long l2, long l3, long l4, int n, long l5) {
        long l6;
        long l7 = MathFP.div(MathFP.add(MathFP.div(MathFP.add(l, l2), MathFP.toFP(2)), this.Barometric_Pressure), this.Units_Factor);
        long l8 = MathFP.mul(MathFP.mul(l4, l3), l7);
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            this.Running_Gas_Volume[n] = MathFP.add(this.Running_Gas_Volume[n], l8);
        }
        if ((l6 = this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag ? MathFP.mul(this.Fraction_Oxygen[n], l7) : MathFP.div(l5, this.Units_Factor)) == this.PPO2axis[1]) {
            this.diveCNS += MathFP.mul(this.CNSvalues[1], l3);
            this.diveOTU += MathFP.mul(this.OTUvalues[1], l3);
        } else if (l6 >= this.PPO2axis[this.PPO2axis.length - 1]) {
            this.diveCNS += MathFP.mul(this.CNSvalues[this.PPO2axis.length - 1], l3);
            this.diveOTU += MathFP.mul(this.OTUvalues[this.PPO2axis.length - 1], l3);
        } else if (l6 > this.PPO2axis[1] && l6 < this.PPO2axis[this.PPO2axis.length - 1]) {
            for (int i = 2; i < this.PPO2axis.length; ++i) {
                if (l6 > this.PPO2axis[i]) continue;
                long l9 = MathFP.div(this.CNSvalues[i] - this.CNSvalues[i - 1], this.PPO2axis[i] - this.PPO2axis[i - 1]);
                long l10 = this.CNSvalues[i] - MathFP.mul(l9, this.PPO2axis[i]);
                long l11 = MathFP.div(this.OTUvalues[i] - this.OTUvalues[i - 1], this.PPO2axis[i] - this.PPO2axis[i - 1]);
                long l12 = this.OTUvalues[i] - MathFP.mul(l11, this.PPO2axis[i]);
                long l13 = MathFP.mul(l9, l6) + l10;
                long l14 = MathFP.mul(l11, l6) + l12;
                this.diveCNS += MathFP.mul(l13, l3);
                this.diveOTU += MathFP.mul(l14, l3);
                break;
            }
        }
    }

    private int CALC_CRUSHING_PRESSURE(long l, long l2, long l3, int n) {
        long l4 = 0L;
        long l5 = 0L;
        long l6 = MathFP.mul(this.sd.Gradient_Onset_of_Imperm_Atm, this.Units_Factor);
        long l7 = MathFP.mul(this.sd.Gradient_Onset_of_Imperm_Atm, MathFP.toFP(101325));
        long l8 = l + this.Barometric_Pressure;
        long l9 = l2 + this.Barometric_Pressure;
        for (int i = 0; i < 16; ++i) {
            long l10 = this.Initial_Helium_Pressure[i] + this.Initial_Nitrogen_Pressure[i] + this.Constant_Pressure_Other_Gases;
            long l11 = l8 - l10;
            long l12 = this.Helium_Pressure[i] + this.Nitrogen_Pressure[i] + this.Constant_Pressure_Other_Gases;
            long l13 = l9 - l12;
            long l14 = MathFP.div(this.FACTOR_RADIUS, MathFP.div(l7, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma << 1) + MathFP.div(this.FACTOR_RADIUS, this.Adjusted_Critical_Radius_He[i]));
            long l15 = MathFP.div(this.FACTOR_RADIUS, MathFP.div(l7, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma << 1) + MathFP.div(this.FACTOR_RADIUS, this.Adjusted_Critical_Radius_N2[i]));
            if (l13 < l6) {
                l4 = l9 - l12;
                l5 = l9 - l12;
            }
            if (l13 > l6) {
                int n2;
                if (l11 == l6) {
                    this.Amb_Pressure_Onset_of_Imperm[i] = l8;
                    this.Gas_Tension_Onset_of_Imperm[i] = l10;
                }
                if (l11 < l6 && (n2 = this.ONSET_OF_IMPERMEABILITY(l8, l9, l3, i, n)) == 999) {
                    return 999;
                }
                long l16 = MathFP.mul(MathFP.div(l9, this.Units_Factor), MathFP.toFP(101325));
                long l17 = MathFP.mul(MathFP.div(this.Amb_Pressure_Onset_of_Imperm[i], this.Units_Factor), MathFP.toFP(101325));
                long l18 = MathFP.mul(MathFP.div(this.Gas_Tension_Onset_of_Imperm[i], this.Units_Factor), MathFP.toFP(101325));
                long l19 = MathFP.mul(MathFP.mul(MathFP.toFP(2), this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma), this.FACTOR_RADIUS);
                long l20 = l16 - l17 + l18 + MathFP.div(MathFP.mul(this.FACTOR_RADIUS, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma << 1), l14);
                long l21 = MathFP.mul(MathFP.mul(MathFP.mul(l18, l14), l14), l14);
                long l22 = l14;
                long l23 = MathFP.div(l19, l20);
                long l24 = this.RADIUS_ROOT_FINDER(l20, l19, l21, l23, l22);
                if (l24 == 999L) {
                    return 999;
                }
                long l25 = l7 + l16 - l17 + MathFP.mul(l18, 0x1000000L - MathFP.pow3(MathFP.div(l14, l24)));
                l4 = MathFP.mul(MathFP.div(l25, MathFP.toFP(101325)), this.Units_Factor);
                long l26 = l19;
                long l27 = l16 - l17 + l18 + MathFP.div(MathFP.mul(this.FACTOR_RADIUS, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma << 1), l15);
                long l28 = MathFP.mul(MathFP.mul(MathFP.mul(l18, l15), l15), l15);
                long l29 = l15;
                long l30 = MathFP.div(l26, l27);
                long l31 = this.RADIUS_ROOT_FINDER(l27, l26, l28, l30, l29);
                if (l31 == 999L) {
                    return 999;
                }
                long l32 = l7 + l16 - l17 + MathFP.mul(l18, 0x1000000L - MathFP.pow3(MathFP.div(l15, l31)));
                l5 = MathFP.mul(MathFP.div(l32, MathFP.toFP(101325)), this.Units_Factor);
            }
            this.Max_Crushing_Pressure_He[i] = MathFP.max(this.Max_Crushing_Pressure_He[i], l4);
            this.Max_Crushing_Pressure_N2[i] = MathFP.max(this.Max_Crushing_Pressure_N2[i], l5);
        }
        return 0;
    }

    private int ONSET_OF_IMPERMEABILITY(long l, long l2, long l3, int n, int n2) {
        int n3;
        long l4;
        long l5;
        long l6;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = MathFP.mul(this.sd.Gradient_Onset_of_Imperm_Atm, this.Units_Factor);
        long l10 = MathFP.mul(l - this.Water_Vapor_Pressure, this.Fraction_Helium[n2]);
        long l11 = MathFP.mul(l - this.Water_Vapor_Pressure, this.Fraction_Nitrogen[n2]);
        long l12 = MathFP.mul(l3, this.Fraction_Helium[n2]);
        long l13 = MathFP.mul(l3, this.Fraction_Nitrogen[n2]);
        long l14 = 0L;
        long l15 = MathFP.div(l2 - l, l3);
        long l16 = this.Initial_Helium_Pressure[n] + this.Initial_Nitrogen_Pressure[n] + this.Constant_Pressure_Other_Gases;
        long l17 = l - l16 - l9;
        long l18 = this.SCHREINER_EQUATION(l10, l12, l15, this.Helium_Time_Constant[n], this.Initial_Helium_Pressure[n]);
        long l19 = l18 + (l6 = this.SCHREINER_EQUATION(l11, l13, l15, this.Nitrogen_Time_Constant[n], this.Initial_Nitrogen_Pressure[n])) + this.Constant_Pressure_Other_Gases;
        long l20 = l2 - l19 - l9;
        if (MathFP.mul(l20, l17) > 0L) {
            return 999;
        }
        if (l17 < 0L) {
            l5 = l14;
            l4 = l15 - l14;
        } else {
            l5 = l15;
            l4 = l14 - l15;
        }
        for (n3 = 0; n3 <= 100; ++n3) {
            long l21;
            long l22;
            long l23 = l4;
            long l24 = l5 + (l4 = l23 >> 1);
            l7 = l + MathFP.mul(l3, l24);
            long l25 = l7 - (l8 = (l22 = this.SCHREINER_EQUATION(l10, l12, l24, this.Helium_Time_Constant[n], this.Initial_Helium_Pressure[n])) + (l21 = this.SCHREINER_EQUATION(l11, l13, l24, this.Nitrogen_Time_Constant[n], this.Initial_Nitrogen_Pressure[n])) + this.Constant_Pressure_Other_Gases) - l9;
            if (l25 <= 0L) {
                l5 = l24;
            }
            if (MathFP.abs(l4) < MathFP.toFP("0.001") || l25 == 0L) break;
        }
        if (n3 == 100) {
            return 999;
        }
        this.Amb_Pressure_Onset_of_Imperm[n] = l7;
        this.Gas_Tension_Onset_of_Imperm[n] = l8;
        return 0;
    }

    private long RADIUS_ROOT_FINDER(long l, long l2, long l3, long l4, long l5) {
        long l6;
        long l7;
        long l8;
        long l9;
        long l10 = MathFP.mul(l4, MathFP.mul(l4, MathFP.mul(l, l4) - l2)) - l3;
        if (MathFP.mul(l10, l9 = MathFP.mul(l5, MathFP.mul(l5, MathFP.mul(l, l5) - l2)) - l3) > 0L) {
            return 999L;
        }
        if (l10 == 0L) {
            return l4;
        }
        if (l9 == 0L) {
            return l5;
        }
        if (l10 < 0L) {
            l8 = l4;
            l7 = l5;
        } else {
            l7 = l4;
            l8 = l5;
        }
        long l11 = MathFP.mul(MathFP.toFP("0.5"), l4 + l5);
        long l12 = l6 = MathFP.abs(l5 - l4);
        long l13 = MathFP.mul(l11, MathFP.mul(l11, MathFP.mul(l, l11) - l2)) - l3;
        long l14 = MathFP.mul(l11, MathFP.mul(MathFP.mul(l11, MathFP.toFP(3)), l) - MathFP.mul(MathFP.toFP(2), l2));
        for (int i = 0; i <= 100; ++i) {
            long l15 = MathFP.mul(MathFP.mul(l11 - l7, l14) - l13, MathFP.mul(l11 - l8, l14) - l13);
            if (l15 > 0L || MathFP.abs(l13 << 1) > MathFP.abs(MathFP.mul(l6, l14))) {
                l6 = l12;
                l12 = l7 - l8 >> 1;
                l11 = l8 + l12;
                if (l8 == l11) {
                    return l11;
                }
            } else {
                l6 = l12;
                long l16 = l11;
                l12 = MathFP.div(l13, l14);
                if (l16 == (l11 -= l12)) {
                    return l11;
                }
            }
            if (MathFP.abs(l12) < MathFP.toFP("0.00000001")) {
                return l11;
            }
            l13 = MathFP.mul(l11, MathFP.mul(l11, MathFP.mul(l, l11) - l2)) - l3;
            l14 = MathFP.mul(l11, MathFP.mul(MathFP.mul(l11, MathFP.toFP(3)), l) - MathFP.mul(MathFP.toFP(2), l2));
            if (l13 < 0L) {
                l8 = l11;
                continue;
            }
            l7 = l11;
        }
        return 999L;
    }

    private long CALC_START_OF_DECO_ZONE(long l, long l2, int n, long l3) {
        long l4;
        long l5;
        long l6;
        long l7;
        long l8 = 0L;
        long l9 = MathFP.add(l, this.Barometric_Pressure);
        long l10 = this.Fraction_Helium[n];
        long l11 = this.Fraction_Nitrogen[n];
        long l12 = l11 + l10;
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            l7 = MathFP.mul(MathFP.sub(l9, this.Water_Vapor_Pressure), l10);
            l6 = MathFP.mul(MathFP.sub(l9, this.Water_Vapor_Pressure), l11);
            l5 = MathFP.mul(l2, l10);
            l4 = MathFP.mul(l2, l11);
        } else {
            l7 = MathFP.mul(l9 - this.Water_Vapor_Pressure - l3, MathFP.div(l10, l12));
            l6 = MathFP.mul(l9 - this.Water_Vapor_Pressure - l3, MathFP.div(l11, l12));
            l5 = MathFP.mul(l2, MathFP.div(l10, l12));
            l4 = MathFP.mul(l2, MathFP.div(l11, l12));
        }
        long l13 = 0L;
        long l14 = -MathFP.div(l9, l2);
        long l15 = 0L;
        long l16 = 0L;
        for (int i = 0; i < 16; ++i) {
            int n2;
            long l17;
            long l18 = this.Helium_Pressure[i];
            long l19 = this.Nitrogen_Pressure[i];
            long l20 = l18 + l19 + this.Constant_Pressure_Other_Gases - l9;
            long l21 = this.SCHREINER_EQUATION(l7, l5, l14, this.Helium_Time_Constant[i], l18);
            long l22 = l21 + (l17 = this.SCHREINER_EQUATION(l6, l4, l14, this.Nitrogen_Time_Constant[i], l19)) + this.Constant_Pressure_Other_Gases;
            if (MathFP.mul(l22, l20) > 0L) {
                return 99999L;
            }
            if (l20 < 0L) {
                l15 = l13;
                l16 = l14 - l13;
            } else {
                l15 = l14;
                l16 = l13 - l14;
            }
            for (n2 = 0; n2 <= 100; ++n2) {
                long l23;
                long l24 = l16;
                long l25 = l15 + (l16 = l24 >> 1);
                long l26 = this.SCHREINER_EQUATION(l7, l5, l25, this.Helium_Time_Constant[i], l18);
                long l27 = l26 + (l23 = this.SCHREINER_EQUATION(l6, l4, l25, this.Nitrogen_Time_Constant[i], l19)) + this.Constant_Pressure_Other_Gases - (l9 + MathFP.mul(l2, l25));
                if (l27 <= 0L) {
                    l15 = l25;
                }
                if (MathFP.abs(l16) < MathFP.toFP("0.001") || l27 == 0L) break;
            }
            if (n2 == 100) {
                return 99998L;
            }
            long l28 = l9 + MathFP.mul(l2, l15) - this.Barometric_Pressure;
            l8 = MathFP.max(l8, l28);
        }
        return l8;
    }

    private void NUCLEAR_REGENERATION(long l) {
        for (int i = 0; i < 16; ++i) {
            long l2 = MathFP.mul(MathFP.div(this.Max_Crushing_Pressure_He[i], this.Units_Factor), MathFP.toFP(101325));
            long l3 = MathFP.mul(MathFP.div(this.Max_Crushing_Pressure_N2[i], this.Units_Factor), MathFP.toFP(101325));
            long l4 = MathFP.div(this.FACTOR_RADIUS, MathFP.div(l2, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma << 1) + MathFP.div(this.FACTOR_RADIUS, this.Adjusted_Critical_Radius_He[i]));
            long l5 = MathFP.div(this.FACTOR_RADIUS, MathFP.div(l3, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma << 1) + MathFP.div(this.FACTOR_RADIUS, this.Adjusted_Critical_Radius_N2[i]));
            this.Regenerated_Radius_He[i] = this.Adjusted_Critical_Radius_He[i] + MathFP.mul(l4 - this.Adjusted_Critical_Radius_He[i], MathFP.exp(-MathFP.div(l, this.sd.Regeneration_Time_Constant)));
            this.Regenerated_Radius_N2[i] = this.Adjusted_Critical_Radius_N2[i] + MathFP.mul(l5 - this.Adjusted_Critical_Radius_N2[i], MathFP.exp(-MathFP.div(l, this.sd.Regeneration_Time_Constant)));
            long l6 = MathFP.div(MathFP.mul(l4, this.Adjusted_Critical_Radius_He[i] - this.Regenerated_Radius_He[i]), MathFP.mul(this.Regenerated_Radius_He[i], this.Adjusted_Critical_Radius_He[i] - l4));
            long l7 = MathFP.div(MathFP.mul(l5, this.Adjusted_Critical_Radius_N2[i] - this.Regenerated_Radius_N2[i]), MathFP.mul(this.Regenerated_Radius_N2[i], this.Adjusted_Critical_Radius_N2[i] - l5));
            long l8 = MathFP.mul(l2, l6);
            long l9 = MathFP.mul(l3, l7);
            this.Adjusted_Crushing_Pressure_He[i] = MathFP.mul(MathFP.div(l8, MathFP.toFP(101325)), this.Units_Factor);
            this.Adjusted_Crushing_Pressure_N2[i] = MathFP.mul(MathFP.div(l9, MathFP.toFP(101325)), this.Units_Factor);
        }
    }

    private void CALC_INITIAL_ALLOWABLE_GRADIENT() {
        for (int i = 0; i < 16; ++i) {
            long l = MathFP.mul(this.FACTOR_RADIUS, MathFP.div(MathFP.mul(this.sd.Surface_Tension_Gamma << 1, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma), MathFP.mul(this.Regenerated_Radius_N2[i], this.sd.Skin_Compression_GammaC)));
            long l2 = MathFP.mul(this.FACTOR_RADIUS, MathFP.div(MathFP.mul(this.sd.Surface_Tension_Gamma << 1, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma), MathFP.mul(this.Regenerated_Radius_He[i], this.sd.Skin_Compression_GammaC)));
            this.Initial_Allowable_Gradient_N2[i] = MathFP.mul(MathFP.div(l, MathFP.toFP(101325)), this.Units_Factor);
            this.Initial_Allowable_Gradient_He[i] = MathFP.mul(MathFP.div(l2, MathFP.toFP(101325)), this.Units_Factor);
            this.Allowable_Gradient_He[i] = this.Initial_Allowable_Gradient_He[i];
            this.Allowable_Gradient_N2[i] = this.Initial_Allowable_Gradient_N2[i];
        }
    }

    private long CALC_ASCENT_CEILING() {
        int n;
        long[] lArray = new long[16];
        for (n = 0; n < 16; ++n) {
            long l;
            long l2;
            long l3 = this.Helium_Pressure[n] + this.Nitrogen_Pressure[n];
            if (l3 > 0L) {
                l2 = MathFP.div(MathFP.mul(this.Allowable_Gradient_He[n], this.Helium_Pressure[n]) + MathFP.mul(this.Allowable_Gradient_N2[n], this.Nitrogen_Pressure[n]), this.Helium_Pressure[n] + this.Nitrogen_Pressure[n]);
                l = l3 + this.Constant_Pressure_Other_Gases - l2;
            } else {
                l2 = MathFP.min(this.Allowable_Gradient_He[n], this.Allowable_Gradient_N2[n]);
                l = this.Constant_Pressure_Other_Gases - l2;
            }
            if (l < 0L) {
                l = 0L;
            }
            lArray[n] = l - this.Barometric_Pressure;
        }
        long l = lArray[0];
        for (n = 1; n < 16; ++n) {
            l = MathFP.max(l, lArray[n]);
        }
        return l;
    }

    private long PROJECTED_ASCENT(long l, long l2, long l3, long l4, int n, long l5) {
        int n2;
        long l6;
        long l7;
        long l8;
        long l9;
        long[] lArray = new long[16];
        long[] lArray2 = new long[16];
        long[] lArray3 = new long[16];
        long[] lArray4 = new long[16];
        long l10 = MathFP.add(l3, this.Barometric_Pressure);
        long l11 = MathFP.add(l, this.Barometric_Pressure);
        long l12 = this.Fraction_Helium[n];
        long l13 = this.Fraction_Nitrogen[n];
        long l14 = l13 + l12;
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            l9 = MathFP.mul(MathFP.sub(l11, this.Water_Vapor_Pressure), l12);
            l8 = MathFP.mul(MathFP.sub(l11, this.Water_Vapor_Pressure), l13);
            l7 = MathFP.mul(l2, l12);
            l6 = MathFP.mul(l2, l13);
        } else {
            l9 = MathFP.mul(l11 - this.Water_Vapor_Pressure - l5, MathFP.div(l12, l14));
            l8 = MathFP.mul(l11 - this.Water_Vapor_Pressure - l5, MathFP.div(l13, l14));
            l7 = MathFP.mul(l2, MathFP.div(l12, l14));
            l6 = MathFP.mul(l2, MathFP.div(l13, l14));
        }
        for (n2 = 0; n2 < 16; ++n2) {
            lArray[n2] = this.Helium_Pressure[n2];
            lArray2[n2] = this.Nitrogen_Pressure[n2];
        }
        n2 = 1;
        while (n2 != 0) {
            int n3;
            n2 = 0;
            long l15 = l10;
            long l16 = MathFP.div(MathFP.sub(l15, l11), l2);
            for (n3 = 0; n3 < 16; ++n3) {
                long l17 = this.SCHREINER_EQUATION(l9, l7, l16, this.Helium_Time_Constant[n3], lArray[n3]);
                long l18 = this.SCHREINER_EQUATION(l8, l6, l16, this.Nitrogen_Time_Constant[n3], lArray2[n3]);
                lArray3[n3] = MathFP.add(l17, l18);
                long l19 = lArray3[n3] > 0L ? MathFP.div(MathFP.mul(this.Allowable_Gradient_He[n3], l17) + MathFP.mul(this.Allowable_Gradient_N2[n3], l18), lArray3[n3]) : MathFP.min(this.Allowable_Gradient_He[n3], this.Allowable_Gradient_N2[n3]);
                lArray4[n3] = l15 + l19 - this.Constant_Pressure_Other_Gases;
            }
            for (n3 = 0; n3 < 16; ++n3) {
                if (lArray3[n3] <= lArray4[n3]) continue;
                l10 = MathFP.add(l15, l4);
                l3 = MathFP.add(l3, l4);
                n2 = 1;
            }
        }
        return l3;
    }

    private void CALC_MAX_ACTUAL_GRADIENT(long l) {
        for (int i = 0; i < 16; ++i) {
            long l2 = this.Helium_Pressure[i] + this.Nitrogen_Pressure[i] + this.Constant_Pressure_Other_Gases - (l + this.Barometric_Pressure);
            if (l2 <= 0L) {
                l2 = 0L;
            }
            this.Max_Actual_Gradient[i] = MathFP.max(this.Max_Actual_Gradient[i], l2);
        }
    }

    private void BOYLES_LAW_COMPENSATION(long l, long l2, long l3) {
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        int n;
        long[] lArray = new long[16];
        long[] lArray2 = new long[16];
        long[] lArray3 = new long[16];
        long[] lArray4 = new long[16];
        long l11 = l2 - l3;
        long l12 = l + this.Barometric_Pressure;
        long l13 = l11 + this.Barometric_Pressure;
        long l14 = MathFP.mul(MathFP.div(l12, this.Units_Factor), MathFP.toFP(101325));
        long l15 = MathFP.mul(MathFP.div(l13, this.Units_Factor), MathFP.toFP(101325));
        for (n = 0; n < 16; ++n) {
            long l16;
            long l17 = MathFP.mul(MathFP.div(this.Allowable_Gradient_He[n], this.Units_Factor), MathFP.toFP(101325));
            lArray[n] = l16 = MathFP.div(this.sd.Surface_Tension_Gamma << 1, MathFP.div(l17, this.FACTOR_RADIUS));
            l10 = l15;
            l9 = -MathFP.mul(this.sd.Surface_Tension_Gamma << 1, this.FACTOR_RADIUS);
            l8 = MathFP.mul(MathFP.mul(MathFP.mul(l14, l16), l16), l16) + MathFP.mul(MathFP.mul(MathFP.mul(this.FACTOR_RADIUS, l16), l16), this.sd.Surface_Tension_Gamma << 1);
            l7 = l16;
            l6 = MathFP.mul(l16, MathFP.crt(MathFP.div(l14, l15)));
            lArray3[n] = l5 = this.RADIUS_ROOT_FINDER(l10, l9, l8, l7, l6);
            l4 = MathFP.div(MathFP.mul(this.FACTOR_RADIUS, this.sd.Surface_Tension_Gamma << 1), l5);
            this.Deco_Gradient_He[n] = MathFP.mul(MathFP.div(l4, MathFP.toFP(101325)), this.Units_Factor);
        }
        for (n = 0; n < 16; ++n) {
            long l18;
            long l19 = MathFP.mul(MathFP.div(this.Allowable_Gradient_N2[n], this.Units_Factor), MathFP.toFP(101325));
            lArray2[n] = l18 = MathFP.div(this.sd.Surface_Tension_Gamma << 1, MathFP.div(l19, this.FACTOR_RADIUS));
            l10 = l15;
            l9 = -MathFP.mul(this.sd.Surface_Tension_Gamma << 1, this.FACTOR_RADIUS);
            l8 = MathFP.mul(MathFP.mul(MathFP.mul(l14, l18), l18), l18) + MathFP.mul(MathFP.mul(MathFP.mul(this.FACTOR_RADIUS, l18), l18), this.sd.Surface_Tension_Gamma << 1);
            l7 = l18;
            l6 = MathFP.mul(l18, MathFP.crt(MathFP.div(l14, l15)));
            lArray4[n] = l5 = this.RADIUS_ROOT_FINDER(l10, l9, l8, l7, l6);
            l4 = MathFP.div(MathFP.mul(this.FACTOR_RADIUS, this.sd.Surface_Tension_Gamma << 1), l5);
            this.Deco_Gradient_N2[n] = MathFP.mul(MathFP.div(l4, MathFP.toFP(101325)), this.Units_Factor);
        }
    }

    private long DECOMPRESSION_STOP(long l, long l2, long l3, int n, long l4) {
        long l5 = MathFP.add(l, this.Barometric_Pressure);
        long l6 = this.Fraction_Helium[n];
        long l7 = this.Fraction_Nitrogen[n];
        if (this.sd.JDeco_Type == 1 && !this.doCCRbailoutFlag) {
            long l8 = MathFP.div(l4, l5);
            long l9 = l6 + l7;
            l6 = MathFP.mul(0x1000000L - l8, MathFP.div(l6, l9));
            l7 = MathFP.mul(0x1000000L - l8, MathFP.div(l7, l9));
        }
        long l10 = MathFP.mul(MathFP.sub(l5, this.Water_Vapor_Pressure), l6);
        long l11 = MathFP.mul(MathFP.sub(l5, this.Water_Vapor_Pressure), l7);
        long l12 = MathFP.sub(l, l2);
        boolean bl = true;
        long l13 = l3;
        while (bl) {
            bl = false;
            for (int i = 0; i < 16; ++i) {
                this.Initial_Helium_Pressure[i] = this.Helium_Pressure[i];
                this.Initial_Nitrogen_Pressure[i] = this.Nitrogen_Pressure[i];
                this.Helium_Pressure[i] = this.HALDANE_EQUATION(this.Initial_Helium_Pressure[i], l10, this.Helium_Time_Constant[i], l3);
                this.Nitrogen_Pressure[i] = this.HALDANE_EQUATION(this.Initial_Nitrogen_Pressure[i], l11, this.Nitrogen_Time_Constant[i], l3);
            }
            long l14 = this.CALC_DECO_CEILING();
            if (l14 > l12) {
                l3 = MathFP.toFP(this.sd.Minimum_Deco_Stop_Time);
                l13 = MathFP.add(l13, MathFP.toFP(this.sd.Minimum_Deco_Stop_Time));
                bl = true;
            }
            if (l13 <= MathFP.toFP(500)) continue;
            return 99999L;
        }
        return l13;
    }

    private long CALC_DECO_CEILING() {
        int n;
        long[] lArray = new long[16];
        for (n = 0; n < 16; ++n) {
            long l;
            long l2;
            long l3 = this.Helium_Pressure[n] + this.Nitrogen_Pressure[n];
            if (l3 > 0L) {
                l2 = MathFP.div(MathFP.mul(this.Deco_Gradient_He[n], this.Helium_Pressure[n]) + MathFP.mul(this.Deco_Gradient_N2[n], this.Nitrogen_Pressure[n]), this.Helium_Pressure[n] + this.Nitrogen_Pressure[n]);
                l = l3 + this.Constant_Pressure_Other_Gases - l2;
            } else {
                l2 = MathFP.min(this.Deco_Gradient_He[n], this.Deco_Gradient_N2[n]);
                l = this.Constant_Pressure_Other_Gases - l2;
            }
            if (l < 0L) {
                l = 0L;
            }
            lArray[n] = l - this.Barometric_Pressure;
        }
        long l = lArray[0];
        for (n = 1; n < 16; ++n) {
            l = MathFP.max(l, lArray[n]);
        }
        return l;
    }

    private void CALC_SURFACE_PHASE_VOLUME_TIME() {
        long l = MathFP.mul(this.Barometric_Pressure - this.Water_Vapor_Pressure, MathFP.toFP("0.79"));
        for (int i = 0; i < 16; ++i) {
            if (this.Nitrogen_Pressure[i] > l) {
                this.Surface_Phase_Volume_Time[i] = MathFP.div(MathFP.div(this.Helium_Pressure[i], this.Helium_Time_Constant[i]) + MathFP.div(this.Nitrogen_Pressure[i] - l, this.Nitrogen_Time_Constant[i]), this.Helium_Pressure[i] + this.Nitrogen_Pressure[i] - l);
                continue;
            }
            if (this.Nitrogen_Pressure[i] <= l && this.Helium_Pressure[i] + this.Nitrogen_Pressure[i] >= l) {
                long l2 = MathFP.mul(MathFP.div(0x1000000L, this.Nitrogen_Time_Constant[i] - this.Helium_Time_Constant[i]), MathFP.log(MathFP.div(l - this.Nitrogen_Pressure[i], this.Helium_Pressure[i])));
                long l3 = MathFP.mul(MathFP.div(this.Helium_Pressure[i], this.Helium_Time_Constant[i]), 0x1000000L - MathFP.exp(-MathFP.mul(this.Helium_Time_Constant[i], l2))) + MathFP.mul(MathFP.div(this.Nitrogen_Pressure[i] - l, this.Nitrogen_Time_Constant[i]), 0x1000000L - MathFP.exp(-MathFP.mul(this.Nitrogen_Time_Constant[i], l2)));
                this.Surface_Phase_Volume_Time[i] = MathFP.div(l3, this.Helium_Pressure[i] + this.Nitrogen_Pressure[i] - l);
                continue;
            }
            this.Surface_Phase_Volume_Time[i] = 0L;
        }
    }

    private void CRITICAL_VOLUME(long l) {
        long l2;
        long l3;
        int n;
        long l4 = MathFP.mul(MathFP.div(this.sd.Crit_Volume_Parameter_Lambda, MathFP.toFP(33)), MathFP.toFP(101325));
        long[] lArray = new long[16];
        for (n = 0; n < 16; ++n) {
            lArray[n] = l + this.Surface_Phase_Volume_Time[n];
        }
        for (n = 0; n < 16; ++n) {
            long l5 = MathFP.mul(this.Adjusted_Crushing_Pressure_He[n], MathFP.div(MathFP.toFP(101325), this.Units_Factor));
            long l6 = MathFP.mul(MathFP.div(this.Initial_Allowable_Gradient_He[n], this.Units_Factor), MathFP.toFP(101325));
            l3 = l6 + MathFP.div(MathFP.mul(l4, this.sd.Surface_Tension_Gamma), MathFP.mul(this.sd.Skin_Compression_GammaC, lArray[n]));
            l2 = MathFP.div(MathFP.mul(MathFP.mul(MathFP.mul(this.sd.Surface_Tension_Gamma, this.sd.Surface_Tension_Gamma), l4), l5), MathFP.mul(MathFP.mul(this.sd.Skin_Compression_GammaC, this.sd.Skin_Compression_GammaC), lArray[n]));
            long l7 = l3 + MathFP.sqrt(MathFP.mul(l3, l3) - (l2 << 2)) >> 1;
            this.Allowable_Gradient_He[n] = MathFP.mul(MathFP.div(l7, MathFP.toFP(101325)), this.Units_Factor);
        }
        for (n = 0; n < 16; ++n) {
            long l8 = MathFP.mul(MathFP.div(this.Adjusted_Crushing_Pressure_N2[n], this.Units_Factor), MathFP.toFP(101325));
            long l9 = MathFP.mul(MathFP.div(this.Initial_Allowable_Gradient_N2[n], this.Units_Factor), MathFP.toFP(101325));
            l3 = l9 + MathFP.div(MathFP.mul(l4, this.sd.Surface_Tension_Gamma), MathFP.mul(this.sd.Skin_Compression_GammaC, lArray[n]));
            l2 = MathFP.div(MathFP.mul(MathFP.mul(MathFP.mul(this.sd.Surface_Tension_Gamma, this.sd.Surface_Tension_Gamma), l4), l8), MathFP.mul(MathFP.mul(this.sd.Skin_Compression_GammaC, this.sd.Skin_Compression_GammaC), lArray[n]));
            long l10 = l3 + MathFP.sqrt(MathFP.mul(l3, l3) - (l2 << 2)) >> 1;
            this.Allowable_Gradient_N2[n] = MathFP.mul(MathFP.div(l10, MathFP.toFP(101325)), this.Units_Factor);
        }
    }

    private void GAS_LOADINGS_CNS_SURFACE_INTERVAL(long l) {
        long l2 = 0L;
        long l3 = MathFP.mul(MathFP.sub(this.Barometric_Pressure, this.Water_Vapor_Pressure), MathFP.toFP("0.79"));
        for (int i = 0; i < 16; ++i) {
            this.Helium_Pressure[i] = this.HALDANE_EQUATION(this.Helium_Pressure[i], l2, this.Helium_Time_Constant[i], l);
            this.Nitrogen_Pressure[i] = this.HALDANE_EQUATION(this.Nitrogen_Pressure[i], l3, this.Nitrogen_Time_Constant[i], l);
        }
        long l4 = MathFP.toFP("0.00770163");
        this.diveCNS = MathFP.mul(this.diveCNS, MathFP.exp(-MathFP.mul(l4, l)));
    }

    private void VPM_REPETITIVE_ALGORITHM(long l) {
        for (int i = 0; i < 16; ++i) {
            long l2 = MathFP.mul(MathFP.div(this.Max_Actual_Gradient[i], this.Units_Factor), MathFP.toFP(101325));
            long l3 = MathFP.mul(MathFP.div(this.Adjusted_Crushing_Pressure_He[i], this.Units_Factor), MathFP.toFP(101325));
            long l4 = MathFP.mul(MathFP.div(this.Adjusted_Crushing_Pressure_N2[i], this.Units_Factor), MathFP.toFP(101325));
            long l5 = MathFP.mul(MathFP.div(this.Initial_Allowable_Gradient_He[i], this.Units_Factor), MathFP.toFP(101325));
            long l6 = MathFP.mul(MathFP.div(this.Initial_Allowable_Gradient_N2[i], this.Units_Factor), MathFP.toFP(101325));
            if (this.Max_Actual_Gradient[i] > this.Initial_Allowable_Gradient_N2[i]) {
                long l7 = MathFP.div(MathFP.mul(this.FACTOR_RADIUS, MathFP.mul(this.sd.Surface_Tension_Gamma, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma) << 1), MathFP.mul(l2, this.sd.Skin_Compression_GammaC) - MathFP.mul(this.sd.Surface_Tension_Gamma, l4));
                this.Adjusted_Critical_Radius_N2[i] = this.Initial_Critical_Radius_N2[i] + MathFP.mul(this.Initial_Critical_Radius_N2[i] - l7, MathFP.exp(-MathFP.div(l, this.sd.Regeneration_Time_Constant)));
            } else {
                this.Adjusted_Critical_Radius_N2[i] = this.Initial_Critical_Radius_N2[i];
            }
            if (this.Max_Actual_Gradient[i] > this.Initial_Allowable_Gradient_He[i]) {
                long l8 = MathFP.div(MathFP.mul(this.FACTOR_RADIUS, MathFP.mul(this.sd.Surface_Tension_Gamma, this.sd.Skin_Compression_GammaC - this.sd.Surface_Tension_Gamma) << 1), MathFP.mul(l2, this.sd.Skin_Compression_GammaC) - MathFP.mul(this.sd.Surface_Tension_Gamma, l3));
                this.Adjusted_Critical_Radius_He[i] = this.Initial_Critical_Radius_He[i] + MathFP.mul(this.Initial_Critical_Radius_He[i] - l8, MathFP.exp(-MathFP.div(l, this.sd.Regeneration_Time_Constant)));
                continue;
            }
            this.Adjusted_Critical_Radius_He[i] = this.Initial_Critical_Radius_He[i];
        }
    }

    private long CORRECT_PPO2(long l, long l2, long l3) {
        long l4 = l + this.Barometric_Pressure;
        long l5 = this.Fraction_Oxygen[(int)l2];
        long l6 = MathFP.mul(l4 - this.Water_Vapor_Pressure, l5);
        if (l6 > l3) {
            return l6;
        }
        return l3;
    }
}

