/*
 * Decompiled with CFR 0.152.
 */
package JDeco;

import JDeco.DiveData;
import JDeco.GasData;
import JDeco.JDeco;
import JDeco.MathFP;
import JDeco.SettingsData;
import JDeco.UserInterface;

public class CalculateDiveSeries
extends Thread {
    private boolean running = false;
    public boolean calculationReady = false;
    private boolean doCCRbailoutFlag = false;
    private long Units_Factor = MathFP.toFP("32.80839895");
    private long Water_Vapor_Pressure = MathFP.toFP("1.86023622");
    private long[] AHE = new long[]{MathFP.toFP("52.72509252"), MathFP.toFP("45.04219097"), MathFP.toFP("38.81835677"), MathFP.toFP("34.06010363"), MathFP.toFP("30.02812731"), MathFP.toFP("26.72242783"), MathFP.toFP("23.79126573"), MathFP.toFP("21.17601776"), MathFP.toFP("19.37823834"), MathFP.toFP("18.05921540"), MathFP.toFP("17.36876388"), MathFP.toFP("16.89977794"), MathFP.toFP("16.87372317"), MathFP.toFP("16.85743893"), MathFP.toFP("16.84441155"), MathFP.toFP("16.67179867")};
    private long[] BHE = new long[]{MathFP.toFP("0.4770"), MathFP.toFP("0.5747"), MathFP.toFP("0.6527"), MathFP.toFP("0.7223"), MathFP.toFP("0.7582"), MathFP.toFP("0.7957"), MathFP.toFP("0.8279"), MathFP.toFP("0.8553"), MathFP.toFP("0.8757"), MathFP.toFP("0.8903"), MathFP.toFP("0.8997"), MathFP.toFP("0.9073"), MathFP.toFP("0.9122"), MathFP.toFP("0.9171"), MathFP.toFP("0.9217"), MathFP.toFP("0.9267")};
    private long[] AN2 = new long[]{MathFP.toFP("38.09207994"), MathFP.toFP("32.56846780"), MathFP.toFP("28.06750555"), MathFP.toFP("24.62827535"), MathFP.toFP("21.71339748"), MathFP.toFP("18.23834197"), MathFP.toFP("16.11162102"), MathFP.toFP("14.65581051"), MathFP.toFP("13.63641747"), MathFP.toFP("12.36950407"), MathFP.toFP("11.38919319"), MathFP.toFP("10.49681717"), MathFP.toFP("9.28201332"), MathFP.toFP("8.91398964"), MathFP.toFP("8.21702443"), MathFP.toFP("7.57868246")};
    private long[] BN2 = new long[]{MathFP.toFP("0.5578"), MathFP.toFP("0.6514"), MathFP.toFP("0.7222"), MathFP.toFP("0.7825"), MathFP.toFP("0.8126"), MathFP.toFP("0.8434"), MathFP.toFP("0.8693"), MathFP.toFP("0.8910"), MathFP.toFP("0.9092"), MathFP.toFP("0.9222"), MathFP.toFP("0.9319"), MathFP.toFP("0.9403"), MathFP.toFP("0.9477"), MathFP.toFP("0.9544"), MathFP.toFP("0.9602"), MathFP.toFP("0.9653")};
    public long[] Nitrogen_Time_Constant = new long[]{MathFP.toFP("0.138629436"), MathFP.toFP("0.086643398"), MathFP.toFP("0.055451774"), MathFP.toFP("0.037467415"), MathFP.toFP("0.025672118"), MathFP.toFP("0.018097838"), MathFP.toFP("0.012765141"), MathFP.toFP("0.009001911"), MathFP.toFP("0.006359148"), MathFP.toFP("0.004747583"), MathFP.toFP("0.003706669"), MathFP.toFP("0.002900197"), MathFP.toFP("0.002272614"), MathFP.toFP("0.001777300"), MathFP.toFP("0.001391862"), MathFP.toFP("0.001091570")};
    public long[] Helium_Time_Constant = new long[]{MathFP.toFP("0.368695309"), MathFP.toFP("0.229518934"), MathFP.toFP("0.146853216"), MathFP.toFP("0.099162687"), MathFP.toFP("0.067889048"), MathFP.toFP("0.047869280"), MathFP.toFP("0.033762649"), MathFP.toFP("0.023811308"), MathFP.toFP("0.016823961"), MathFP.toFP("0.012559289"), MathFP.toFP("0.009805449"), MathFP.toFP("0.007672650"), MathFP.toFP("0.006012206"), MathFP.toFP("0.004701853"), MathFP.toFP("0.003682252"), MathFP.toFP("0.002887752")};
    private long[] PPO2axis = new long[]{MathFP.toFP("0.510"), MathFP.toFP("0.550"), MathFP.toFP("0.600"), MathFP.toFP("0.650"), MathFP.toFP("0.700"), MathFP.toFP("0.750"), MathFP.toFP("0.800"), MathFP.toFP("0.850"), MathFP.toFP("0.900"), MathFP.toFP("0.950"), MathFP.toFP("1.000"), MathFP.toFP("1.050"), MathFP.toFP("1.100"), MathFP.toFP("1.150"), MathFP.toFP("1.200"), MathFP.toFP("1.250"), MathFP.toFP("1.300"), MathFP.toFP("1.350"), MathFP.toFP("1.400"), MathFP.toFP("1.450"), MathFP.toFP("1.500"), MathFP.toFP("1.550"), MathFP.toFP("1.600"), MathFP.toFP("1.650"), MathFP.toFP("1.700")};
    private long[] CNSvalues = new long[]{MathFP.toFP("0.112"), MathFP.toFP("0.122"), MathFP.toFP("0.137"), MathFP.toFP("0.153"), MathFP.toFP("0.172"), MathFP.toFP("0.193"), MathFP.toFP("0.218"), MathFP.toFP("0.242"), MathFP.toFP("0.272"), MathFP.toFP("0.298"), MathFP.toFP("0.327"), MathFP.toFP("0.362"), MathFP.toFP("0.405"), MathFP.toFP("0.438"), MathFP.toFP("0.468"), MathFP.toFP("0.503"), MathFP.toFP("0.543"), MathFP.toFP("0.591"), MathFP.toFP("0.660"), MathFP.toFP("0.717"), MathFP.toFP("0.820"), MathFP.toFP("1.056"), MathFP.toFP("2.050"), MathFP.toFP("3.035"), MathFP.toFP("6.415")};
    private long[] OTUvalues = new long[]{MathFP.toFP("0.023"), MathFP.toFP("0.135"), MathFP.toFP("0.250"), MathFP.toFP("0.354"), MathFP.toFP("0.453"), MathFP.toFP("0.548"), MathFP.toFP("0.639"), MathFP.toFP("0.728"), MathFP.toFP("0.815"), MathFP.toFP("0.900"), MathFP.toFP("0.983"), MathFP.toFP("1.065"), MathFP.toFP("1.146"), MathFP.toFP("1.226"), MathFP.toFP("1.304"), MathFP.toFP("1.382"), MathFP.toFP("1.459"), MathFP.toFP("1.535"), MathFP.toFP("1.610"), MathFP.toFP("1.684"), MathFP.toFP("1.758"), MathFP.toFP("1.832"), MathFP.toFP("1.904"), MathFP.toFP("1.976"), MathFP.toFP("2.048")};
    private long Barometric_Pressure;
    private JDeco jd;
    private SettingsData sd;
    private GasData gd;
    private DiveData dd;
    private UserInterface ui;
    private long[] Helium_Pressure = new long[16];
    private long[] Nitrogen_Pressure = new long[16];
    private long[] Fraction_Oxygen = new long[JDeco.MAX_MIXES];
    private long[] Fraction_Helium = new long[JDeco.MAX_MIXES];
    private long[] Fraction_Nitrogen = new long[JDeco.MAX_MIXES];
    private long[] Running_Gas_Volume = new long[JDeco.MAX_MIXES];
    private long Gradient_Factor_Lo;
    private long Gradient_Factor_Hi;
    private long deepestStop;
    private long diveCNS;
    private long diveOTU;
    private long diveseriesOTU;
    String text;
    int index_result = 0;
    int Number_Mixes;
    int Row_Dive_Data;
    int Dive_Number;
    int Mix_Number = 0;
    int Number_of_Dives;
    long Run_Time;
    long Depth_Last_Segment;
    long Depth_Segment = MathFP.toFP(0);
    long Time_Segment;
    long Time_Depth_Change;
    long Rate;
    long Time_Depth_Constant;
    long Gradient_Factor;
    long Starting_Depth;
    long Step_Size;
    long Depth_Start_of_Deco_Zone;
    long Deepest_Possible_Stop_Depth;
    long Deco_Ceiling_Depth;
    long Deco_Stop_Depth;
    long Factor_Slope = MathFP.toFP(0);
    long test_max;
    long test;
    long Gradient_Factor_Current_Stop;
    long Next_Stop;
    long Segment_Time_Start;
    long Segment_Time;
    long Deco_Stop_Time;
    long Surface_Interval_Time;
    boolean addExtraDecoSwitchTime = false;
    long PPO2Set_Segment = 0L;
    int used_deco_gas_index = 0;
    long PPO2_Corrected = 0L;
    boolean lastAscentFlag = false;

    public CalculateDiveSeries(JDeco jDeco, SettingsData settingsData, GasData gasData, DiveData diveData, UserInterface userInterface) {
        this.jd = jDeco;
        this.sd = settingsData;
        this.gd = gasData;
        this.dd = diveData;
        this.ui = userInterface;
        this.Barometric_Pressure = this.sd.calcBarometricPressure(this.sd.Altitude_of_Dive);
        int n = 0;
        while (this.gd.Fraction_Oxygen[n] != 9999L) {
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            this.Fraction_Oxygen[i] = MathFP.div(MathFP.toFP(this.gd.Fraction_Oxygen[i]), MathFP.toFP(100));
            this.Fraction_Helium[i] = MathFP.div(MathFP.toFP(this.gd.Fraction_Helium[i]), MathFP.toFP(100));
            this.Fraction_Nitrogen[i] = MathFP.div(MathFP.toFP(this.gd.Fraction_Nitrogen[i]), MathFP.toFP(100));
        }
        this.Gradient_Factor_Lo = MathFP.div(MathFP.toFP(this.sd.Gradient_Factor_Lo), MathFP.toFP(100));
        this.Gradient_Factor_Hi = MathFP.div(MathFP.toFP(this.sd.Gradient_Factor_Hi), MathFP.toFP(100));
    }

    public void run() {
        this.running = true;
        this.doCalc();
        while (this.running) {
            try {
                CalculateDiveSeries.sleep(1000L);
            }
            catch (Throwable throwable) {}
        }
    }

    public void stopIt() {
        this.AHE = null;
        this.BHE = null;
        this.AN2 = null;
        this.BN2 = null;
        this.Nitrogen_Time_Constant = null;
        this.Helium_Time_Constant = null;
        this.jd = null;
        this.sd = null;
        this.gd = null;
        this.dd = null;
        this.ui = null;
        this.Helium_Pressure = null;
        this.Nitrogen_Pressure = null;
        this.Fraction_Oxygen = null;
        this.Fraction_Helium = null;
        this.Fraction_Nitrogen = null;
        this.Running_Gas_Volume = null;
        this.running = false;
    }

    private void doCalc() {
        int n;
        this.calculationReady = false;
        for (n = 0; n < 16; ++n) {
            this.Helium_Pressure[n] = MathFP.toFP(0);
            this.Nitrogen_Pressure[n] = MathFP.mul(MathFP.sub(this.Barometric_Pressure, this.Water_Vapor_Pressure), MathFP.toFP("0.79"));
        }
        this.Number_of_Dives = 0;
        while (this.dd.Dive_Profile[this.Number_of_Dives][0][0] != 9999L) {
            ++this.Number_of_Dives;
        }
        this.Number_Mixes = 0;
        while (this.gd.Fraction_Oxygen[this.Number_Mixes] != 9999L) {
            ++this.Number_Mixes;
        }
        this.diveseriesOTU = 0L;
        this.diveCNS = 0L;
        this.doCCRbailoutFlag = false;
        this.Dive_Number = 0;
        while (this.Dive_Number < this.Number_of_Dives) {
            this.Run_Time = 0L;
            this.diveOTU = 0L;
            for (n = 0; n < this.Number_Mixes; ++n) {
                this.Running_Gas_Volume[n] = 0L;
            }
            this.Depth_Last_Segment = 0L;
            this.Row_Dive_Data = 0;
            while (this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][0] != 999L) {
                this.Depth_Segment = MathFP.toFP(this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][0]);
                this.Time_Segment = MathFP.toFP(this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][1]);
                this.Mix_Number = (int)this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][2];
                this.PPO2Set_Segment = MathFP.mul(this.dd.Dive_Profile[this.Dive_Number][this.Row_Dive_Data][3], this.Units_Factor);
                this.Time_Depth_Change = MathFP.toFP(0);
                if (this.Depth_Last_Segment == 0L) {
                    this.Rate = MathFP.toFP(this.sd.Rate_Initial_Descent);
                } else {
                    this.Rate = MathFP.toFP(this.sd.Rate_During_Dive);
                    if (MathFP.sub(this.Depth_Segment, this.Depth_Last_Segment) < 0L) {
                        this.Rate = -this.Rate;
                    }
                }
                this.Deco_Ceiling_Depth = this.CALC_DECO_CEILING(this.Gradient_Factor_Lo, this.Helium_Pressure, this.Nitrogen_Pressure);
                if (this.Deco_Ceiling_Depth > this.Depth_Segment) {
                    int n2 = this.Mix_Number;
                    long l = this.PPO2Set_Segment;
                    long l2 = this.DO_DECOMPRESSION(this.Depth_Last_Segment, this.Depth_Segment);
                    if (this.calculationReady) {
                        return;
                    }
                    this.Time_Depth_Change = MathFP.abs(MathFP.div(l2 - this.Depth_Segment, this.Rate));
                    this.DIVEDATA_GAS_VOLUME_OTU_CNS(l2, this.Depth_Segment, this.Time_Depth_Change, MathFP.toFP(this.sd.RMV_During_Deco), this.Mix_Number, this.PPO2Set_Segment);
                    this.Time_Depth_Constant = this.Time_Segment - this.Time_Depth_Change;
                    this.Mix_Number = n2;
                    this.PPO2Set_Segment = l;
                } else {
                    this.Time_Depth_Change = MathFP.abs(MathFP.div(MathFP.sub(this.Depth_Segment, this.Depth_Last_Segment), this.Rate));
                    if (this.Row_Dive_Data == 0) {
                        this.ui.RunTimeInitialDescent = this.Time_Depth_Change;
                    }
                    this.GAS_LOADINGS_ASCENT_DESCENT(this.Depth_Last_Segment, this.Depth_Segment, this.Mix_Number, this.Rate, this.Time_Depth_Change, this.PPO2Set_Segment);
                    this.DIVEDATA_GAS_VOLUME_OTU_CNS(this.Depth_Last_Segment, this.Depth_Segment, this.Time_Depth_Change, this.sd.RMV_During_Dive, this.Mix_Number, this.PPO2Set_Segment);
                    this.Time_Depth_Constant = MathFP.sub(this.Time_Segment, this.Time_Depth_Change);
                    if (this.Time_Depth_Constant <= 0L) {
                        this.ui.computationError = "Rate for depth change to small. Check the settings!";
                        this.calculationReady = true;
                        return;
                    }
                }
                this.PPO2_Corrected = this.sd.JDeco_Type == 1 ? this.CORRECT_PPO2(this.Depth_Segment, this.Mix_Number, this.PPO2Set_Segment) : this.PPO2Set_Segment;
                this.GAS_LOADINGS_CONSTANT_DEPTH(this.Depth_Segment, this.Mix_Number, this.Time_Depth_Constant, this.PPO2_Corrected);
                this.DIVEDATA_GAS_VOLUME_OTU_CNS(this.Depth_Segment, this.Depth_Segment, this.Time_Depth_Constant, this.sd.RMV_During_Dive, this.Mix_Number, this.PPO2_Corrected);
                this.Run_Time = MathFP.add(this.Run_Time, this.Time_Segment);
                if (this.Dive_Number == this.Number_of_Dives - 1) {
                    this.ui.Segment_Depth_Last_Dive[this.index_result] = MathFP.toLong(this.Depth_Segment);
                    this.ui.Segment_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Time_Segment);
                    this.ui.Segment_Mix_Last_Dive[this.index_result] = this.Mix_Number;
                    this.ui.Segment_PPO2_Last_Dive[this.index_result] = MathFP.div(this.PPO2_Corrected, this.Units_Factor);
                    this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = 0L;
                    this.ui.Run_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Run_Time);
                    ++this.index_result;
                }
                this.Depth_Last_Segment = this.Depth_Segment;
                ++this.Row_Dive_Data;
            }
            this.lastAscentFlag = true;
            if (this.sd.JDeco_Type == 1 && this.ui.bailoutCCRFlag && this.Dive_Number == this.Number_of_Dives - 1) {
                this.doCCRbailoutFlag = true;
            }
            if (this.sd.JDeco_Type == 1) {
                if (!this.doCCRbailoutFlag) {
                    n = 0;
                    this.test_max = -MathFP.toFP(1000);
                    while (this.dd.CCR_Deco_Settings[this.Dive_Number][n][0] != 999L) {
                        this.test = MathFP.sub(this.Depth_Segment, MathFP.toFP(this.dd.CCR_Deco_Settings[this.Dive_Number][n][0]));
                        if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                            this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                            break;
                        }
                        if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                            this.test_max = this.test;
                            this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                        }
                        ++n;
                    }
                } else {
                    n = 0;
                    this.test_max = -MathFP.toFP(1000);
                    while (this.dd.Deco_Settings[this.Dive_Number][n][0] != 999L) {
                        this.test = MathFP.sub(this.Depth_Segment, MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][n][0]));
                        if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                            this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = 0L;
                            break;
                        }
                        if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                            this.test_max = this.test;
                            this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                            this.PPO2Set_Segment = 0L;
                        }
                        ++n;
                    }
                }
            }
            this.DO_DECOMPRESSION(this.Depth_Segment, 0L);
            if (this.calculationReady) {
                return;
            }
            this.Segment_Time = MathFP.abs(MathFP.div(MathFP.toFP(this.sd.Last_Deco_Stop_Depth), this.Rate));
            this.DIVEDATA_GAS_VOLUME_OTU_CNS(MathFP.toFP(this.sd.Last_Deco_Stop_Depth), 0L, this.Segment_Time, this.sd.RMV_During_Deco, this.Mix_Number, this.PPO2Set_Segment);
            this.ui.Complete_Runtime = MathFP.toLong(MathFP.ceil(MathFP.add(this.Run_Time, this.Segment_Time)));
            for (n = 0; n < this.Number_Mixes; ++n) {
                this.ui.Needed_Gas_Last_Dive[n] = MathFP.toLong(MathFP.ceil(this.Running_Gas_Volume[n]));
            }
            this.ui.Needed_Gas_Last_Dive[this.Number_Mixes] = 9999L;
            this.diveseriesOTU += this.diveOTU;
            if (this.Dive_Number < this.Number_of_Dives - 1) {
                this.Surface_Interval_Time = MathFP.toFP(this.dd.Surface_Interval[this.Dive_Number]);
                this.GAS_LOADINGS_CNS_SURFACE_INTERVAL(this.Surface_Interval_Time);
            }
            ++this.Dive_Number;
        }
        this.ui.Segment_Depth_Last_Dive[this.index_result] = 9999L;
        this.ui.Segment_Time_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_Mix_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_PPO2_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = 0L;
        this.ui.Run_Time_Last_Dive[this.index_result] = 0L;
        ++this.index_result;
        this.deepestStop = MathFP.toLong(this.Deepest_Possible_Stop_Depth);
        if (this.deepestStop < 0L) {
            this.deepestStop = 0L;
        }
        this.ui.Segment_Depth_Last_Dive[this.index_result] = this.deepestStop;
        this.ui.Segment_Time_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_Mix_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_PPO2_Last_Dive[this.index_result] = 0L;
        this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = 0L;
        this.ui.Run_Time_Last_Dive[this.index_result] = 0L;
        this.ui.diveCNS = MathFP.ceil(this.diveCNS);
        this.ui.diveOTU = MathFP.ceil(this.diveOTU);
        this.ui.diveseriesOTU = MathFP.ceil(this.diveseriesOTU);
        this.calculationReady = true;
    }

    private long DO_DECOMPRESSION(long l, long l2) {
        this.Gradient_Factor = this.Gradient_Factor_Lo;
        this.Rate = -MathFP.toFP(this.sd.Rate_During_Deco);
        this.Starting_Depth = l;
        this.Step_Size = MathFP.toFP(this.sd.Deco_Stop_Step_Size);
        this.Depth_Start_of_Deco_Zone = this.CALC_START_OF_DECO_ZONE(this.Starting_Depth, this.Rate, this.Mix_Number, this.PPO2Set_Segment);
        if (this.Depth_Start_of_Deco_Zone == 99999L) {
            this.Depth_Start_of_Deco_Zone = l;
        }
        if (this.Depth_Start_of_Deco_Zone == 99998L) {
            this.ui.computationError = "Root search exceeded maximum iterations.";
            this.calculationReady = true;
            return -1L;
        }
        this.Deepest_Possible_Stop_Depth = MathFP.mul(MathFP.floor(MathFP.div(this.Depth_Start_of_Deco_Zone, this.Step_Size)), this.Step_Size);
        this.Deco_Ceiling_Depth = this.CALC_DECO_CEILING(this.Gradient_Factor, this.Helium_Pressure, this.Nitrogen_Pressure);
        if (this.Deco_Ceiling_Depth < MathFP.toFP(0)) {
            if (this.Dive_Number == this.Number_of_Dives - 1) {
                this.ui.computationError = "Ascent directly to surface!";
                this.ui.directAscentMessage = true;
                this.calculationReady = true;
                return -1L;
            }
            this.Deco_Stop_Depth = MathFP.toFP(0);
        } else {
            this.Deco_Stop_Depth = MathFP.mul(MathFP.ceil(MathFP.div(this.Deco_Ceiling_Depth, this.Step_Size)), this.Step_Size);
        }
        if (this.Deco_Stop_Depth > l2) {
            this.Factor_Slope = MathFP.div(MathFP.sub(this.Gradient_Factor_Hi, this.Gradient_Factor_Lo), MathFP.sub(MathFP.toFP(0), this.Deco_Stop_Depth));
        }
        while (this.Deco_Stop_Depth > l2) {
            int n;
            this.Time_Depth_Change = MathFP.abs(MathFP.div(MathFP.sub(this.Deco_Stop_Depth, this.Starting_Depth), this.Rate));
            this.GAS_LOADINGS_ASCENT_DESCENT(this.Starting_Depth, this.Deco_Stop_Depth, this.Mix_Number, this.Rate, this.Time_Depth_Change, this.PPO2Set_Segment);
            this.DIVEDATA_GAS_VOLUME_OTU_CNS(this.Starting_Depth, this.Deco_Stop_Depth, this.Time_Depth_Change, this.sd.RMV_During_Deco, this.Mix_Number, this.PPO2Set_Segment);
            this.Run_Time = MathFP.add(this.Run_Time, this.Time_Depth_Change);
            if (this.Deco_Stop_Depth <= MathFP.toFP(this.sd.Last_Deco_Stop_Depth)) {
                this.Step_Size = this.Deco_Stop_Depth;
                this.Rate = -this.Deco_Stop_Depth;
            }
            if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
                n = 0;
                this.test_max = -MathFP.toFP(1000);
                int n2 = this.Mix_Number;
                while (this.dd.Deco_Settings[this.Dive_Number][n][0] != 999L) {
                    this.test = MathFP.sub(this.Deco_Stop_Depth, MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][n][0]));
                    if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                        this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                        this.used_deco_gas_index = n;
                        break;
                    }
                    if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                        this.test_max = this.test;
                        this.used_deco_gas_index = n;
                        this.Mix_Number = (int)this.dd.Deco_Settings[this.Dive_Number][n][1];
                    }
                    ++n;
                }
                if (this.sd.JDeco_Type == 0) {
                    if (this.ui.bailoutFlag && this.Dive_Number == this.Number_of_Dives - 1 && n2 != this.Mix_Number && this.Mix_Number == this.ui.bailoutGasLoss) {
                        this.Mix_Number = n2;
                    }
                    this.addExtraDecoSwitchTime = false;
                    if (n2 != this.Mix_Number) {
                        this.addExtraDecoSwitchTime = true;
                    }
                } else {
                    this.PPO2Set_Segment = 0L;
                }
            } else {
                n = 0;
                this.test_max = -MathFP.toFP(1000);
                while (this.dd.CCR_Deco_Settings[this.Dive_Number][n][0] != 999L) {
                    this.test = MathFP.sub(this.Deco_Stop_Depth, MathFP.toFP(this.dd.CCR_Deco_Settings[this.Dive_Number][n][0]));
                    if (MathFP.abs(this.test) < MathFP.toFP("0.1")) {
                        this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                        this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                        this.used_deco_gas_index = n;
                        break;
                    }
                    if (this.test < MathFP.toFP(0) && this.test > this.test_max) {
                        this.test_max = this.test;
                        this.Mix_Number = (int)this.dd.CCR_Deco_Settings[this.Dive_Number][n][1];
                        this.used_deco_gas_index = n;
                        this.PPO2Set_Segment = MathFP.mul(this.dd.CCR_Deco_Settings[this.Dive_Number][n][2], this.Units_Factor);
                    }
                    ++n;
                }
            }
            this.Gradient_Factor_Current_Stop = this.Gradient_Factor;
            this.Next_Stop = MathFP.sub(this.Deco_Stop_Depth, this.Step_Size);
            this.Gradient_Factor = MathFP.add(MathFP.mul(this.Next_Stop, this.Factor_Slope), this.Gradient_Factor_Hi);
            this.Segment_Time_Start = MathFP.sub(MathFP.mul(MathFP.ceil(MathFP.div(this.Run_Time, MathFP.toFP(this.sd.Minimum_Deco_Stop_Time))), MathFP.toFP(this.sd.Minimum_Deco_Stop_Time)), this.Run_Time);
            this.PPO2_Corrected = this.sd.JDeco_Type == 1 ? this.CORRECT_PPO2(this.Deco_Stop_Depth, this.Mix_Number, this.PPO2Set_Segment) : this.PPO2Set_Segment;
            this.Segment_Time = this.DECOMPRESSION_STOP(this.Deco_Stop_Depth, this.Step_Size, this.Segment_Time_Start, this.Mix_Number, this.Gradient_Factor, this.PPO2_Corrected);
            if (this.Segment_Time == 99999L) {
                this.ui.computationError = "Decompression Time to long!";
                this.calculationReady = true;
                return -1L;
            }
            if (this.sd.JDeco_Type == 0 && this.addExtraDecoSwitchTime) {
                this.GAS_LOADINGS_CONSTANT_DEPTH(this.Deco_Stop_Depth, this.Mix_Number, MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][this.used_deco_gas_index][2]), this.PPO2_Corrected);
                this.Segment_Time += MathFP.toFP(this.dd.Deco_Settings[this.Dive_Number][this.used_deco_gas_index][2]);
            }
            this.DIVEDATA_GAS_VOLUME_OTU_CNS(this.Deco_Stop_Depth, this.Deco_Stop_Depth, this.Segment_Time, this.sd.RMV_During_Deco, this.Mix_Number, this.PPO2_Corrected);
            this.Run_Time = MathFP.add(this.Run_Time, this.Segment_Time);
            this.Deco_Stop_Time = MathFP.mul(MathFP.ceil(MathFP.div(this.Segment_Time, MathFP.toFP(this.sd.Minimum_Deco_Stop_Time))), MathFP.toFP(this.sd.Minimum_Deco_Stop_Time));
            if (this.Dive_Number == this.Number_of_Dives - 1) {
                this.ui.Segment_Depth_Last_Dive[this.index_result] = MathFP.toLong(this.Deco_Stop_Depth);
                this.ui.Segment_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Deco_Stop_Time);
                this.ui.Segment_Mix_Last_Dive[this.index_result] = this.Mix_Number;
                this.ui.Segment_PPO2_Last_Dive[this.index_result] = MathFP.div(this.PPO2_Corrected, this.Units_Factor);
                this.ui.Segment_DECOFlag_Last_Dive[this.index_result] = this.lastAscentFlag ? 1L : 0L;
                this.ui.Run_Time_Last_Dive[this.index_result] = MathFP.toLong(this.Run_Time);
                ++this.index_result;
            }
            this.Starting_Depth = this.Deco_Stop_Depth;
            this.Deco_Stop_Depth = this.Next_Stop;
        }
        return this.Starting_Depth;
    }

    private void GAS_LOADINGS_ASCENT_DESCENT(long l, long l2, int n, long l3, long l4, long l5) {
        long l6;
        long l7;
        long l8;
        long l9;
        long l10 = MathFP.add(l, this.Barometric_Pressure);
        long l11 = this.Fraction_Helium[n];
        long l12 = this.Fraction_Nitrogen[n];
        long l13 = l12 + l11;
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            l9 = MathFP.mul(MathFP.sub(l10, this.Water_Vapor_Pressure), l11);
            l8 = MathFP.mul(MathFP.sub(l10, this.Water_Vapor_Pressure), l12);
            l7 = MathFP.mul(l3, l11);
            l6 = MathFP.mul(l3, l12);
        } else {
            l9 = MathFP.mul(l10 - this.Water_Vapor_Pressure - l5, MathFP.div(l11, l13));
            l8 = MathFP.mul(l10 - this.Water_Vapor_Pressure - l5, MathFP.div(l12, l13));
            l7 = MathFP.mul(l3, MathFP.div(l11, l13));
            l6 = MathFP.mul(l3, MathFP.div(l12, l13));
        }
        for (int i = 0; i < 16; ++i) {
            this.Helium_Pressure[i] = this.SCHREINER_EQUATION(l9, l7, l4, this.Helium_Time_Constant[i], this.Helium_Pressure[i]);
            this.Nitrogen_Pressure[i] = this.SCHREINER_EQUATION(l8, l6, l4, this.Nitrogen_Time_Constant[i], this.Nitrogen_Pressure[i]);
        }
    }

    private long SCHREINER_EQUATION(long l, long l2, long l3, long l4, long l5) {
        return MathFP.mul(0x1000000L - MathFP.exp(-MathFP.mul(l4, l3)), l - MathFP.div(l2, l4) - l5) + MathFP.mul(l2, l3) + l5;
    }

    private void GAS_LOADINGS_CONSTANT_DEPTH(long l, int n, long l2, long l3) {
        long l4 = MathFP.add(l, this.Barometric_Pressure);
        long l5 = this.Fraction_Helium[n];
        long l6 = this.Fraction_Nitrogen[n];
        if (this.sd.JDeco_Type == 1 && !this.doCCRbailoutFlag) {
            long l7 = MathFP.div(l3, l4);
            long l8 = l5 + l6;
            l5 = MathFP.mul(0x1000000L - l7, MathFP.div(l5, l8));
            l6 = MathFP.mul(0x1000000L - l7, MathFP.div(l6, l8));
        }
        long l9 = MathFP.mul(MathFP.sub(l4, this.Water_Vapor_Pressure), l5);
        long l10 = MathFP.mul(MathFP.sub(l4, this.Water_Vapor_Pressure), l6);
        for (int i = 0; i < 16; ++i) {
            this.Helium_Pressure[i] = this.HALDANE_EQUATION(this.Helium_Pressure[i], l9, this.Helium_Time_Constant[i], l2);
            this.Nitrogen_Pressure[i] = this.HALDANE_EQUATION(this.Nitrogen_Pressure[i], l10, this.Nitrogen_Time_Constant[i], l2);
        }
    }

    private long HALDANE_EQUATION(long l, long l2, long l3, long l4) {
        long l5 = l2 - l;
        long l6 = 0x1000000L - MathFP.exp(-MathFP.mul(l3, l4));
        long l7 = l + MathFP.mul(l5, l6);
        return l7;
    }

    private void DIVEDATA_GAS_VOLUME_OTU_CNS(long l, long l2, long l3, long l4, int n, long l5) {
        long l6;
        long l7 = MathFP.div(MathFP.add(MathFP.div(MathFP.add(l, l2), MathFP.toFP(2)), this.Barometric_Pressure), this.Units_Factor);
        long l8 = MathFP.mul(MathFP.mul(l4, l3), l7);
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            this.Running_Gas_Volume[n] = MathFP.add(this.Running_Gas_Volume[n], l8);
        }
        if ((l6 = this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag ? MathFP.mul(this.Fraction_Oxygen[n], l7) : MathFP.div(l5, this.Units_Factor)) == this.PPO2axis[1]) {
            this.diveCNS += MathFP.mul(this.CNSvalues[1], l3);
            this.diveOTU += MathFP.mul(this.OTUvalues[1], l3);
        } else if (l6 >= this.PPO2axis[this.PPO2axis.length - 1]) {
            this.diveCNS += MathFP.mul(this.CNSvalues[this.PPO2axis.length - 1], l3);
            this.diveOTU += MathFP.mul(this.OTUvalues[this.PPO2axis.length - 1], l3);
        } else if (l6 > this.PPO2axis[1] && l6 < this.PPO2axis[this.PPO2axis.length - 1]) {
            for (int i = 2; i < this.PPO2axis.length; ++i) {
                if (l6 > this.PPO2axis[i]) continue;
                long l9 = MathFP.div(this.CNSvalues[i] - this.CNSvalues[i - 1], this.PPO2axis[i] - this.PPO2axis[i - 1]);
                long l10 = this.CNSvalues[i] - MathFP.mul(l9, this.PPO2axis[i]);
                long l11 = MathFP.div(this.OTUvalues[i] - this.OTUvalues[i - 1], this.PPO2axis[i] - this.PPO2axis[i - 1]);
                long l12 = this.OTUvalues[i] - MathFP.mul(l11, this.PPO2axis[i]);
                long l13 = MathFP.mul(l9, l6) + l10;
                long l14 = MathFP.mul(l11, l6) + l12;
                this.diveCNS += MathFP.mul(l13, l3);
                this.diveOTU += MathFP.mul(l14, l3);
                break;
            }
        }
    }

    private long CALC_START_OF_DECO_ZONE(long l, long l2, int n, long l3) {
        long l4;
        long l5;
        long l6;
        long l7;
        long l8 = 0L;
        long l9 = MathFP.add(l, this.Barometric_Pressure);
        long l10 = this.Fraction_Helium[n];
        long l11 = this.Fraction_Nitrogen[n];
        long l12 = l11 + l10;
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            l7 = MathFP.mul(MathFP.sub(l9, this.Water_Vapor_Pressure), l10);
            l6 = MathFP.mul(MathFP.sub(l9, this.Water_Vapor_Pressure), l11);
            l5 = MathFP.mul(l2, l10);
            l4 = MathFP.mul(l2, l11);
        } else {
            l7 = MathFP.mul(l9 - this.Water_Vapor_Pressure - l3, MathFP.div(l10, l12));
            l6 = MathFP.mul(l9 - this.Water_Vapor_Pressure - l3, MathFP.div(l11, l12));
            l5 = MathFP.mul(l2, MathFP.div(l10, l12));
            l4 = MathFP.mul(l2, MathFP.div(l11, l12));
        }
        long l13 = 0L;
        long l14 = -MathFP.div(l9, l2);
        long l15 = 0L;
        long l16 = 0L;
        for (int i = 0; i < 16; ++i) {
            long l17;
            long l18 = this.Helium_Pressure[i];
            long l19 = this.Nitrogen_Pressure[i];
            long l20 = MathFP.sub(MathFP.add(l18, l19), l9);
            long l21 = this.SCHREINER_EQUATION(l7, l5, l14, this.Helium_Time_Constant[i], l18);
            long l22 = MathFP.add(l21, l17 = this.SCHREINER_EQUATION(l6, l4, l14, this.Nitrogen_Time_Constant[i], l19));
            if (MathFP.mul(l22, l20) >= 0L) {
                return 99999L;
            }
            if (l20 < MathFP.toFP(0)) {
                l15 = l13;
                l16 = MathFP.sub(l14, l13);
            } else {
                l15 = l14;
                l16 = MathFP.sub(l13, l14);
            }
            boolean bl = false;
            for (int j = 1; j <= 100; ++j) {
                long l23;
                long l24 = l16;
                long l25 = MathFP.add(l15, l16 = MathFP.div(l24, MathFP.toFP(2)));
                long l26 = this.SCHREINER_EQUATION(l7, l5, l25, this.Helium_Time_Constant[i], l18);
                long l27 = MathFP.add(l26, MathFP.sub(l23 = this.SCHREINER_EQUATION(l6, l4, l25, this.Nitrogen_Time_Constant[i], l19), MathFP.add(l9, MathFP.mul(l2, l25))));
                if (l27 <= MathFP.toFP(0)) {
                    l15 = l25;
                }
                if (MathFP.abs(l16) >= MathFP.toFP("0.001") && l27 != MathFP.toFP(0)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 99998L;
            }
            long l28 = MathFP.sub(MathFP.add(l9, MathFP.mul(l2, l15)), this.Barometric_Pressure);
            if (l8 >= l28) continue;
            l8 = l28;
        }
        return l8;
    }

    private long CALC_DECO_CEILING(long l, long[] lArray, long[] lArray2) {
        long l2 = -this.Barometric_Pressure;
        for (int i = 0; i < 16; ++i) {
            long l3;
            long l4 = MathFP.add(lArray[i], lArray2[i]);
            long l5 = MathFP.div(MathFP.add(MathFP.mul(lArray[i], this.AHE[i]), MathFP.mul(lArray2[i], this.AN2[i])), l4);
            long l6 = MathFP.div(MathFP.add(MathFP.mul(lArray[i], this.BHE[i]), MathFP.mul(lArray2[i], this.BN2[i])), l4);
            long l7 = MathFP.div(MathFP.sub(l4, MathFP.mul(l5, l)), MathFP.sub(MathFP.div(l, l6), MathFP.sub(l, MathFP.toFP(1))));
            if (l7 < MathFP.toFP(0)) {
                l7 = MathFP.toFP(0);
            }
            if ((l3 = MathFP.sub(l7, this.Barometric_Pressure)) <= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    private long PROJECTED_ASCENT(long l, long l2, long l3, long l4, int n, long l5, long l6) {
        int n2;
        long l7;
        long l8;
        long l9;
        long l10;
        long[] lArray = new long[16];
        long[] lArray2 = new long[16];
        long[] lArray3 = new long[16];
        long[] lArray4 = new long[16];
        long l11 = MathFP.add(l3, this.Barometric_Pressure);
        long l12 = MathFP.add(l, this.Barometric_Pressure);
        long l13 = this.Fraction_Helium[n];
        long l14 = this.Fraction_Nitrogen[n];
        long l15 = l14 + l13;
        if (this.sd.JDeco_Type == 0 || this.doCCRbailoutFlag) {
            l10 = MathFP.mul(MathFP.sub(l12, this.Water_Vapor_Pressure), l13);
            l9 = MathFP.mul(MathFP.sub(l12, this.Water_Vapor_Pressure), l14);
            l8 = MathFP.mul(l2, l13);
            l7 = MathFP.mul(l2, l14);
        } else {
            l10 = MathFP.mul(l12 - this.Water_Vapor_Pressure - l6, MathFP.div(l13, l15));
            l9 = MathFP.mul(l12 - this.Water_Vapor_Pressure - l6, MathFP.div(l14, l15));
            l8 = MathFP.mul(l2, MathFP.div(l13, l15));
            l7 = MathFP.mul(l2, MathFP.div(l14, l15));
        }
        for (n2 = 0; n2 < 16; ++n2) {
            lArray[n2] = this.Helium_Pressure[n2];
            lArray2[n2] = this.Nitrogen_Pressure[n2];
        }
        n2 = 1;
        while (n2 != 0) {
            int n3;
            n2 = 0;
            long l16 = l11;
            long l17 = MathFP.div(MathFP.sub(l16, l12), l2);
            for (n3 = 0; n3 < 16; ++n3) {
                long l18 = this.SCHREINER_EQUATION(l10, l8, l17, this.Helium_Time_Constant[n3], lArray[n3]);
                long l19 = this.SCHREINER_EQUATION(l9, l7, l17, this.Nitrogen_Time_Constant[n3], lArray2[n3]);
                lArray3[n3] = MathFP.add(l18, l19);
                long l20 = MathFP.div(MathFP.add(MathFP.mul(l18, this.AHE[n3]), MathFP.mul(l19, this.AN2[n3])), MathFP.add(l18, l19));
                long l21 = MathFP.div(MathFP.add(MathFP.mul(l18, this.BHE[n3]), MathFP.mul(l19, this.BN2[n3])), MathFP.add(l18, l19));
                lArray4[n3] = MathFP.add(MathFP.mul(l16, MathFP.sub(MathFP.div(l5, l21), MathFP.sub(l5, MathFP.toFP(1)))), MathFP.mul(l5, l20));
            }
            for (n3 = 0; n3 < 16; ++n3) {
                if (lArray3[n3] <= lArray4[n3]) continue;
                l11 = MathFP.add(l16, l4);
                l3 = MathFP.add(l3, l4);
                n2 = 1;
            }
        }
        return l3;
    }

    private long DECOMPRESSION_STOP(long l, long l2, long l3, int n, long l4, long l5) {
        long l6 = MathFP.add(l, this.Barometric_Pressure);
        long l7 = this.Fraction_Helium[n];
        long l8 = this.Fraction_Nitrogen[n];
        if (this.sd.JDeco_Type == 1 && !this.doCCRbailoutFlag) {
            long l9 = MathFP.div(l5, l6);
            long l10 = l7 + l8;
            l7 = MathFP.mul(0x1000000L - l9, MathFP.div(l7, l10));
            l8 = MathFP.mul(0x1000000L - l9, MathFP.div(l8, l10));
        }
        long l11 = MathFP.mul(MathFP.sub(l6, this.Water_Vapor_Pressure), l7);
        long l12 = MathFP.mul(MathFP.sub(l6, this.Water_Vapor_Pressure), l8);
        long l13 = MathFP.sub(l, l2);
        boolean bl = true;
        long l14 = l3;
        while (bl) {
            bl = false;
            for (int i = 0; i < 16; ++i) {
                this.Helium_Pressure[i] = this.HALDANE_EQUATION(this.Helium_Pressure[i], l11, this.Helium_Time_Constant[i], l3);
                this.Nitrogen_Pressure[i] = this.HALDANE_EQUATION(this.Nitrogen_Pressure[i], l12, this.Nitrogen_Time_Constant[i], l3);
            }
            long l15 = this.CALC_DECO_CEILING(l4, this.Helium_Pressure, this.Nitrogen_Pressure);
            if (l15 > l13) {
                l3 = MathFP.toFP(this.sd.Minimum_Deco_Stop_Time);
                l14 = MathFP.add(l14, MathFP.toFP(this.sd.Minimum_Deco_Stop_Time));
                bl = true;
            }
            if (l14 <= MathFP.toFP(2000)) continue;
            return 99999L;
        }
        return l14;
    }

    private void GAS_LOADINGS_CNS_SURFACE_INTERVAL(long l) {
        long l2 = MathFP.toFP(0);
        long l3 = MathFP.mul(MathFP.sub(this.Barometric_Pressure, this.Water_Vapor_Pressure), MathFP.toFP("0.79"));
        for (int i = 0; i < 16; ++i) {
            this.Helium_Pressure[i] = this.HALDANE_EQUATION(this.Helium_Pressure[i], l2, this.Helium_Time_Constant[i], l);
            this.Nitrogen_Pressure[i] = this.HALDANE_EQUATION(this.Nitrogen_Pressure[i], l3, this.Nitrogen_Time_Constant[i], l);
        }
        long l4 = MathFP.toFP("0.00770163");
        this.diveCNS = MathFP.mul(this.diveCNS, MathFP.exp(-MathFP.mul(l4, l)));
    }

    private long CORRECT_PPO2(long l, long l2, long l3) {
        long l4 = l + this.Barometric_Pressure;
        long l5 = this.Fraction_Oxygen[(int)l2];
        long l6 = MathFP.mul(l4 - this.Water_Vapor_Pressure, l5);
        if (l6 > l3) {
            return l6;
        }
        return l3;
    }
}

