/*
 * Decompiled with CFR 0.152.
 */
package JDeco;

import JDeco.JDeco;
import JDeco.MathFP;
import JDeco.UserInterface;

public class GasMixing
extends Thread {
    private boolean running = true;
    public boolean calculationReady = false;
    private long[][] aasqrt = new long[][]{{MathFP.toFP("0.03460000"), MathFP.toFP("0.21772000"), MathFP.toFP("0.21867144"), MathFP.toFP("0.21791856")}, {MathFP.toFP("0.21772000"), MathFP.toFP("1.37000000"), MathFP.toFP("1.37598692"), MathFP.toFP("1.37124943")}, {MathFP.toFP("0.21867144"), MathFP.toFP("1.37598692"), MathFP.toFP("1.38200000"), MathFP.toFP("1.37724181")}, {MathFP.toFP("0.21791856"), MathFP.toFP("1.37124943"), MathFP.toFP("1.37724181"), MathFP.toFP("1.37250000")}};
    private long[][] bbsqrt = new long[][]{{MathFP.toFP("0.02380000"), MathFP.toFP("0.03034897"), MathFP.toFP("0.02751073"), MathFP.toFP("0.02975500")}, {MathFP.toFP("0.03034897"), MathFP.toFP("0.03870000"), MathFP.toFP("0.03508076"), MathFP.toFP("0.03794259")}, {MathFP.toFP("0.02751073"), MathFP.toFP("0.03508076"), MathFP.toFP("0.03180000"), MathFP.toFP("0.03439419")}, {MathFP.toFP("0.02975500"), MathFP.toFP("0.03794259"), MathFP.toFP("0.03439419"), MathFP.toFP("0.03720000")}};
    private long R = MathFP.toFP("0.08314472");
    private int numberGases = 4;
    private JDeco jd;
    private UserInterface ui;
    private long O2Top;
    private long HeTop;
    private long O2End;
    private long HeEnd;
    private long PEnd;
    private long O2Start;
    private long HeStart;
    private long PStart;
    private long T;
    private long V;
    private boolean O2First;
    private long a_global;
    private long b_global;
    private long[] n_global = new long[]{0L, 0L, 0L, 0L};
    private long[] PFill = new long[]{0L, 0L, 0L, 0L};
    private long[] FFill = new long[]{0L, 0L, 0L, 0L};
    public boolean doMix;
    public long[] PMixData = new long[]{0L, 0L, 0L};
    public long[] PTopData = new long[]{0L, 0L};

    public GasMixing(JDeco jDeco, UserInterface userInterface, String string) {
        this.jd = jDeco;
        this.ui = userInterface;
        this.doMix = string.equals("mix");
        this.O2Start = MathFP.toFP(this.ui.mixO2Start);
        this.HeStart = MathFP.toFP(this.ui.mixHeStart);
        this.PStart = MathFP.toFP(this.ui.mixPStart);
        this.PEnd = MathFP.toFP(this.ui.mixPEnd);
        this.O2First = this.ui.mixO2First;
        this.T = MathFP.toFP(this.ui.mixT + 273L);
        this.V = MathFP.toFP(this.ui.mixV);
        if (this.doMix) {
            this.O2End = MathFP.toFP(this.ui.mixO2End);
            this.HeEnd = MathFP.toFP(this.ui.mixHeEnd);
        } else {
            this.O2Top = MathFP.toFP(this.ui.mixO2Top);
            this.HeTop = MathFP.toFP(this.ui.mixHeTop);
        }
    }

    public void run() {
        this.running = true;
        this.doCalc();
        while (this.running) {
            try {
                GasMixing.sleep(100L);
            }
            catch (Throwable throwable) {}
        }
    }

    public void stopIt() {
        this.aasqrt = null;
        this.bbsqrt = null;
        this.running = false;
    }

    private void doCalc() {
        this.calculationReady = false;
        if (this.doMix) {
            this.calcMix();
            this.PMixData[0] = MathFP.toLong(MathFP.floor(this.PFill[0]));
            this.PMixData[1] = MathFP.toLong(MathFP.floor(this.PFill[2]));
            this.PMixData[2] = MathFP.toLong(this.PEnd);
        } else {
            this.calcTop();
            this.PTopData[0] = MathFP.toLong(MathFP.floor(MathFP.mul(this.FFill[0], MathFP.toFP(100))));
            this.PTopData[1] = MathFP.toLong(MathFP.ceil(MathFP.mul(this.FFill[2], MathFP.toFP(100)) - MathFP.toFP("0.01")));
        }
        this.calculationReady = true;
    }

    private void calcMix() {
        int n;
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        long[] lArray2 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray3 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray4 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray5 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray6 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray7 = new long[]{0L, 0L, 0L, 0L};
        lArray6[0] = MathFP.div(this.HeStart, MathFP.toFP(100));
        lArray6[1] = MathFP.div(MathFP.toFP(100) - this.HeStart - this.O2Start, MathFP.toFP(100));
        lArray6[2] = MathFP.div(this.O2Start, MathFP.toFP(100));
        lArray6[3] = 0L;
        lArray7[0] = MathFP.div(this.HeEnd, MathFP.toFP(100));
        lArray7[1] = MathFP.div(MathFP.toFP(100) - this.HeEnd - this.O2End, MathFP.toFP(100));
        lArray7[2] = MathFP.div(this.O2End, MathFP.toFP(100));
        lArray7[3] = 0L;
        this.getAB(lArray6);
        long l = this.a_global;
        long l2 = this.b_global;
        this.getN(lArray6, this.PStart, l, l2);
        this.convertN2Air(this.n_global);
        lArray[0] = this.n_global[0];
        lArray[1] = this.n_global[1];
        lArray[2] = this.n_global[2];
        lArray[3] = this.n_global[3];
        this.getAB(lArray7);
        long l3 = this.a_global;
        long l4 = this.b_global;
        this.getN(lArray7, this.PEnd, l3, l4);
        this.convertN2Air(this.n_global);
        lArray2[0] = this.n_global[0];
        lArray2[1] = this.n_global[1];
        lArray2[2] = this.n_global[2];
        lArray2[3] = this.n_global[3];
        for (n = 0; n < this.numberGases; ++n) {
            lArray3[n] = lArray2[n] - lArray[n];
            if (lArray3[n] >= 0L) continue;
            this.ui.computationError = "Not possible. Please try lower start pressure!";
            this.calculationReady = true;
        }
        for (n = 0; n < this.numberGases; ++n) {
            lArray4[n] = lArray[n];
        }
        for (int i = 0; i < this.numberGases; ++i) {
            n = this.O2First ? (i == 0 ? 2 : (i == 2 ? 0 : i)) : i;
            if (lArray3[n] != 0L) {
                lArray4[n] = lArray4[n] + lArray3[n];
                long l5 = lArray4[0] + lArray4[1] + lArray4[2] + lArray4[3];
                lArray5[0] = MathFP.div(lArray4[0], l5);
                lArray5[1] = MathFP.div(lArray4[1], l5);
                lArray5[2] = MathFP.div(lArray4[2], l5);
                lArray5[3] = MathFP.div(lArray4[3], l5);
                this.getAB(lArray5);
                long l6 = this.a_global;
                long l7 = this.b_global;
                this.PFill[n] = MathFP.div(MathFP.mul(l5, MathFP.mul(this.R, this.T)), this.V - MathFP.mul(l5, l7)) - MathFP.mul(l6, MathFP.mul(MathFP.div(l5, this.V), MathFP.div(l5, this.V)));
                continue;
            }
            this.PFill[n] = 0L;
        }
    }

    private void calcTop() {
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        long[] lArray2 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray3 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray4 = new long[]{0L, 0L, 0L, 0L};
        lArray3[0] = MathFP.div(this.HeStart, MathFP.toFP(100));
        lArray3[1] = MathFP.div(MathFP.toFP(100) - this.HeStart - this.O2Start, MathFP.toFP(100));
        lArray3[2] = MathFP.div(this.O2Start, MathFP.toFP(100));
        lArray3[3] = 0L;
        lArray4[0] = MathFP.div(this.HeTop, MathFP.toFP(100));
        lArray4[1] = MathFP.div(MathFP.toFP(100) - this.HeTop - this.O2Top, MathFP.toFP(100));
        lArray4[2] = MathFP.div(this.O2Top, MathFP.toFP(100));
        lArray4[3] = 0L;
        this.getAB(lArray3);
        long l = this.a_global;
        long l2 = this.b_global;
        this.getN(lArray3, this.PStart, l, l2);
        lArray[0] = this.n_global[0];
        lArray[1] = this.n_global[1];
        lArray[2] = this.n_global[2];
        lArray[3] = this.n_global[3];
        long l3 = 0L;
        long l4 = 0L;
        long l5 = this.getPx(lArray, lArray4, l3);
        while (l5 < this.PEnd) {
            l4 = l3;
            l5 = this.getPx(lArray, lArray4, l3 += MathFP.toFP(50));
        }
        long l6 = this.getPx(lArray, lArray4, l4);
        long l7 = MathFP.div(l3 + l4, MathFP.toFP(2));
        long l8 = this.getPx(lArray, lArray4, l7);
        while (MathFP.abs(l8 - this.PEnd) > MathFP.toFP("0.001")) {
            if (l8 > this.PEnd) {
                l3 = l7;
            } else {
                l4 = l7;
            }
            l7 = MathFP.div(l3 + l4, MathFP.toFP(2));
            l8 = this.getPx(lArray, lArray4, l7);
        }
        lArray2[0] = lArray[0] + MathFP.mul(l7, lArray4[0]);
        lArray2[1] = lArray[1] + MathFP.mul(l7, lArray4[1]);
        lArray2[2] = lArray[2] + MathFP.mul(l7, lArray4[2]);
        lArray2[3] = lArray[3] + MathFP.mul(l7, lArray4[3]);
        this.FFill[0] = MathFP.div(lArray2[0], lArray2[0] + lArray2[1] + lArray2[2] + lArray2[3]);
        this.FFill[1] = MathFP.div(lArray2[1], lArray2[0] + lArray2[1] + lArray2[2] + lArray2[3]);
        this.FFill[2] = MathFP.div(lArray2[2], lArray2[0] + lArray2[1] + lArray2[2] + lArray2[3]);
        this.FFill[3] = MathFP.div(lArray2[3], lArray2[0] + lArray2[1] + lArray2[2] + lArray2[3]);
    }

    private long getPx(long[] lArray, long[] lArray2, long l) {
        int n;
        long[] lArray3 = new long[]{0L, 0L, 0L, 0L};
        long[] lArray4 = new long[]{0L, 0L, 0L, 0L};
        for (n = 0; n < this.numberGases; ++n) {
            lArray3[n] = lArray[n] + MathFP.mul(l, lArray2[n]);
        }
        long l2 = lArray3[0] + lArray3[1] + lArray3[2] + lArray3[3];
        for (n = 0; n < this.numberGases; ++n) {
            lArray4[n] = MathFP.div(lArray3[n], l2);
        }
        this.getAB(lArray4);
        long l3 = this.a_global;
        long l4 = this.b_global;
        return MathFP.div(MathFP.mul(l2, MathFP.mul(this.R, this.T)), this.V - MathFP.mul(l2, l4)) - MathFP.mul(l3, MathFP.mul(MathFP.div(l2, this.V), MathFP.div(l2, this.V)));
    }

    private void convertN2Air(long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = MathFP.div(l2, MathFP.toFP("0.79"));
        long l5 = l3 - MathFP.mul(l4, MathFP.toFP("0.21"));
        this.n_global[0] = l;
        this.n_global[1] = 0L;
        this.n_global[2] = l5;
        this.n_global[3] = l4;
    }

    private void getAB(long[] lArray) {
        this.a_global = 0L;
        this.b_global = 0L;
        for (int i = 0; i < this.numberGases; ++i) {
            for (int j = 0; j < this.numberGases; ++j) {
                this.a_global += MathFP.mul(MathFP.mul(lArray[i], lArray[j]), this.aasqrt[i][j]);
                this.b_global += MathFP.mul(MathFP.mul(lArray[i], lArray[j]), this.bbsqrt[i][j]);
            }
        }
    }

    private void getN(long[] lArray, long l, long l2, long l3) {
        int n;
        long l4 = MathFP.toFP(1);
        boolean bl = false;
        for (n = 0; n < 100; ++n) {
            long l5 = MathFP.mul(l + MathFP.mul(l2, MathFP.mul(MathFP.div(l4, this.V), MathFP.div(l4, this.V))), this.V - MathFP.mul(l4, l3)) - MathFP.mul(MathFP.mul(l4, this.R), this.T);
            long l6 = -MathFP.mul(l, l3) + MathFP.mul(2L, MathFP.mul(l2, MathFP.div(l4, this.V))) - MathFP.mul(MathFP.mul(MathFP.mul(3L, l2), l3), MathFP.mul(MathFP.div(l4, this.V), MathFP.div(l4, this.V))) - MathFP.mul(this.R, this.T);
            l4 -= MathFP.div(l5, l6);
            if (l5 >= MathFP.toFP("0.00001")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.ui.computationError = "Iteration failed!";
            this.calculationReady = true;
        } else {
            for (n = 0; n < this.numberGases; ++n) {
                this.n_global[n] = MathFP.mul(l4, lArray[n]);
            }
        }
    }
}

